# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementDomainsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_get(self, resource_group):
        response = self.client.domains.get(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_create_or_update(self, resource_group):
        response = self.client.domains.begin_create_or_update(
            resource_group_name=resource_group.name,
            domain_name="str",
            domain_info={
                "location": "str",
                "autoCreateTopicWithFirstSubscription": True,
                "autoDeleteTopicWithLastSubscription": True,
                "dataResidencyBoundary": "str",
                "disableLocalAuth": False,
                "endpoint": "str",
                "eventTypeInfo": {
                    "inlineEventTypes": {
                        "str": {
                            "dataSchemaUrl": "str",
                            "description": "str",
                            "displayName": "str",
                            "documentationUrl": "str",
                        }
                    },
                    "kind": "str",
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "inputSchema": "str",
                "inputSchemaMapping": "input_schema_mapping",
                "metricResourceId": "str",
                "minimumTlsVersionAllowed": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "sku": {"name": "Basic"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_delete(self, resource_group):
        response = self.client.domains.begin_delete(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_update(self, resource_group):
        response = self.client.domains.begin_update(
            resource_group_name=resource_group.name,
            domain_name="str",
            domain_update_parameters={
                "autoCreateTopicWithFirstSubscription": bool,
                "autoDeleteTopicWithLastSubscription": bool,
                "dataResidencyBoundary": "str",
                "disableLocalAuth": bool,
                "eventTypeInfo": {
                    "inlineEventTypes": {
                        "str": {
                            "dataSchemaUrl": "str",
                            "description": "str",
                            "displayName": "str",
                            "documentationUrl": "str",
                        }
                    },
                    "kind": "str",
                },
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "minimumTlsVersionAllowed": "str",
                "publicNetworkAccess": "str",
                "sku": {"name": "Basic"},
                "tags": {"str": "str"},
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_list_by_subscription(self, resource_group):
        response = self.client.domains.list_by_subscription(
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_list_by_resource_group(self, resource_group):
        response = self.client.domains.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_list_shared_access_keys(self, resource_group):
        response = self.client.domains.list_shared_access_keys(
            resource_group_name=resource_group.name,
            domain_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_regenerate_key(self, resource_group):
        response = self.client.domains.regenerate_key(
            resource_group_name=resource_group.name,
            domain_name="str",
            regenerate_key_request={"keyName": "str"},
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...
