# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtVirtualEnclaveOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_get(self, resource_group):
        response = self.client.virtual_enclave.get(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_begin_create_or_update(self, resource_group):
        response = self.client.virtual_enclave.begin_create_or_update(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "communityResourceId": "str",
                    "enclaveVirtualNetwork": {
                        "allowSubnetCommunication": bool,
                        "customCidrRange": "str",
                        "networkName": "str",
                        "networkSize": "str",
                        "subnetConfigurations": [
                            {
                                "networkPrefixSize": 0,
                                "subnetName": "str",
                                "addressPrefix": "str",
                                "networkSecurityGroupResourceId": "str",
                                "subnetDelegation": "str",
                                "subnetResourceId": "str",
                            }
                        ],
                    },
                    "bastionEnabled": bool,
                    "enclaveAddressSpaces": {"enclaveAddressSpace": "str", "managedAddressSpace": "str"},
                    "enclaveDefaultSettings": {
                        "diagnosticDestination": "str",
                        "keyVaultResourceId": "str",
                        "logAnalyticsResourceIdCollection": ["str"],
                        "storageAccountResourceId": "str",
                    },
                    "enclaveRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                    "governedServiceList": [
                        {
                            "serviceId": "str",
                            "enforcement": "Enabled",
                            "initiatives": ["str"],
                            "option": "Allow",
                            "policyAction": "AuditOnly",
                            "serviceName": "str",
                        }
                    ],
                    "maintenanceModeConfiguration": {
                        "mode": "On",
                        "justification": "Networking",
                        "principals": [{"id": "str", "type": "User"}],
                    },
                    "managedOnBehalfOfConfiguration": {"moboBrokerResources": [{"id": "str"}]},
                    "managedResourceGroupName": "str",
                    "provisioningState": "str",
                    "resourceCollection": ["str"],
                    "workloadRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_begin_update(self, resource_group):
        response = self.client.virtual_enclave.begin_update(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "enclaveVirtualNetwork": {
                        "allowSubnetCommunication": bool,
                        "customCidrRange": "str",
                        "networkName": "str",
                        "networkSize": "str",
                        "subnetConfigurations": [
                            {
                                "networkPrefixSize": 0,
                                "subnetName": "str",
                                "addressPrefix": "str",
                                "networkSecurityGroupResourceId": "str",
                                "subnetDelegation": "str",
                                "subnetResourceId": "str",
                            }
                        ],
                    },
                    "bastionEnabled": bool,
                    "enclaveDefaultSettings": {"diagnosticDestination": "str"},
                    "enclaveRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                    "governedServiceList": [
                        {
                            "serviceId": "str",
                            "enforcement": "Enabled",
                            "initiatives": ["str"],
                            "option": "Allow",
                            "policyAction": "AuditOnly",
                            "serviceName": "str",
                        }
                    ],
                    "maintenanceModeConfiguration": {
                        "mode": "On",
                        "justification": "Networking",
                        "principals": [{"id": "str", "type": "User"}],
                    },
                    "workloadRoleAssignments": [
                        {"roleDefinitionId": "str", "principals": [{"id": "str", "type": "User"}]}
                    ],
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_begin_delete(self, resource_group):
        response = self.client.virtual_enclave.begin_delete(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_list_by_resource_group(self, resource_group):
        response = self.client.virtual_enclave.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_list_by_subscription(self, resource_group):
        response = self.client.virtual_enclave.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_begin_handle_approval_creation(self, resource_group):
        response = self.client.virtual_enclave.begin_handle_approval_creation(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
            body={"approvalStatus": "Approved", "resourceRequestAction": "Create", "approvalCallbackPayload": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_enclave_begin_handle_approval_deletion(self, resource_group):
        response = self.client.virtual_enclave.begin_handle_approval_deletion(
            resource_group_name=resource_group.name,
            virtual_enclave_name="str",
            body={"resourceRequestAction": "Create"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
