
; KERNEL32.DLL structures and constants

struct SYSTEM_INFO
  wProcessorArchitecture      dw ?
  wReserved		      dw ?
  dwPageSize		      dd ?
  lpMinimumApplicationAddress dd ?
  lpMaximumApplicationAddress dd ?
  dwActiveProcessorMask       dd ?
  dwNumberOfProcessors	      dd ?
  dwProcessorType	      dd ?
  dwAllocationGranularity     dd ?
  wProcessorLevel	      dw ?
  wProcessorRevision	      dw ?
ends

struct OSVERSIONINFO
  dwOSVersionInfoSize dd ?
  dwMajorVersion      dd ?
  dwMinorVersion      dd ?
  dwBuildNumber       dd ?
  dwPlatformId	      dd ?
  szCSDVersion	      TCHAR 128 dup (?)
ends

struct OSVERSIONINFOA
  dwOSVersionInfoSize dd ?
  dwMajorVersion      dd ?
  dwMinorVersion      dd ?
  dwBuildNumber       dd ?
  dwPlatformId	      dd ?
  szCSDVersion	      db 128 dup (?)
ends

struct OSVERSIONINFOW
  dwOSVersionInfoSize dd ?
  dwMajorVersion      dd ?
  dwMinorVersion      dd ?
  dwBuildNumber       dd ?
  dwPlatformId	      dd ?
  szCSDVersion	      du 128 dup (?)
ends

struct MEMORYSTATUS
  dwLength	  dd ?
  dwMemoryLoad	  dd ?
  dwTotalPhys	  dd ?
  dwAvailPhys	  dd ?
  dwTotalPageFile dd ?
  dwAvailPageFile dd ?
  dwTotalVirtual  dd ?
  dwAvailVirtual  dd ?
ends

struct STARTUPINFO
  cb		  dd ?
  lpReserved	  dd ?
  lpDesktop	  dd ?
  lpTitle	  dd ?
  dwX		  dd ?
  dwY		  dd ?
  dwXSize	  dd ?
  dwYSize	  dd ?
  dwXCountChars   dd ?
  dwYCountChars   dd ?
  dwFillAttribute dd ?
  dwFlags	  dd ?
  wShowWindow	  dw ?
  cbReserved2	  dw ?
  lpReserved2	  dd ?
  hStdInput	  dd ?
  hStdOutput	  dd ?
  hStdError	  dd ?
ends

struct PROCESS_INFORMATION
  hProcess    dd ?
  hThread     dd ?
  dwProcessId dd ?
  dwThreadId  dd ?
ends

struct FILETIME
  dwLowDateTime  dd ?
  dwHighDateTime dd ?
ends

struct SYSTEMTIME
  wYear 	dw ?
  wMonth	dw ?
  wDayOfWeek	dw ?
  wDay		dw ?
  wHour 	dw ?
  wMinute	dw ?
  wSecond	dw ?
  wMilliseconds dw ?
ends

struct BY_HANDLE_FILE_INFORMATION
  dwFileAttributes     dd ?
  ftCreationTime       FILETIME
  ftLastAccessTime     FILETIME
  ftLastWriteTime      FILETIME
  dwVolumeSerialNumber dd ?
  nFileSizeHigh        dd ?
  nFileSizeLow	       dd ?
  nNumberOfLinks       dd ?
  nFileIndexHigh       dd ?
  nFileIndexLow        dd ?
ends

struct WIN32_FIND_DATA
  dwFileAttributes   dd ?
  ftCreationTime     FILETIME
  ftLastAccessTime   FILETIME
  ftLastWriteTime    FILETIME
  nFileSizeHigh      dd ?
  nFileSizeLow	     dd ?
  dwReserved0	     dd ?
  dwReserved1	     dd ?
  cFileName	     TCHAR MAX_PATH dup (?)
  cAlternateFileName TCHAR 14 dup (?)
ends

struct WIN32_FIND_DATAA
  dwFileAttributes   dd ?
  ftCreationTime     FILETIME
  ftLastAccessTime   FILETIME
  ftLastWriteTime    FILETIME
  nFileSizeHigh      dd ?
  nFileSizeLow	     dd ?
  dwReserved0	     dd ?
  dwReserved1	     dd ?
  cFileName	     db MAX_PATH dup (?)
  cAlternateFileName db 14 dup (?)
ends

struct WIN32_FIND_DATAW
  dwFileAttributes   dd ?
  ftCreationTime     FILETIME
  ftLastAccessTime   FILETIME
  ftLastWriteTime    FILETIME
  nFileSizeHigh      dd ?
  nFileSizeLow	     dd ?
  dwReserved0	     dd ?
  dwReserved1	     dd ?
  cFileName	     du MAX_PATH dup (?)
  cAlternateFileName du 14 dup (?)
ends

; General constants

NULL  = 0
TRUE  = 1
FALSE = 0

; Maximum path length in characters

MAX_PATH = 260

; Access rights

DELETE_RIGHT		  = 00010000h
READ_CONTROL		  = 00020000h
WRITE_DAC		  = 00040000h
WRITE_OWNER		  = 00080000h
SYNCHRONIZE		  = 00100000h
STANDARD_RIGHTS_READ	  = READ_CONTROL
STANDARD_RIGHTS_WRITE	  = READ_CONTROL
STANDARD_RIGHTS_EXECUTE   = READ_CONTROL
STANDARD_RIGHTS_REQUIRED  = 000F0000h
STANDARD_RIGHTS_ALL	  = 001F0000h
SPECIFIC_RIGHTS_ALL	  = 0000FFFFh
ACCESS_SYSTEM_SECURITY	  = 01000000h
MAXIMUM_ALLOWED 	  = 02000000h
GENERIC_READ		  = 80000000h
GENERIC_WRITE		  = 40000000h
GENERIC_EXECUTE 	  = 20000000h
GENERIC_ALL		  = 10000000h
PROCESS_TERMINATE	  = 00000001h
PROCESS_CREATE_THREAD	  = 00000002h
PROCESS_VM_OPERATION	  = 00000008h
PROCESS_VM_READ 	  = 00000010h
PROCESS_VM_WRITE	  = 00000020h
PROCESS_DUP_HANDLE	  = 00000040h
PROCESS_CREATE_PROCESS	  = 00000080h
PROCESS_SET_QUOTA	  = 00000100h
PROCESS_SET_INFORMATION   = 00000200h
PROCESS_QUERY_INFORMATION = 00000400h
PROCESS_ALL_ACCESS	  = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 0FFFh
FILE_SHARE_READ 	  = 00000001h
FILE_SHARE_WRITE	  = 00000002h
FILE_SHARE_DELETE	  = 00000004h

; CreateFile actions

CREATE_NEW	  = 1
CREATE_ALWAYS	  = 2
OPEN_EXISTING	  = 3
OPEN_ALWAYS	  = 4
TRUNCATE_EXISTING = 5

; OpenFile modes

OF_READ 	    = 0000h
OF_WRITE	    = 0001h
OF_READWRITE	    = 0002h
OF_SHARE_COMPAT     = 0000h
OF_SHARE_EXCLUSIVE  = 0010h
OF_SHARE_DENY_WRITE = 0020h
OF_SHARE_DENY_READ  = 0030h
OF_SHARE_DENY_NONE  = 0040h
OF_PARSE	    = 0100h
OF_DELETE	    = 0200h
OF_VERIFY	    = 0400h
OF_CANCEL	    = 0800h
OF_CREATE	    = 1000h
OF_PROMPT	    = 2000h
OF_EXIST	    = 4000h
OF_REOPEN	    = 8000h

; SetFilePointer methods

FILE_BEGIN   = 0
FILE_CURRENT = 1
FILE_END     = 2

; File attributes

FILE_ATTRIBUTE_READONLY   = 001h
FILE_ATTRIBUTE_HIDDEN	  = 002h
FILE_ATTRIBUTE_SYSTEM	  = 004h
FILE_ATTRIBUTE_DIRECTORY  = 010h
FILE_ATTRIBUTE_ARCHIVE	  = 020h
FILE_ATTRIBUTE_NORMAL	  = 080h
FILE_ATTRIBUTE_TEMPORARY  = 100h
FILE_ATTRIBUTE_COMPRESSED = 800h

; File flags

FILE_FLAG_WRITE_THROUGH    = 80000000h
FILE_FLAG_OVERLAPPED	   = 40000000h
FILE_FLAG_NO_BUFFERING	   = 20000000h
FILE_FLAG_RANDOM_ACCESS    = 10000000h
FILE_FLAG_SEQUENTIAL_SCAN  = 08000000h
FILE_FLAG_DELETE_ON_CLOSE  = 04000000h
FILE_FLAG_BACKUP_SEMANTICS = 02000000h
FILE_FLAG_POSIX_SEMANTICS  = 01000000h

; Notify filters

FILE_NOTIFY_CHANGE_FILE_NAME  = 001h
FILE_NOTIFY_CHANGE_DIR_NAME   = 002h
FILE_NOTIFY_CHANGE_ATTRIBUTES = 004h
FILE_NOTIFY_CHANGE_SIZE       = 008h
FILE_NOTIFY_CHANGE_LAST_WRITE = 010h
FILE_NOTIFY_CHANGE_SECURITY   = 100h

; File types

FILE_TYPE_UNKNOWN = 0
FILE_TYPE_DISK	  = 1
FILE_TYPE_CHAR	  = 2
FILE_TYPE_PIPE	  = 3
FILE_TYPE_REMOTE  = 8000h

; LockFileEx flags

LOCKFILE_FAIL_IMMEDIATELY = 1
LOCKFILE_EXCLUSIVE_LOCK   = 2

; MoveFileEx flags

MOVEFILE_REPLACE_EXISTING   = 1
MOVEFILE_COPY_ALLOWED	    = 2
MOVEFILE_DELAY_UNTIL_REBOOT = 4
MOVEFILE_WRITE_THROUGH	    = 8

; FindFirstFileEx flags

FIND_FIRST_EX_CASE_SENSITIVE = 1

; Device handles

INVALID_HANDLE_VALUE = -1
STD_INPUT_HANDLE     = -10
STD_OUTPUT_HANDLE    = -11
STD_ERROR_HANDLE     = -12

; DuplicateHandle options

DUPLICATE_CLOSE_SOURCE = 1
DUPLICATE_SAME_ACCESS  = 2

; File mapping acccess rights

SECTION_QUERY	    = 01h
SECTION_MAP_WRITE   = 02h
SECTION_MAP_READ    = 04h
SECTION_MAP_EXECUTE = 08h
SECTION_EXTEND_SIZE = 10h
SECTION_ALL_ACCESS  = STANDARD_RIGHTS_REQUIRED or SECTION_QUERY or SECTION_MAP_WRITE or SECTION_MAP_READ or SECTION_MAP_EXECUTE or SECTION_EXTEND_SIZE
FILE_MAP_COPY	    = SECTION_QUERY
FILE_MAP_WRITE	    = SECTION_MAP_WRITE
FILE_MAP_READ	    = SECTION_MAP_READ
FILE_MAP_ALL_ACCESS = SECTION_ALL_ACCESS

; File system flags

FILE_CASE_SENSITIVE_SEARCH = 0001h
FILE_CASE_PRESERVED_NAMES  = 0002h
FILE_UNICODE_ON_DISK	   = 0004h
FILE_PERSISTENT_ACLS	   = 0008h
FILE_FILE_COMPRESSION	   = 0010h
FILE_VOLUME_IS_COMPRESSED  = 8000h
FS_CASE_IS_PRESERVED	   = FILE_CASE_PRESERVED_NAMES
FS_CASE_SENSITIVE	   = FILE_CASE_SENSITIVE_SEARCH
FS_UNICODE_STORED_ON_DISK  = FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS	   = FILE_PERSISTENT_ACLS

; Drive types

DRIVE_UNKNOWN	  = 0
DRIVE_NO_ROOT_DIR = 1
DRIVE_REMOVABLE   = 2
DRIVE_FIXED	  = 3
DRIVE_REMOTE	  = 4
DRIVE_CDROM	  = 5
DRIVE_RAMDISK	  = 6

; Pipe modes

PIPE_ACCESS_INBOUND	 = 1
PIPE_ACCESS_OUTBOUND	 = 2
PIPE_ACCESS_DUPLEX	 = 3
PIPE_CLIENT_END 	 = 0
PIPE_SERVER_END 	 = 1
PIPE_WAIT		 = 0
PIPE_NOWAIT		 = 1
PIPE_READMODE_BYTE	 = 0
PIPE_READMODE_MESSAGE	 = 2
PIPE_TYPE_BYTE		 = 0
PIPE_TYPE_MESSAGE	 = 4
PIPE_UNLIMITED_INSTANCES = 255

; Global memory flags

GMEM_FIXED	       = 0000h
GMEM_MOVEABLE	       = 0002h
GMEM_NOCOMPACT	       = 0010h
GMEM_NODISCARD	       = 0020h
GMEM_ZEROINIT	       = 0040h
GMEM_MODIFY	       = 0080h
GMEM_DISCARDABLE       = 0100h
GMEM_NOT_BANKED        = 1000h
GMEM_SHARE	       = 2000h
GMEM_DDESHARE	       = 2000h
GMEM_NOTIFY	       = 4000h
GMEM_LOWER	       = GMEM_NOT_BANKED
GMEM_VALID_FLAGS       = 7F72h
GMEM_INVALID_HANDLE    = 8000h
GMEM_DISCARDED	       = 4000h
GMEM_LOCKCOUNT	       = 0FFh
GHND		       = GMEM_MOVEABLE + GMEM_ZEROINIT
GPTR		       = GMEM_FIXED + GMEM_ZEROINIT

; Local memory flags

LMEM_FIXED	       = 0000h
LMEM_MOVEABLE	       = 0002h
LMEM_NOCOMPACT	       = 0010h
LMEM_NODISCARD	       = 0020h
LMEM_ZEROINIT	       = 0040h
LMEM_MODIFY	       = 0080h
LMEM_DISCARDABLE       = 0F00h
LMEM_VALID_FLAGS       = 0F72h
LMEM_INVALID_HANDLE    = 8000h
LHND		       = LMEM_MOVEABLE + LMEM_ZEROINIT
LPTR		       = LMEM_FIXED + LMEM_ZEROINIT
LMEM_DISCARDED	       = 4000h
LMEM_LOCKCOUNT	       = 00FFh

; Page access flags

PAGE_NOACCESS	       = 001h
PAGE_READONLY	       = 002h
PAGE_READWRITE	       = 004h
PAGE_WRITECOPY	       = 008h
PAGE_EXECUTE	       = 010h
PAGE_EXECUTE_READ      = 020h
PAGE_EXECUTE_READWRITE = 040h
PAGE_EXECUTE_WRITECOPY = 080h
PAGE_GUARD	       = 100h
PAGE_NOCACHE	       = 200h

; Memory allocation flags

MEM_COMMIT	       = 001000h
MEM_RESERVE	       = 002000h
MEM_DECOMMIT	       = 004000h
MEM_RELEASE	       = 008000h
MEM_FREE	       = 010000h
MEM_PRIVATE	       = 020000h
MEM_MAPPED	       = 040000h
MEM_RESET	       = 080000h
MEM_TOP_DOWN	       = 100000h

; Heap allocation flags

HEAP_NO_SERIALIZE	 = 1
HEAP_GENERATE_EXCEPTIONS = 4
HEAP_ZERO_MEMORY	 = 8

; Platform identifiers

VER_PLATFORM_WIN32s	   = 0
VER_PLATFORM_WIN32_WINDOWS = 1
VER_PLATFORM_WIN32_NT	   = 2

; GetBinaryType return values

SCS_32BIT_BINARY = 0
SCS_DOS_BINARY	 = 1
SCS_WOW_BINARY	 = 2
SCS_PIF_BINARY	 = 3
SCS_POSIX_BINARY = 4
SCS_OS216_BINARY = 5

; CreateProcess flags

DEBUG_PROCESS		 = 001h
DEBUG_ONLY_THIS_PROCESS  = 002h
CREATE_SUSPENDED	 = 004h
DETACHED_PROCESS	 = 008h
CREATE_NEW_CONSOLE	 = 010h
NORMAL_PRIORITY_CLASS	 = 020h
IDLE_PRIORITY_CLASS	 = 040h
HIGH_PRIORITY_CLASS	 = 080h
REALTIME_PRIORITY_CLASS  = 100h
CREATE_NEW_PROCESS_GROUP = 200h
CREATE_SEPARATE_WOW_VDM  = 800h

; Thread priority values

THREAD_BASE_PRIORITY_MIN      = -2
THREAD_BASE_PRIORITY_MAX      = 2
THREAD_BASE_PRIORITY_LOWRT    = 15
THREAD_BASE_PRIORITY_IDLE     = -15
THREAD_PRIORITY_LOWEST	      = THREAD_BASE_PRIORITY_MIN
THREAD_PRIORITY_BELOW_NORMAL  = THREAD_PRIORITY_LOWEST + 1
THREAD_PRIORITY_NORMAL	      = 0
THREAD_PRIORITY_HIGHEST       = THREAD_BASE_PRIORITY_MAX
THREAD_PRIORITY_ABOVE_NORMAL  = THREAD_PRIORITY_HIGHEST - 1
THREAD_PRIORITY_ERROR_RETURN  = 7FFFFFFFh
THREAD_PRIORITY_TIME_CRITICAL = THREAD_BASE_PRIORITY_LOWRT
THREAD_PRIORITY_IDLE	      = THREAD_BASE_PRIORITY_IDLE

; Startup flags

STARTF_USESHOWWINDOW	= 001h
STARTF_USESIZE		= 002h
STARTF_USEPOSITION	= 004h
STARTF_USECOUNTCHARS	= 008h
STARTF_USEFILLATTRIBUTE = 010h
STARTF_RUNFULLSCREEN	= 020h
STARTF_FORCEONFEEDBACK	= 040h
STARTF_FORCEOFFFEEDBACK = 080h
STARTF_USESTDHANDLES	= 100h

; Shutdown flags

SHUTDOWN_NORETRY = 1h

; LoadLibraryEx flags

DONT_RESOLVE_DLL_REFERENCES   = 1
LOAD_LIBRARY_AS_DATAFILE      = 2
LOAD_WITH_ALTERED_SEARCH_PATH = 8

; DLL entry-point calls

DLL_PROCESS_DETACH = 0
DLL_PROCESS_ATTACH = 1
DLL_THREAD_ATTACH  = 2
DLL_THREAD_DETACH  = 3

; Status codes

STATUS_WAIT_0			= 000000000h
STATUS_ABANDONED_WAIT_0 	= 000000080h
STATUS_USER_APC 		= 0000000C0h
STATUS_TIMEOUT			= 000000102h
STATUS_PENDING			= 000000103h
STATUS_DATATYPE_MISALIGNMENT	= 080000002h
STATUS_BREAKPOINT		= 080000003h
STATUS_SINGLE_STEP		= 080000004h
STATUS_ACCESS_VIOLATION 	= 0C0000005h
STATUS_IN_PAGE_ERROR		= 0C0000006h
STATUS_NO_MEMORY		= 0C0000017h
STATUS_ILLEGAL_INSTRUCTION	= 0C000001Dh
STATUS_NONCONTINUABLE_EXCEPTION = 0C0000025h
STATUS_INVALID_DISPOSITION	= 0C0000026h
STATUS_ARRAY_BOUNDS_EXCEEDED	= 0C000008Ch
STATUS_FLOAT_DENORMAL_OPERAND	= 0C000008Dh
STATUS_FLOAT_DIVIDE_BY_ZERO	= 0C000008Eh
STATUS_FLOAT_INEXACT_RESULT	= 0C000008Fh
STATUS_FLOAT_INVALID_OPERATION	= 0C0000090h
STATUS_FLOAT_OVERFLOW		= 0C0000091h
STATUS_FLOAT_STACK_CHECK	= 0C0000092h
STATUS_FLOAT_UNDERFLOW		= 0C0000093h
STATUS_INTEGER_DIVIDE_BY_ZERO	= 0C0000094h
STATUS_INTEGER_OVERFLOW 	= 0C0000095h
STATUS_PRIVILEGED_INSTRUCTION	= 0C0000096h
STATUS_STACK_OVERFLOW		= 0C00000FDh
STATUS_CONTROL_C_EXIT		= 0C000013Ah
WAIT_FAILED			= -1
WAIT_OBJECT_0			= STATUS_WAIT_0
WAIT_ABANDONED			= STATUS_ABANDONED_WAIT_0
WAIT_ABANDONED_0		= STATUS_ABANDONED_WAIT_0
WAIT_TIMEOUT			= STATUS_TIMEOUT
WAIT_IO_COMPLETION		= STATUS_USER_APC
STILL_ACTIVE			= STATUS_PENDING

; Exception codes

EXCEPTION_CONTINUABLE		= 0
EXCEPTION_NONCONTINUABLE	= 1
EXCEPTION_ACCESS_VIOLATION	= STATUS_ACCESS_VIOLATION
EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT
EXCEPTION_BREAKPOINT		= STATUS_BREAKPOINT
EXCEPTION_SINGLE_STEP		= STATUS_SINGLE_STEP
EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED
EXCEPTION_FLT_DENORMAL_OPERAND	= STATUS_FLOAT_DENORMAL_OPERAND
EXCEPTION_FLT_DIVIDE_BY_ZERO	= STATUS_FLOAT_DIVIDE_BY_ZERO
EXCEPTION_FLT_INEXACT_RESULT	= STATUS_FLOAT_INEXACT_RESULT
EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION
EXCEPTION_FLT_OVERFLOW		= STATUS_FLOAT_OVERFLOW
EXCEPTION_FLT_STACK_CHECK	= STATUS_FLOAT_STACK_CHECK
EXCEPTION_FLT_UNDERFLOW 	= STATUS_FLOAT_UNDERFLOW
EXCEPTION_INT_DIVIDE_BY_ZERO	= STATUS_INTEGER_DIVIDE_BY_ZERO
EXCEPTION_INT_OVERFLOW		= STATUS_INTEGER_OVERFLOW
EXCEPTION_ILLEGAL_INSTRUCTION	= STATUS_ILLEGAL_INSTRUCTION
EXCEPTION_PRIV_INSTRUCTION	= STATUS_PRIVILEGED_INSTRUCTION
EXCEPTION_IN_PAGE_ERROR 	= STATUS_IN_PAGE_ERROR

; Registry options

REG_OPTION_RESERVED	       = 0
REG_OPTION_NON_VOLATILE        = 0
REG_OPTION_VOLATILE	       = 1
REG_OPTION_CREATE_LINK	       = 2
REG_OPTION_BACKUP_RESTORE      = 4
REG_CREATED_NEW_KEY	       = 1
REG_OPENED_EXISTING_KEY        = 2
REG_WHOLE_HIVE_VOLATILE        = 1
REG_REFRESH_HIVE	       = 2
REG_NOTIFY_CHANGE_NAME	       = 1
REG_NOTIFY_CHANGE_ATTRIBUTES   = 2
REG_NOTIFY_CHANGE_LAST_SET     = 4
REG_NOTIFY_CHANGE_SECURITY     = 8
REG_LEGAL_CHANGE_FILTER        = REG_NOTIFY_CHANGE_NAME or REG_NOTIFY_CHANGE_ATTRIBUTES or REG_NOTIFY_CHANGE_LAST_SET or REG_NOTIFY_CHANGE_SECURITY
REG_LEGAL_OPTION	       = REG_OPTION_RESERVED or REG_OPTION_NON_VOLATILE or REG_OPTION_VOLATILE or REG_OPTION_CREATE_LINK or REG_OPTION_BACKUP_RESTORE
REG_NONE		       = 0
REG_SZ			       = 1
REG_EXPAND_SZ		       = 2
REG_BINARY		       = 3
REG_DWORD		       = 4
REG_DWORD_LITTLE_ENDIAN        = 4
REG_DWORD_BIG_ENDIAN	       = 5
REG_LINK		       = 6
REG_MULTI_SZ		       = 7
REG_RESOURCE_LIST	       = 8
REG_FULL_RESOURCE_DESCRIPTOR   = 9
REG_RESOURCE_REQUIREMENTS_LIST = 10

; Registry access modes

KEY_QUERY_VALUE 	       = 1
KEY_SET_VALUE		       = 2
KEY_CREATE_SUB_KEY	       = 4
KEY_ENUMERATE_SUB_KEYS	       = 8
KEY_NOTIFY		       = 10h
KEY_CREATE_LINK 	       = 20h
KEY_READ		       = STANDARD_RIGHTS_READ or KEY_QUERY_VALUE or KEY_ENUMERATE_SUB_KEYS or KEY_NOTIFY and not SYNCHRONIZE
KEY_WRITE		       = STANDARD_RIGHTS_WRITE or KEY_SET_VALUE or KEY_CREATE_SUB_KEY and not SYNCHRONIZE
KEY_EXECUTE		       = KEY_READ
KEY_ALL_ACCESS		       = STANDARD_RIGHTS_ALL or KEY_QUERY_VALUE or KEY_SET_VALUE or KEY_CREATE_SUB_KEY or KEY_ENUMERATE_SUB_KEYS or KEY_NOTIFY or KEY_CREATE_LINK and not SYNCHRONIZE

; Predefined registry keys

HKEY_CLASSES_ROOT     = 80000000h
HKEY_CURRENT_USER     = 80000001h
HKEY_LOCAL_MACHINE    = 80000002h
HKEY_USERS	      = 80000003h
HKEY_PERFORMANCE_DATA = 80000004h
HKEY_CURRENT_CONFIG   = 80000005h
HKEY_DYN_DATA	      = 80000006h

; FormatMessage flags

FORMAT_MESSAGE_ALLOCATE_BUFFER = 0100h
FORMAT_MESSAGE_IGNORE_INSERTS  = 0200h
FORMAT_MESSAGE_FROM_STRING     = 0400h
FORMAT_MESSAGE_FROM_HMODULE    = 0800h
FORMAT_MESSAGE_FROM_SYSTEM     = 1000h
FORMAT_MESSAGE_ARGUMENT_ARRAY  = 2000h
FORMAT_MESSAGE_MAX_WIDTH_MASK  = 00FFh

; Language identifiers

LANG_NEUTRAL		     = 00h
LANG_BULGARIAN		     = 02h
LANG_CHINESE		     = 04h
LANG_CROATIAN		     = 1Ah
LANG_CZECH		     = 05h
LANG_DANISH		     = 06h
LANG_DUTCH		     = 13h
LANG_ENGLISH		     = 09h
LANG_FINNISH		     = 0Bh
LANG_FRENCH		     = 0Ch
LANG_GERMAN		     = 07h
LANG_GREEK		     = 08h
LANG_HUNGARIAN		     = 0Eh
LANG_ICELANDIC		     = 0Fh
LANG_ITALIAN		     = 10h
LANG_JAPANESE		     = 11h
LANG_KOREAN		     = 12h
LANG_NORWEGIAN		     = 14h
LANG_POLISH		     = 15h
LANG_PORTUGUESE 	     = 16h
LANG_ROMANIAN		     = 18h
LANG_RUSSIAN		     = 19h
LANG_SLOVAK		     = 1Bh
LANG_SLOVENIAN		     = 24h
LANG_SPANISH		     = 0Ah
LANG_SWEDISH		     = 1Dh
LANG_THAI		     = 1Eh
LANG_TURKISH		     = 1Fh

; Sublanguage identifiers

SUBLANG_NEUTRAL 	     = 00h shl 10
SUBLANG_DEFAULT 	     = 01h shl 10
SUBLANG_SYS_DEFAULT	     = 02h shl 10
SUBLANG_CHINESE_TRADITIONAL  = 01h shl 10
SUBLANG_CHINESE_SIMPLIFIED   = 02h shl 10
SUBLANG_CHINESE_HONGKONG     = 03h shl 10
SUBLANG_CHINESE_SINGAPORE    = 04h shl 10
SUBLANG_DUTCH		     = 01h shl 10
SUBLANG_DUTCH_BELGIAN	     = 02h shl 10
SUBLANG_ENGLISH_US	     = 01h shl 10
SUBLANG_ENGLISH_UK	     = 02h shl 10
SUBLANG_ENGLISH_AUS	     = 03h shl 10
SUBLANG_ENGLISH_CAN	     = 04h shl 10
SUBLANG_ENGLISH_NZ	     = 05h shl 10
SUBLANG_ENGLISH_EIRE	     = 06h shl 10
SUBLANG_FRENCH		     = 01h shl 10
SUBLANG_FRENCH_BELGIAN	     = 02h shl 10
SUBLANG_FRENCH_CANADIAN      = 03h shl 10
SUBLANG_FRENCH_SWISS	     = 04h shl 10
SUBLANG_GERMAN		     = 01h shl 10
SUBLANG_GERMAN_SWISS	     = 02h shl 10
SUBLANG_GERMAN_AUSTRIAN      = 03h shl 10
SUBLANG_ITALIAN 	     = 01h shl 10
SUBLANG_ITALIAN_SWISS	     = 02h shl 10
SUBLANG_NORWEGIAN_BOKMAL     = 01h shl 10
SUBLANG_NORWEGIAN_NYNORSK    = 02h shl 10
SUBLANG_PORTUGUESE	     = 02h shl 10
SUBLANG_PORTUGUESE_BRAZILIAN = 01h shl 10
SUBLANG_SPANISH 	     = 01h shl 10
SUBLANG_SPANISH_MEXICAN      = 02h shl 10
SUBLANG_SPANISH_MODERN	     = 03h shl 10

; Sorting identifiers

SORT_DEFAULT		     = 0 shl 16
SORT_JAPANESE_XJIS	     = 0 shl 16
SORT_JAPANESE_UNICODE	     = 1 shl 16
SORT_CHINESE_BIG5	     = 0 shl 16
SORT_CHINESE_PRCP	     = 0 shl 16
SORT_CHINESE_UNICODE	     = 1 shl 16
SORT_CHINESE_PRC	     = 2 shl 16
SORT_CHINESE_BOPOMOFO	     = 3 shl 16
SORT_KOREAN_KSC 	     = 0 shl 16
SORT_KOREAN_UNICODE	     = 1 shl 16
SORT_GERMAN_PHONE_BOOK	     = 1 shl 16
SORT_HUNGARIAN_DEFAULT	     = 0 shl 16
SORT_HUNGARIAN_TECHNICAL     = 1 shl 16

; Code pages

CP_ACP	      = 0	    ; default to ANSI code page
CP_OEMCP      = 1	    ; default to OEM code page
CP_MACCP      = 2	    ; default to MAC code page
CP_THREAD_ACP = 3	    ; current thread's ANSI code page
CP_SYMBOL     = 42	    ; SYMBOL translations
CP_UTF7       = 65000	    ; UTF-7 translation
CP_UTF8       = 65001	    ; UTF-8 translation

; Resource types

RT_CURSOR	= 1
RT_BITMAP	= 2
RT_ICON 	= 3
RT_MENU 	= 4
RT_DIALOG	= 5
RT_STRING	= 6
RT_FONTDIR	= 7
RT_FONT 	= 8
RT_ACCELERATOR	= 9
RT_RCDATA	= 10
RT_MESSAGETABLE = 11
RT_GROUP_CURSOR = 12
RT_GROUP_ICON	= 14
RT_VERSION	= 16
RT_DLGINCLUDE	= 17
RT_PLUGPLAY	= 19
RT_VXD		= 20
RT_ANICURSOR	= 21
RT_ANIICON	= 22
RT_HTML 	= 23
RT_MANIFEST	= 24

; Clipboard formats

CF_TEXT 	   = 001h
CF_BITMAP	   = 002h
CF_METAFILEPICT    = 003h
CF_SYLK 	   = 004h
CF_DIF		   = 005h
CF_TIFF 	   = 006h
CF_OEMTEXT	   = 007h
CF_DIB		   = 008h
CF_PALETTE	   = 009h
CF_PENDATA	   = 00Ah
CF_RIFF 	   = 00Bh
CF_WAVE 	   = 00Ch
CF_UNICODETEXT	   = 00Dh
CF_ENHMETAFILE	   = 00Eh
CF_HDROP	   = 00Fh
CF_LOCALE	   = 010h
CF_OWNERDISPLAY    = 080h
CF_DSPTEXT	   = 081h
CF_DSPBITMAP	   = 082h
CF_DSPMETAFILEPICT = 083h
CF_DSPENHMETAFILE  = 08Eh
CF_PRIVATEFIRST    = 200h
CF_PRIVATELAST	   = 2FFh
CF_GDIOBJFIRST	   = 300h
CF_GDIOBJLAST	   = 3FFh

; OS types for version info

VOS_UNKNOWN	  = 00000000h
VOS_DOS 	  = 00010000h
VOS_OS216	  = 00020000h
VOS_OS232	  = 00030000h
VOS_NT		  = 00040000h
VOS__BASE	  = 00000000h
VOS__WINDOWS16	  = 00000001h
VOS__PM16	  = 00000002h
VOS__PM32	  = 00000003h
VOS__WINDOWS32	  = 00000004h
VOS_DOS_WINDOWS16 = 00010001h
VOS_DOS_WINDOWS32 = 00010004h
VOS_OS216_PM16	  = 00020002h
VOS_OS232_PM32	  = 00030003h
VOS_NT_WINDOWS32  = 00040004h

; File types for version info

VFT_UNKNOWN    = 00000000h
VFT_APP        = 00000001h
VFT_DLL        = 00000002h
VFT_DRV        = 00000003h
VFT_FONT       = 00000004h
VFT_VXD        = 00000005h
VFT_STATIC_LIB = 00000007h

; File subtypes for version info

VFT2_UNKNOWN		   = 00000000h
VFT2_DRV_PRINTER	   = 00000001h
VFT2_DRV_KEYBOARD	   = 00000002h
VFT2_DRV_LANGUAGE	   = 00000003h
VFT2_DRV_DISPLAY	   = 00000004h
VFT2_DRV_MOUSE		   = 00000005h
VFT2_DRV_NETWORK	   = 00000006h
VFT2_DRV_SYSTEM 	   = 00000007h
VFT2_DRV_INSTALLABLE	   = 00000008h
VFT2_DRV_SOUND		   = 00000009h
VFT2_DRV_COMM		   = 0000000Ah
VFT2_DRV_INPUTMETHOD	   = 0000000Bh
VFT2_DRV_VERSIONED_PRINTER = 0000000Ch
VFT2_FONT_RASTER	   = 00000001h
VFT2_FONT_VECTOR	   = 00000002h
VFT2_FONT_TRUETYPE	   = 00000003h

; Console control signals

CTRL_C_EVENT	    = 0
CTRL_BREAK_EVENT    = 1
CTRL_CLOSE_EVENT    = 2
CTRL_LOGOFF_EVENT   = 5
CTRL_SHUTDOWN_EVENT = 6

; Standard file handles

STD_INPUT_HANDLE       = 0FFFFFFF6h
STD_OUTPUT_HANDLE      = 0FFFFFFF5h
STD_ERROR_HANDLE       = 0FFFFFFF4h
