# Generated by Django 4.1.7 on 2023-05-10 00:36

from django.db import migrations, models
import tagulous.models.fields
import tagulous.models.models


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0187_nessus_to_tenable'),
    ]

    operations = [
        migrations.AddField(
            model_name='product',
            name='enable_product_tag_inheritance',
            field=models.BooleanField(default=False, help_text='Enables product tag inheritance. Any tags added on a product will automatically be added to all Engagements, Tests, and Findings', verbose_name='Enable Product Tag Inheritance'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_product_tag_inheritance',
            field=models.BooleanField(default=False, help_text='Enables product tag inheritance globally for all products. Any tags added on a product will automatically be added to all Engagements, Tests, and Findings', verbose_name='Enable Product Tag Inheritance'),
        ),
        migrations.CreateModel(
            name='Tagulous_Test_inherited_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Finding_inherited_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Engagement_inherited_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Endpoint_inherited_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='inherited_tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Internal use tags sepcifically for maintaining parity with product. This field will be present as a subset in the tags field', to='dojo.tagulous_endpoint_inherited_tags'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='inherited_tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Internal use tags sepcifically for maintaining parity with product. This field will be present as a subset in the tags field', to='dojo.tagulous_engagement_inherited_tags'),
        ),
        migrations.AddField(
            model_name='finding',
            name='inherited_tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Internal use tags sepcifically for maintaining parity with product. This field will be present as a subset in the tags field', to='dojo.tagulous_finding_inherited_tags'),
        ),
        migrations.AddField(
            model_name='test',
            name='inherited_tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Internal use tags sepcifically for maintaining parity with product. This field will be present as a subset in the tags field', to='dojo.tagulous_test_inherited_tags'),
        ),
    ]
