# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create the restore point. Updating properties of an existing restore point is not allowed.

    :example: Create a restore point
        az restore-point create --exclude-disks "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123" --resource-group "myResourceGroup" --collection-name "rpcName" --name "rpName"

    :example: Create a restore point with --consistency-mode CrashConsistent
        az vm create -n vm -g rg --image UbuntuLTS --tag EnableCrashConsistentRestorePoint=True
        az restore-point collection create --source-id "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM" -g rg --collection-name "myRpc"
        az restore-point create --exclude-disks "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/disk123" --resource-group "myResourceGroup" --collection-name "rpcName" --name "rpName"
    """

    _aaz_info = {
        "version": "2024-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/restorepointcollections/{}/restorepoints/{}", "2024-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.restore_point_collection_name = AAZStrArg(
            options=["--collection-name", "--restore-point-collection-name"],
            help="The name of the restore point collection.",
            required=True,
        )
        _args_schema.restore_point_name = AAZStrArg(
            options=["-n", "--name", "--restore-point-name"],
            help="The name of the restore point.",
            required=True,
        )
        _args_schema.consistency_mode = AAZStrArg(
            options=["--consistency-mode"],
            help="Consistency mode of the restore point. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details. Allowed values: ApplicationConsistent, CrashConsistent, FileSystemConsistent.",
            enum={"ApplicationConsistent": "ApplicationConsistent", "CrashConsistent": "CrashConsistent", "FileSystemConsistent": "FileSystemConsistent"},
        )
        _args_schema.exclude_disks = AAZListArg(
            options=["--exclude-disks"],
            help="List of disk resource ids that the customer wishes to exclude from the restore point. If no disks are specified, all disks will be included.",
        )
        _args_schema.source_restore_point = AAZObjectArg(
            options=["--source-restore-point"],
            help="Resource Id of the source restore point from which a copy needs to be created.",
        )
        cls._build_args_api_entity_reference_create(_args_schema.source_restore_point)

        exclude_disks = cls._args_schema.exclude_disks
        exclude_disks.Element = AAZObjectArg()
        cls._build_args_api_entity_reference_create(exclude_disks.Element)

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.source_metadata = AAZObjectArg(
            options=["--source-metadata"],
            arg_group="Properties",
            help="Gets the details of the VM captured at the time of the restore point creation.",
        )

        source_metadata = cls._args_schema.source_metadata
        source_metadata.storage_profile = AAZObjectArg(
            options=["storage-profile"],
            help="Gets the storage profile.",
        )

        storage_profile = cls._args_schema.source_metadata.storage_profile
        storage_profile.data_disks = AAZListArg(
            options=["data-disks"],
            help="Gets the data disks of the VM captured at the time of the restore point creation.",
        )
        storage_profile.os_disk = AAZObjectArg(
            options=["os-disk"],
            help="Gets the OS disk of the VM captured at the time of the restore point creation.",
        )

        data_disks = cls._args_schema.source_metadata.storage_profile.data_disks
        data_disks.Element = AAZObjectArg()

        _element = cls._args_schema.source_metadata.storage_profile.data_disks.Element
        _element.disk_restore_point = AAZObjectArg(
            options=["disk-restore-point"],
            help="Contains Disk Restore Point properties.",
        )
        cls._build_args_disk_restore_point_attributes_create(_element.disk_restore_point)
        _element.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="Contains the managed disk details.",
        )
        cls._build_args_managed_disk_parameters_create(_element.managed_disk)

        os_disk = cls._args_schema.source_metadata.storage_profile.os_disk
        os_disk.disk_restore_point = AAZObjectArg(
            options=["disk-restore-point"],
            help="Contains Disk Restore Point properties.",
        )
        cls._build_args_disk_restore_point_attributes_create(os_disk.disk_restore_point)
        os_disk.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="Gets the managed disk details",
        )
        cls._build_args_managed_disk_parameters_create(os_disk.managed_disk)
        return cls._args_schema

    _args_api_entity_reference_create = None

    @classmethod
    def _build_args_api_entity_reference_create(cls, _schema):
        if cls._args_api_entity_reference_create is not None:
            _schema.id = cls._args_api_entity_reference_create.id
            return

        cls._args_api_entity_reference_create = AAZObjectArg()

        api_entity_reference_create = cls._args_api_entity_reference_create
        api_entity_reference_create.id = AAZStrArg(
            options=["id"],
            help="The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...",
        )

        _schema.id = cls._args_api_entity_reference_create.id

    _args_disk_encryption_set_parameters_create = None

    @classmethod
    def _build_args_disk_encryption_set_parameters_create(cls, _schema):
        if cls._args_disk_encryption_set_parameters_create is not None:
            _schema.id = cls._args_disk_encryption_set_parameters_create.id
            return

        cls._args_disk_encryption_set_parameters_create = AAZObjectArg()

        disk_encryption_set_parameters_create = cls._args_disk_encryption_set_parameters_create
        disk_encryption_set_parameters_create.id = AAZStrArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_disk_encryption_set_parameters_create.id

    _args_disk_restore_point_attributes_create = None

    @classmethod
    def _build_args_disk_restore_point_attributes_create(cls, _schema):
        if cls._args_disk_restore_point_attributes_create is not None:
            _schema.encryption = cls._args_disk_restore_point_attributes_create.encryption
            _schema.source_disk_restore_point = cls._args_disk_restore_point_attributes_create.source_disk_restore_point
            return

        cls._args_disk_restore_point_attributes_create = AAZObjectArg()

        disk_restore_point_attributes_create = cls._args_disk_restore_point_attributes_create
        disk_restore_point_attributes_create.encryption = AAZObjectArg(
            options=["encryption"],
            help="Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input while creating a restore point.",
        )
        disk_restore_point_attributes_create.source_disk_restore_point = AAZObjectArg(
            options=["source-disk-restore-point"],
            help="Resource Id of the source disk restore point.",
        )
        cls._build_args_api_entity_reference_create(disk_restore_point_attributes_create.source_disk_restore_point)

        encryption = cls._args_disk_restore_point_attributes_create.encryption
        encryption.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.",
        )
        cls._build_args_disk_encryption_set_parameters_create(encryption.disk_encryption_set)
        encryption.type = AAZStrArg(
            options=["type"],
            help="The type of key used to encrypt the data of the disk restore point.",
            enum={"EncryptionAtRestWithCustomerKey": "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys": "EncryptionAtRestWithPlatformAndCustomerKeys", "EncryptionAtRestWithPlatformKey": "EncryptionAtRestWithPlatformKey"},
        )

        _schema.encryption = cls._args_disk_restore_point_attributes_create.encryption
        _schema.source_disk_restore_point = cls._args_disk_restore_point_attributes_create.source_disk_restore_point

    _args_managed_disk_parameters_create = None

    @classmethod
    def _build_args_managed_disk_parameters_create(cls, _schema):
        if cls._args_managed_disk_parameters_create is not None:
            _schema.disk_encryption_set = cls._args_managed_disk_parameters_create.disk_encryption_set
            _schema.id = cls._args_managed_disk_parameters_create.id
            _schema.security_profile = cls._args_managed_disk_parameters_create.security_profile
            _schema.storage_account_type = cls._args_managed_disk_parameters_create.storage_account_type
            return

        cls._args_managed_disk_parameters_create = AAZObjectArg()

        managed_disk_parameters_create = cls._args_managed_disk_parameters_create
        managed_disk_parameters_create.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk.",
        )
        cls._build_args_disk_encryption_set_parameters_create(managed_disk_parameters_create.disk_encryption_set)
        managed_disk_parameters_create.id = AAZStrArg(
            options=["id"],
            help="Resource Id",
        )
        managed_disk_parameters_create.security_profile = AAZObjectArg(
            options=["security-profile"],
            help="Specifies the security profile for the managed disk.",
        )
        managed_disk_parameters_create.storage_account_type = AAZStrArg(
            options=["storage-account-type"],
            help="Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.",
            enum={"PremiumV2_LRS": "PremiumV2_LRS", "Premium_LRS": "Premium_LRS", "Premium_ZRS": "Premium_ZRS", "StandardSSD_LRS": "StandardSSD_LRS", "StandardSSD_ZRS": "StandardSSD_ZRS", "Standard_LRS": "Standard_LRS", "UltraSSD_LRS": "UltraSSD_LRS"},
        )

        security_profile = cls._args_managed_disk_parameters_create.security_profile
        security_profile.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.",
        )
        cls._build_args_disk_encryption_set_parameters_create(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrArg(
            options=["security-encryption-type"],
            help="Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only Confidential VMs.",
            enum={"DiskWithVMGuestState": "DiskWithVMGuestState", "NonPersistedTPM": "NonPersistedTPM", "VMGuestStateOnly": "VMGuestStateOnly"},
        )

        _schema.disk_encryption_set = cls._args_managed_disk_parameters_create.disk_encryption_set
        _schema.id = cls._args_managed_disk_parameters_create.id
        _schema.security_profile = cls._args_managed_disk_parameters_create.security_profile
        _schema.storage_account_type = cls._args_managed_disk_parameters_create.storage_account_type

    def _execute_operations(self):
        self.pre_operations()
        yield self.RestorePointsCreate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class RestorePointsCreate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_201,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{restorePointName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "restorePointCollectionName", self.ctx.args.restore_point_collection_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "restorePointName", self.ctx.args.restore_point_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("consistencyMode", AAZStrType, ".consistency_mode")
                properties.set_prop("excludeDisks", AAZListType, ".exclude_disks")
                properties.set_prop("sourceMetadata", AAZObjectType, ".source_metadata")
                _CreateHelper._build_schema_api_entity_reference_create(properties.set_prop("sourceRestorePoint", AAZObjectType, ".source_restore_point"))

            exclude_disks = _builder.get(".properties.excludeDisks")
            if exclude_disks is not None:
                _CreateHelper._build_schema_api_entity_reference_create(exclude_disks.set_elements(AAZObjectType, "."))

            source_metadata = _builder.get(".properties.sourceMetadata")
            if source_metadata is not None:
                source_metadata.set_prop("storageProfile", AAZObjectType, ".storage_profile")

            storage_profile = _builder.get(".properties.sourceMetadata.storageProfile")
            if storage_profile is not None:
                storage_profile.set_prop("dataDisks", AAZListType, ".data_disks")
                storage_profile.set_prop("osDisk", AAZObjectType, ".os_disk")

            data_disks = _builder.get(".properties.sourceMetadata.storageProfile.dataDisks")
            if data_disks is not None:
                data_disks.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.sourceMetadata.storageProfile.dataDisks[]")
            if _elements is not None:
                _CreateHelper._build_schema_disk_restore_point_attributes_create(_elements.set_prop("diskRestorePoint", AAZObjectType, ".disk_restore_point"))
                _CreateHelper._build_schema_managed_disk_parameters_create(_elements.set_prop("managedDisk", AAZObjectType, ".managed_disk"))

            os_disk = _builder.get(".properties.sourceMetadata.storageProfile.osDisk")
            if os_disk is not None:
                _CreateHelper._build_schema_disk_restore_point_attributes_create(os_disk.set_prop("diskRestorePoint", AAZObjectType, ".disk_restore_point"))
                _CreateHelper._build_schema_managed_disk_parameters_create(os_disk.set_prop("managedDisk", AAZObjectType, ".managed_disk"))

            return self.serialize_content(_content_value)

        def on_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_201
            )

        _schema_on_201 = None

        @classmethod
        def _build_schema_on_201(cls):
            if cls._schema_on_201 is not None:
                return cls._schema_on_201

            cls._schema_on_201 = AAZObjectType()

            _schema_on_201 = cls._schema_on_201
            _schema_on_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_201.properties
            properties.consistency_mode = AAZStrType(
                serialized_name="consistencyMode",
            )
            properties.exclude_disks = AAZListType(
                serialized_name="excludeDisks",
            )
            properties.instance_view = AAZObjectType(
                serialized_name="instanceView",
                flags={"read_only": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.source_metadata = AAZObjectType(
                serialized_name="sourceMetadata",
            )
            properties.source_restore_point = AAZObjectType(
                serialized_name="sourceRestorePoint",
            )
            _CreateHelper._build_schema_api_entity_reference_read(properties.source_restore_point)
            properties.time_created = AAZStrType(
                serialized_name="timeCreated",
            )

            exclude_disks = cls._schema_on_201.properties.exclude_disks
            exclude_disks.Element = AAZObjectType()
            _CreateHelper._build_schema_api_entity_reference_read(exclude_disks.Element)

            instance_view = cls._schema_on_201.properties.instance_view
            instance_view.disk_restore_points = AAZListType(
                serialized_name="diskRestorePoints",
            )
            instance_view.statuses = AAZListType()

            disk_restore_points = cls._schema_on_201.properties.instance_view.disk_restore_points
            disk_restore_points.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.instance_view.disk_restore_points.Element
            _element.id = AAZStrType()
            _element.replication_status = AAZObjectType(
                serialized_name="replicationStatus",
            )

            replication_status = cls._schema_on_201.properties.instance_view.disk_restore_points.Element.replication_status
            replication_status.completion_percent = AAZIntType(
                serialized_name="completionPercent",
            )
            replication_status.status = AAZObjectType()
            _CreateHelper._build_schema_instance_view_status_read(replication_status.status)

            statuses = cls._schema_on_201.properties.instance_view.statuses
            statuses.Element = AAZObjectType()
            _CreateHelper._build_schema_instance_view_status_read(statuses.Element)

            source_metadata = cls._schema_on_201.properties.source_metadata
            source_metadata.diagnostics_profile = AAZObjectType(
                serialized_name="diagnosticsProfile",
                flags={"read_only": True},
            )
            source_metadata.hardware_profile = AAZObjectType(
                serialized_name="hardwareProfile",
                flags={"read_only": True},
            )
            source_metadata.hyper_v_generation = AAZStrType(
                serialized_name="hyperVGeneration",
                flags={"read_only": True},
            )
            source_metadata.license_type = AAZStrType(
                serialized_name="licenseType",
                flags={"read_only": True},
            )
            source_metadata.location = AAZStrType(
                flags={"read_only": True},
            )
            source_metadata.os_profile = AAZObjectType(
                serialized_name="osProfile",
                flags={"read_only": True},
            )
            source_metadata.security_profile = AAZObjectType(
                serialized_name="securityProfile",
                flags={"read_only": True},
            )
            source_metadata.storage_profile = AAZObjectType(
                serialized_name="storageProfile",
            )
            source_metadata.user_data = AAZStrType(
                serialized_name="userData",
                flags={"read_only": True},
            )
            source_metadata.vm_id = AAZStrType(
                serialized_name="vmId",
                flags={"read_only": True},
            )

            diagnostics_profile = cls._schema_on_201.properties.source_metadata.diagnostics_profile
            diagnostics_profile.boot_diagnostics = AAZObjectType(
                serialized_name="bootDiagnostics",
            )

            boot_diagnostics = cls._schema_on_201.properties.source_metadata.diagnostics_profile.boot_diagnostics
            boot_diagnostics.enabled = AAZBoolType()
            boot_diagnostics.storage_uri = AAZStrType(
                serialized_name="storageUri",
            )

            hardware_profile = cls._schema_on_201.properties.source_metadata.hardware_profile
            hardware_profile.vm_size = AAZStrType(
                serialized_name="vmSize",
            )
            hardware_profile.vm_size_properties = AAZObjectType(
                serialized_name="vmSizeProperties",
            )

            vm_size_properties = cls._schema_on_201.properties.source_metadata.hardware_profile.vm_size_properties
            vm_size_properties.v_cp_us_available = AAZIntType(
                serialized_name="vCPUsAvailable",
            )
            vm_size_properties.v_cp_us_per_core = AAZIntType(
                serialized_name="vCPUsPerCore",
            )

            os_profile = cls._schema_on_201.properties.source_metadata.os_profile
            os_profile.admin_password = AAZStrType(
                serialized_name="adminPassword",
                flags={"secret": True},
            )
            os_profile.admin_username = AAZStrType(
                serialized_name="adminUsername",
            )
            os_profile.allow_extension_operations = AAZBoolType(
                serialized_name="allowExtensionOperations",
            )
            os_profile.computer_name = AAZStrType(
                serialized_name="computerName",
            )
            os_profile.custom_data = AAZStrType(
                serialized_name="customData",
            )
            os_profile.linux_configuration = AAZObjectType(
                serialized_name="linuxConfiguration",
            )
            os_profile.require_guest_provision_signal = AAZBoolType(
                serialized_name="requireGuestProvisionSignal",
            )
            os_profile.secrets = AAZListType()
            os_profile.windows_configuration = AAZObjectType(
                serialized_name="windowsConfiguration",
            )

            linux_configuration = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration
            linux_configuration.disable_password_authentication = AAZBoolType(
                serialized_name="disablePasswordAuthentication",
            )
            linux_configuration.enable_vm_agent_platform_updates = AAZBoolType(
                serialized_name="enableVMAgentPlatformUpdates",
            )
            linux_configuration.patch_settings = AAZObjectType(
                serialized_name="patchSettings",
            )
            linux_configuration.provision_vm_agent = AAZBoolType(
                serialized_name="provisionVMAgent",
            )
            linux_configuration.ssh = AAZObjectType()

            patch_settings = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration.patch_settings
            patch_settings.assessment_mode = AAZStrType(
                serialized_name="assessmentMode",
            )
            patch_settings.automatic_by_platform_settings = AAZObjectType(
                serialized_name="automaticByPlatformSettings",
            )
            patch_settings.patch_mode = AAZStrType(
                serialized_name="patchMode",
            )

            automatic_by_platform_settings = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
            automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
                serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
            )
            automatic_by_platform_settings.reboot_setting = AAZStrType(
                serialized_name="rebootSetting",
            )

            ssh = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration.ssh
            ssh.public_keys = AAZListType(
                serialized_name="publicKeys",
            )

            public_keys = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration.ssh.public_keys
            public_keys.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.os_profile.linux_configuration.ssh.public_keys.Element
            _element.key_data = AAZStrType(
                serialized_name="keyData",
            )
            _element.path = AAZStrType()

            secrets = cls._schema_on_201.properties.source_metadata.os_profile.secrets
            secrets.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.os_profile.secrets.Element
            _element.source_vault = AAZObjectType(
                serialized_name="sourceVault",
            )
            _CreateHelper._build_schema_sub_resource_read(_element.source_vault)
            _element.vault_certificates = AAZListType(
                serialized_name="vaultCertificates",
            )

            vault_certificates = cls._schema_on_201.properties.source_metadata.os_profile.secrets.Element.vault_certificates
            vault_certificates.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.os_profile.secrets.Element.vault_certificates.Element
            _element.certificate_store = AAZStrType(
                serialized_name="certificateStore",
            )
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )

            windows_configuration = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration
            windows_configuration.additional_unattend_content = AAZListType(
                serialized_name="additionalUnattendContent",
            )
            windows_configuration.enable_automatic_updates = AAZBoolType(
                serialized_name="enableAutomaticUpdates",
            )
            windows_configuration.enable_vm_agent_platform_updates = AAZBoolType(
                serialized_name="enableVMAgentPlatformUpdates",
                flags={"read_only": True},
            )
            windows_configuration.patch_settings = AAZObjectType(
                serialized_name="patchSettings",
            )
            windows_configuration.provision_vm_agent = AAZBoolType(
                serialized_name="provisionVMAgent",
            )
            windows_configuration.time_zone = AAZStrType(
                serialized_name="timeZone",
            )
            windows_configuration.win_rm = AAZObjectType(
                serialized_name="winRM",
            )

            additional_unattend_content = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.additional_unattend_content
            additional_unattend_content.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.additional_unattend_content.Element
            _element.component_name = AAZStrType(
                serialized_name="componentName",
            )
            _element.content = AAZStrType()
            _element.pass_name = AAZStrType(
                serialized_name="passName",
            )
            _element.setting_name = AAZStrType(
                serialized_name="settingName",
            )

            patch_settings = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.patch_settings
            patch_settings.assessment_mode = AAZStrType(
                serialized_name="assessmentMode",
            )
            patch_settings.automatic_by_platform_settings = AAZObjectType(
                serialized_name="automaticByPlatformSettings",
            )
            patch_settings.enable_hotpatching = AAZBoolType(
                serialized_name="enableHotpatching",
            )
            patch_settings.patch_mode = AAZStrType(
                serialized_name="patchMode",
            )

            automatic_by_platform_settings = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
            automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
                serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
            )
            automatic_by_platform_settings.reboot_setting = AAZStrType(
                serialized_name="rebootSetting",
            )

            win_rm = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.win_rm
            win_rm.listeners = AAZListType()

            listeners = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.win_rm.listeners
            listeners.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.os_profile.windows_configuration.win_rm.listeners.Element
            _element.certificate_url = AAZStrType(
                serialized_name="certificateUrl",
            )
            _element.protocol = AAZStrType()

            security_profile = cls._schema_on_201.properties.source_metadata.security_profile
            security_profile.encryption_at_host = AAZBoolType(
                serialized_name="encryptionAtHost",
            )
            security_profile.encryption_identity = AAZObjectType(
                serialized_name="encryptionIdentity",
            )
            security_profile.proxy_agent_settings = AAZObjectType(
                serialized_name="proxyAgentSettings",
            )
            security_profile.security_type = AAZStrType(
                serialized_name="securityType",
            )
            security_profile.uefi_settings = AAZObjectType(
                serialized_name="uefiSettings",
            )

            encryption_identity = cls._schema_on_201.properties.source_metadata.security_profile.encryption_identity
            encryption_identity.user_assigned_identity_resource_id = AAZStrType(
                serialized_name="userAssignedIdentityResourceId",
            )

            proxy_agent_settings = cls._schema_on_201.properties.source_metadata.security_profile.proxy_agent_settings
            proxy_agent_settings.enabled = AAZBoolType()
            proxy_agent_settings.imds = AAZObjectType()
            _CreateHelper._build_schema_host_endpoint_settings_read(proxy_agent_settings.imds)
            proxy_agent_settings.key_incarnation_id = AAZIntType(
                serialized_name="keyIncarnationId",
            )
            proxy_agent_settings.mode = AAZStrType()
            proxy_agent_settings.wire_server = AAZObjectType(
                serialized_name="wireServer",
            )
            _CreateHelper._build_schema_host_endpoint_settings_read(proxy_agent_settings.wire_server)

            uefi_settings = cls._schema_on_201.properties.source_metadata.security_profile.uefi_settings
            uefi_settings.secure_boot_enabled = AAZBoolType(
                serialized_name="secureBootEnabled",
            )
            uefi_settings.v_tpm_enabled = AAZBoolType(
                serialized_name="vTpmEnabled",
            )

            storage_profile = cls._schema_on_201.properties.source_metadata.storage_profile
            storage_profile.data_disks = AAZListType(
                serialized_name="dataDisks",
            )
            storage_profile.disk_controller_type = AAZStrType(
                serialized_name="diskControllerType",
                flags={"read_only": True},
            )
            storage_profile.os_disk = AAZObjectType(
                serialized_name="osDisk",
            )

            data_disks = cls._schema_on_201.properties.source_metadata.storage_profile.data_disks
            data_disks.Element = AAZObjectType()

            _element = cls._schema_on_201.properties.source_metadata.storage_profile.data_disks.Element
            _element.caching = AAZStrType(
                flags={"read_only": True},
            )
            _element.disk_restore_point = AAZObjectType(
                serialized_name="diskRestorePoint",
            )
            _CreateHelper._build_schema_disk_restore_point_attributes_read(_element.disk_restore_point)
            _element.disk_size_gb = AAZIntType(
                serialized_name="diskSizeGB",
                flags={"read_only": True},
            )
            _element.lun = AAZIntType(
                flags={"read_only": True},
            )
            _element.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _CreateHelper._build_schema_managed_disk_parameters_read(_element.managed_disk)
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
                flags={"read_only": True},
            )

            os_disk = cls._schema_on_201.properties.source_metadata.storage_profile.os_disk
            os_disk.caching = AAZStrType(
                flags={"read_only": True},
            )
            os_disk.disk_restore_point = AAZObjectType(
                serialized_name="diskRestorePoint",
            )
            _CreateHelper._build_schema_disk_restore_point_attributes_read(os_disk.disk_restore_point)
            os_disk.disk_size_gb = AAZIntType(
                serialized_name="diskSizeGB",
                flags={"read_only": True},
            )
            os_disk.encryption_settings = AAZObjectType(
                serialized_name="encryptionSettings",
                flags={"read_only": True},
            )
            os_disk.managed_disk = AAZObjectType(
                serialized_name="managedDisk",
            )
            _CreateHelper._build_schema_managed_disk_parameters_read(os_disk.managed_disk)
            os_disk.name = AAZStrType(
                flags={"read_only": True},
            )
            os_disk.os_type = AAZStrType(
                serialized_name="osType",
                flags={"read_only": True},
            )
            os_disk.write_accelerator_enabled = AAZBoolType(
                serialized_name="writeAcceleratorEnabled",
                flags={"read_only": True},
            )

            encryption_settings = cls._schema_on_201.properties.source_metadata.storage_profile.os_disk.encryption_settings
            encryption_settings.disk_encryption_key = AAZObjectType(
                serialized_name="diskEncryptionKey",
            )
            encryption_settings.enabled = AAZBoolType()
            encryption_settings.key_encryption_key = AAZObjectType(
                serialized_name="keyEncryptionKey",
            )

            disk_encryption_key = cls._schema_on_201.properties.source_metadata.storage_profile.os_disk.encryption_settings.disk_encryption_key
            disk_encryption_key.secret_url = AAZStrType(
                serialized_name="secretUrl",
                flags={"required": True},
            )
            disk_encryption_key.source_vault = AAZObjectType(
                serialized_name="sourceVault",
                flags={"required": True},
            )
            _CreateHelper._build_schema_sub_resource_read(disk_encryption_key.source_vault)

            key_encryption_key = cls._schema_on_201.properties.source_metadata.storage_profile.os_disk.encryption_settings.key_encryption_key
            key_encryption_key.key_url = AAZStrType(
                serialized_name="keyUrl",
                flags={"required": True},
            )
            key_encryption_key.source_vault = AAZObjectType(
                serialized_name="sourceVault",
                flags={"required": True},
            )
            _CreateHelper._build_schema_sub_resource_read(key_encryption_key.source_vault)

            system_data = cls._schema_on_201.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_api_entity_reference_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_disk_encryption_set_parameters_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_disk_restore_point_attributes_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("encryption", AAZObjectType, ".encryption")
        cls._build_schema_api_entity_reference_create(_builder.set_prop("sourceDiskRestorePoint", AAZObjectType, ".source_disk_restore_point"))

        encryption = _builder.get(".encryption")
        if encryption is not None:
            cls._build_schema_disk_encryption_set_parameters_create(encryption.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
            encryption.set_prop("type", AAZStrType, ".type")

    @classmethod
    def _build_schema_managed_disk_parameters_create(cls, _builder):
        if _builder is None:
            return
        cls._build_schema_disk_encryption_set_parameters_create(_builder.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("securityProfile", AAZObjectType, ".security_profile")
        _builder.set_prop("storageAccountType", AAZStrType, ".storage_account_type")

        security_profile = _builder.get(".securityProfile")
        if security_profile is not None:
            cls._build_schema_disk_encryption_set_parameters_create(security_profile.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
            security_profile.set_prop("securityEncryptionType", AAZStrType, ".security_encryption_type")

    _schema_api_entity_reference_read = None

    @classmethod
    def _build_schema_api_entity_reference_read(cls, _schema):
        if cls._schema_api_entity_reference_read is not None:
            _schema.id = cls._schema_api_entity_reference_read.id
            return

        cls._schema_api_entity_reference_read = _schema_api_entity_reference_read = AAZObjectType()

        api_entity_reference_read = _schema_api_entity_reference_read
        api_entity_reference_read.id = AAZStrType()

        _schema.id = cls._schema_api_entity_reference_read.id

    _schema_disk_encryption_set_parameters_read = None

    @classmethod
    def _build_schema_disk_encryption_set_parameters_read(cls, _schema):
        if cls._schema_disk_encryption_set_parameters_read is not None:
            _schema.id = cls._schema_disk_encryption_set_parameters_read.id
            return

        cls._schema_disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read = AAZObjectType()

        disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read
        disk_encryption_set_parameters_read.id = AAZStrType()

        _schema.id = cls._schema_disk_encryption_set_parameters_read.id

    _schema_disk_restore_point_attributes_read = None

    @classmethod
    def _build_schema_disk_restore_point_attributes_read(cls, _schema):
        if cls._schema_disk_restore_point_attributes_read is not None:
            _schema.encryption = cls._schema_disk_restore_point_attributes_read.encryption
            _schema.id = cls._schema_disk_restore_point_attributes_read.id
            _schema.source_disk_restore_point = cls._schema_disk_restore_point_attributes_read.source_disk_restore_point
            return

        cls._schema_disk_restore_point_attributes_read = _schema_disk_restore_point_attributes_read = AAZObjectType()

        disk_restore_point_attributes_read = _schema_disk_restore_point_attributes_read
        disk_restore_point_attributes_read.encryption = AAZObjectType()
        disk_restore_point_attributes_read.id = AAZStrType(
            flags={"read_only": True},
        )
        disk_restore_point_attributes_read.source_disk_restore_point = AAZObjectType(
            serialized_name="sourceDiskRestorePoint",
        )
        cls._build_schema_api_entity_reference_read(disk_restore_point_attributes_read.source_disk_restore_point)

        encryption = _schema_disk_restore_point_attributes_read.encryption
        encryption.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(encryption.disk_encryption_set)
        encryption.type = AAZStrType()

        _schema.encryption = cls._schema_disk_restore_point_attributes_read.encryption
        _schema.id = cls._schema_disk_restore_point_attributes_read.id
        _schema.source_disk_restore_point = cls._schema_disk_restore_point_attributes_read.source_disk_restore_point

    _schema_host_endpoint_settings_read = None

    @classmethod
    def _build_schema_host_endpoint_settings_read(cls, _schema):
        if cls._schema_host_endpoint_settings_read is not None:
            _schema.in_vm_access_control_profile_reference_id = cls._schema_host_endpoint_settings_read.in_vm_access_control_profile_reference_id
            _schema.mode = cls._schema_host_endpoint_settings_read.mode
            return

        cls._schema_host_endpoint_settings_read = _schema_host_endpoint_settings_read = AAZObjectType()

        host_endpoint_settings_read = _schema_host_endpoint_settings_read
        host_endpoint_settings_read.in_vm_access_control_profile_reference_id = AAZStrType(
            serialized_name="inVMAccessControlProfileReferenceId",
        )
        host_endpoint_settings_read.mode = AAZStrType()

        _schema.in_vm_access_control_profile_reference_id = cls._schema_host_endpoint_settings_read.in_vm_access_control_profile_reference_id
        _schema.mode = cls._schema_host_endpoint_settings_read.mode

    _schema_instance_view_status_read = None

    @classmethod
    def _build_schema_instance_view_status_read(cls, _schema):
        if cls._schema_instance_view_status_read is not None:
            _schema.code = cls._schema_instance_view_status_read.code
            _schema.display_status = cls._schema_instance_view_status_read.display_status
            _schema.level = cls._schema_instance_view_status_read.level
            _schema.message = cls._schema_instance_view_status_read.message
            _schema.time = cls._schema_instance_view_status_read.time
            return

        cls._schema_instance_view_status_read = _schema_instance_view_status_read = AAZObjectType()

        instance_view_status_read = _schema_instance_view_status_read
        instance_view_status_read.code = AAZStrType()
        instance_view_status_read.display_status = AAZStrType(
            serialized_name="displayStatus",
        )
        instance_view_status_read.level = AAZStrType()
        instance_view_status_read.message = AAZStrType()
        instance_view_status_read.time = AAZStrType()

        _schema.code = cls._schema_instance_view_status_read.code
        _schema.display_status = cls._schema_instance_view_status_read.display_status
        _schema.level = cls._schema_instance_view_status_read.level
        _schema.message = cls._schema_instance_view_status_read.message
        _schema.time = cls._schema_instance_view_status_read.time

    _schema_managed_disk_parameters_read = None

    @classmethod
    def _build_schema_managed_disk_parameters_read(cls, _schema):
        if cls._schema_managed_disk_parameters_read is not None:
            _schema.disk_encryption_set = cls._schema_managed_disk_parameters_read.disk_encryption_set
            _schema.id = cls._schema_managed_disk_parameters_read.id
            _schema.security_profile = cls._schema_managed_disk_parameters_read.security_profile
            _schema.storage_account_type = cls._schema_managed_disk_parameters_read.storage_account_type
            return

        cls._schema_managed_disk_parameters_read = _schema_managed_disk_parameters_read = AAZObjectType()

        managed_disk_parameters_read = _schema_managed_disk_parameters_read
        managed_disk_parameters_read.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(managed_disk_parameters_read.disk_encryption_set)
        managed_disk_parameters_read.id = AAZStrType()
        managed_disk_parameters_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        managed_disk_parameters_read.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        security_profile = _schema_managed_disk_parameters_read.security_profile
        security_profile.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrType(
            serialized_name="securityEncryptionType",
        )

        _schema.disk_encryption_set = cls._schema_managed_disk_parameters_read.disk_encryption_set
        _schema.id = cls._schema_managed_disk_parameters_read.id
        _schema.security_profile = cls._schema_managed_disk_parameters_read.security_profile
        _schema.storage_account_type = cls._schema_managed_disk_parameters_read.storage_account_type

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["Create"]
