// Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Code generated by mockery v2.46.3. DO NOT EDIT.

package mocks

import (
	communicator "github.com/aws/session-manager-plugin/src/communicator"
	datachannel "github.com/aws/session-manager-plugin/src/datachannel"

	list "container/list"

	log "github.com/aws/session-manager-plugin/src/log"

	message "github.com/aws/session-manager-plugin/src/message"

	mock "github.com/stretchr/testify/mock"

	v4 "github.com/aws/aws-sdk-go/aws/signer/v4"
)

// IDataChannel is an autogenerated mock type for the IDataChannel type
type IDataChannel struct {
	mock.Mock
}

// AddDataToIncomingMessageBuffer provides a mock function with given fields: streamMessage
func (_m *IDataChannel) AddDataToIncomingMessageBuffer(streamMessage datachannel.StreamingMessage) {
	_m.Called(streamMessage)
}

// AddDataToOutgoingMessageBuffer provides a mock function with given fields: streamMessage
func (_m *IDataChannel) AddDataToOutgoingMessageBuffer(streamMessage datachannel.StreamingMessage) {
	_m.Called(streamMessage)
}

// CalculateRetransmissionTimeout provides a mock function with given fields: _a0, streamingMessage
func (_m *IDataChannel) CalculateRetransmissionTimeout(_a0 log.T, streamingMessage datachannel.StreamingMessage) {
	_m.Called(_a0, streamingMessage)
}

// Close provides a mock function with given fields: _a0
func (_m *IDataChannel) Close(_a0 log.T) error {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for Close")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeregisterOutputStreamHandler provides a mock function with given fields: handler
func (_m *IDataChannel) DeregisterOutputStreamHandler(handler datachannel.OutputStreamDataMessageHandler) {
	_m.Called(handler)
}

// FinalizeDataChannelHandshake provides a mock function with given fields: _a0, tokenValue
func (_m *IDataChannel) FinalizeDataChannelHandshake(_a0 log.T, tokenValue string) error {
	ret := _m.Called(_a0, tokenValue)

	if len(ret) == 0 {
		panic("no return value specified for FinalizeDataChannelHandshake")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, string) error); ok {
		r0 = rf(_a0, tokenValue)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetAgentVersion provides a mock function with given fields:
func (_m *IDataChannel) GetAgentVersion() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAgentVersion")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetSessionProperties provides a mock function with given fields:
func (_m *IDataChannel) GetSessionProperties() interface{} {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetSessionProperties")
	}

	var r0 interface{}
	if rf, ok := ret.Get(0).(func() interface{}); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(interface{})
		}
	}

	return r0
}

// GetSessionType provides a mock function with given fields:
func (_m *IDataChannel) GetSessionType() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetSessionType")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetStreamDataSequenceNumber provides a mock function with given fields:
func (_m *IDataChannel) GetStreamDataSequenceNumber() int64 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetStreamDataSequenceNumber")
	}

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetWsChannel provides a mock function with given fields:
func (_m *IDataChannel) GetWsChannel() communicator.IWebSocketChannel {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetWsChannel")
	}

	var r0 communicator.IWebSocketChannel
	if rf, ok := ret.Get(0).(func() communicator.IWebSocketChannel); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(communicator.IWebSocketChannel)
		}
	}

	return r0
}

// Initialize provides a mock function with given fields: _a0, clientId, sessionId, targetId, isAwsCliUpgradeNeeded
func (_m *IDataChannel) Initialize(_a0 log.T, clientId string, sessionId string, targetId string, isAwsCliUpgradeNeeded bool) {
	_m.Called(_a0, clientId, sessionId, targetId, isAwsCliUpgradeNeeded)
}

// IsSessionTypeSet provides a mock function with given fields:
func (_m *IDataChannel) IsSessionTypeSet() chan bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsSessionTypeSet")
	}

	var r0 chan bool
	if rf, ok := ret.Get(0).(func() chan bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan bool)
		}
	}

	return r0
}

// IsStreamMessageResendTimeout provides a mock function with given fields:
func (_m *IDataChannel) IsStreamMessageResendTimeout() chan bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsStreamMessageResendTimeout")
	}

	var r0 chan bool
	if rf, ok := ret.Get(0).(func() chan bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan bool)
		}
	}

	return r0
}

// Open provides a mock function with given fields: _a0
func (_m *IDataChannel) Open(_a0 log.T) error {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for Open")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// OutputMessageHandler provides a mock function with given fields: _a0, stopHandler, sessionID, rawMessage
func (_m *IDataChannel) OutputMessageHandler(_a0 log.T, stopHandler datachannel.Stop, sessionID string, rawMessage []byte) error {
	ret := _m.Called(_a0, stopHandler, sessionID, rawMessage)

	if len(ret) == 0 {
		panic("no return value specified for OutputMessageHandler")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, datachannel.Stop, string, []byte) error); ok {
		r0 = rf(_a0, stopHandler, sessionID, rawMessage)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ProcessAcknowledgedMessage provides a mock function with given fields: _a0, acknowledgeMessageContent
func (_m *IDataChannel) ProcessAcknowledgedMessage(_a0 log.T, acknowledgeMessageContent message.AcknowledgeContent) error {
	ret := _m.Called(_a0, acknowledgeMessageContent)

	if len(ret) == 0 {
		panic("no return value specified for ProcessAcknowledgedMessage")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, message.AcknowledgeContent) error); ok {
		r0 = rf(_a0, acknowledgeMessageContent)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Reconnect provides a mock function with given fields: _a0
func (_m *IDataChannel) Reconnect(_a0 log.T) error {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for Reconnect")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RegisterOutputStreamHandler provides a mock function with given fields: handler, isSessionSpecificHandler
func (_m *IDataChannel) RegisterOutputStreamHandler(handler datachannel.OutputStreamDataMessageHandler, isSessionSpecificHandler bool) {
	_m.Called(handler, isSessionSpecificHandler)
}

// RemoveDataFromIncomingMessageBuffer provides a mock function with given fields: sequenceNumber
func (_m *IDataChannel) RemoveDataFromIncomingMessageBuffer(sequenceNumber int64) {
	_m.Called(sequenceNumber)
}

// RemoveDataFromOutgoingMessageBuffer provides a mock function with given fields: streamMessageElement
func (_m *IDataChannel) RemoveDataFromOutgoingMessageBuffer(streamMessageElement *list.Element) {
	_m.Called(streamMessageElement)
}

// ResendStreamDataMessageScheduler provides a mock function with given fields: _a0
func (_m *IDataChannel) ResendStreamDataMessageScheduler(_a0 log.T) error {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for ResendStreamDataMessageScheduler")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendAcknowledgeMessage provides a mock function with given fields: _a0, clientMessage
func (_m *IDataChannel) SendAcknowledgeMessage(_a0 log.T, clientMessage message.ClientMessage) error {
	ret := _m.Called(_a0, clientMessage)

	if len(ret) == 0 {
		panic("no return value specified for SendAcknowledgeMessage")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, message.ClientMessage) error); ok {
		r0 = rf(_a0, clientMessage)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendFlag provides a mock function with given fields: _a0, flagType
func (_m *IDataChannel) SendFlag(_a0 log.T, flagType message.PayloadTypeFlag) error {
	ret := _m.Called(_a0, flagType)

	if len(ret) == 0 {
		panic("no return value specified for SendFlag")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, message.PayloadTypeFlag) error); ok {
		r0 = rf(_a0, flagType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendInputDataMessage provides a mock function with given fields: _a0, payloadType, inputData
func (_m *IDataChannel) SendInputDataMessage(_a0 log.T, payloadType message.PayloadType, inputData []byte) error {
	ret := _m.Called(_a0, payloadType, inputData)

	if len(ret) == 0 {
		panic("no return value specified for SendInputDataMessage")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, message.PayloadType, []byte) error); ok {
		r0 = rf(_a0, payloadType, inputData)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendMessage provides a mock function with given fields: _a0, input, inputType
func (_m *IDataChannel) SendMessage(_a0 log.T, input []byte, inputType int) error {
	ret := _m.Called(_a0, input, inputType)

	if len(ret) == 0 {
		panic("no return value specified for SendMessage")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, []byte, int) error); ok {
		r0 = rf(_a0, input, inputType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetAgentVersion provides a mock function with given fields: agentVersion
func (_m *IDataChannel) SetAgentVersion(agentVersion string) {
	_m.Called(agentVersion)
}

// SetSessionType provides a mock function with given fields: sessionType
func (_m *IDataChannel) SetSessionType(sessionType string) {
	_m.Called(sessionType)
}

// SetWebsocket provides a mock function with given fields: _a0, streamUrl, tokenValue, region, signer
func (_m *IDataChannel) SetWebsocket(_a0 log.T, streamUrl string, tokenValue string, region string, signer *v4.Signer) {
	_m.Called(_a0, streamUrl, tokenValue, region, signer)
}

// SetWsChannel provides a mock function with given fields: wsChannel
func (_m *IDataChannel) SetWsChannel(wsChannel communicator.IWebSocketChannel) {
	_m.Called(wsChannel)
}

// NewIDataChannel creates a new instance of IDataChannel. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewIDataChannel(t interface {
	mock.TestingT
	Cleanup(func())
}) *IDataChannel {
	mock := &IDataChannel{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
