/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.initialization.ClassLoaderScopeRegistryListenerManager;
import org.gradle.internal.buildtree.BuildTreeLifecycleListener;
import org.gradle.internal.cc.impl.serialize.ClassLoaderRole;
import org.gradle.internal.cc.impl.serialize.ClassLoaderScopeSpec;
import org.gradle.internal.cc.impl.serialize.ClassLoadingKt;
import org.gradle.internal.cc.impl.serialize.DefaultClassEncoderKt;
import org.gradle.internal.cc.impl.serialize.ScopeLookup;
import org.gradle.internal.classloader.DelegatingClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J2\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheClassLoaderScopeRegistryListener;", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListener;", "Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;", "Lorg/gradle/internal/buildtree/BuildTreeLifecycleListener;", "Ljava/io/Closeable;", "listenerManager", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;", "<init>", "(Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;)V", "lock", "", "scopeSpecs", "", "Lorg/gradle/initialization/ClassLoaderScopeId;", "Lorg/gradle/internal/cc/impl/serialize/ClassLoaderScopeSpec;", "loaders", "Ljava/util/IdentityHashMap;", "Ljava/lang/ClassLoader;", "Lkotlin/Pair;", "Lorg/gradle/internal/cc/impl/serialize/ClassLoaderRole;", "disposed", "", "afterStart", "", "dispose", "close", "scopeFor", "classLoader", "knownClassLoaders", "", "getKnownClassLoaders", "()Ljava/util/Set;", "childScopeCreated", "parentId", "childId", "origin", "Lorg/gradle/initialization/ClassLoaderScopeOrigin;", "classloaderCreated", "scopeId", "classLoaderId", "Lorg/gradle/api/internal/initialization/loadercache/ClassLoaderId;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "implementationHash", "Lorg/gradle/internal/hash/HashCode;", "assertNotDisposed", "method", "", "configuration-cache"})
public final class ConfigurationCacheClassLoaderScopeRegistryListener
implements ClassLoaderScopeRegistryListener,
ScopeLookup,
BuildTreeLifecycleListener,
Closeable {
    @NotNull
    private final ClassLoaderScopeRegistryListenerManager listenerManager;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<ClassLoaderScopeId, ClassLoaderScopeSpec> scopeSpecs;
    @NotNull
    private final IdentityHashMap<ClassLoader, Pair<ClassLoaderScopeSpec, ClassLoaderRole>> loaders;
    private boolean disposed;

    public ConfigurationCacheClassLoaderScopeRegistryListener(@NotNull ClassLoaderScopeRegistryListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.listenerManager = listenerManager;
        this.lock = new Object();
        this.scopeSpecs = new LinkedHashMap();
        this.loaders = new IdentityHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterStart() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotDisposed("afterStart");
            this.listenerManager.add((ClassLoaderScopeRegistryListener)this);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.disposed) {
                return;
            }
            this.scopeSpecs.clear();
            this.loaders.clear();
            this.listenerManager.remove((ClassLoaderScopeRegistryListener)this);
            this.disposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Pair<ClassLoaderScopeSpec, ClassLoaderRole> scopeFor(@Nullable ClassLoader classLoader) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotDisposed("scopeFor");
            Pair<ClassLoaderScopeSpec, ClassLoaderRole> pair = this.loaders.get(classLoader);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<ClassLoader> getKnownClassLoaders() {
        ImmutableSet immutableSet;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ImmutableSet immutableSet2 = ImmutableSet.copyOf((Collection)this.loaders.keySet());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            immutableSet = immutableSet2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"synchronized(...)");
        return (Set)immutableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childScopeCreated(@NotNull ClassLoaderScopeId parentId, @NotNull ClassLoaderScopeId childId, @Nullable ClassLoaderScopeOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)childId, (String)"childId");
        Object object = this.lock;
        synchronized (object) {
            ClassLoaderScopeSpec classLoaderScopeSpec;
            boolean parentIsRoot;
            boolean bl = false;
            this.assertNotDisposed("childScopeCreated");
            if (this.scopeSpecs.containsKey(childId)) {
                return;
            }
            boolean bl2 = parentIsRoot = parentId.getParent() == null;
            if (parentIsRoot) {
                classLoaderScopeSpec = null;
            } else {
                ClassLoaderScopeSpec lookupParent = this.scopeSpecs.get(parentId);
                if (!(lookupParent != null)) {
                    boolean bl3 = false;
                    String string = "Cannot find parent " + parentId + " for child scope " + childId;
                    throw new IllegalArgumentException(string.toString());
                }
                classLoaderScopeSpec = lookupParent;
            }
            ClassLoaderScopeSpec parent = classLoaderScopeSpec;
            String string = childId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ClassLoaderScopeSpec child = new ClassLoaderScopeSpec(parent, string, origin);
            this.scopeSpecs.put(childId, child);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classloaderCreated(@NotNull ClassLoaderScopeId scopeId, @NotNull ClassLoaderId classLoaderId, @NotNull ClassLoader classLoader, @NotNull ClassPath classPath, @Nullable HashCode implementationHash) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)classLoaderId, (String)"classLoaderId");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        if (!(!(classLoader instanceof DelegatingClassLoader))) {
            boolean bl = false;
            String string = "Unexpected delegating " + ClassLoadingKt.describeClassLoader(classLoader) + " with id '" + classLoaderId + "' for scope '" + scopeId + "' with classpath '" + classPath + "'.\n" + DefaultClassEncoderKt.describeKnownClassLoaders(this) + "Please report this error, run './gradlew --stop' and try again.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            boolean local;
            boolean bl = false;
            this.assertNotDisposed("classloaderCreated");
            ClassLoaderScopeSpec spec = this.scopeSpecs.get(scopeId);
            if (!(spec != null)) {
                boolean bl2 = false;
                String string = "Spec for ClassLoaderScope '" + scopeId + "' not found!";
                throw new IllegalStateException(string.toString());
            }
            boolean bl3 = local = scopeId instanceof ClassLoaderScopeIdentifier && Intrinsics.areEqual((Object)((ClassLoaderScopeIdentifier)scopeId).localId(), (Object)classLoaderId);
            if (local) {
                spec.setLocalClassPath(classPath);
                spec.setLocalImplementationHash(implementationHash);
            } else {
                spec.setExportClassPath(classPath);
            }
            ((Map)this.loaders).put(classLoader, new Pair((Object)spec, (Object)ClassLoaderRole.box-impl(ClassLoaderRole.constructor-impl(local))));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void assertNotDisposed(String method) {
        if (!(!this.disposed)) {
            boolean bl = false;
            String string = this.getClass().getSimpleName() + '.' + method + " cannot be used after being disposed of.";
            throw new IllegalStateException(string.toString());
        }
    }
}

