/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.Arrays;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class AliasMethod
extends DynamicMethod {
    private final CacheEntry entry;
    private final boolean findImplementer;
    private final String newName;
    private final String compoundName;
    private static List<String> ALWAYS_PRIVATE_NAMES = Arrays.asList("initialize", "initialize_copy", "initialize_clone", "initialize_dup", "respond_to_missing?");

    public AliasMethod(RubyModule implementationClass, CacheEntry entry, String newName, String oldName) {
        super(implementationClass, AliasMethod.determineVisibility(newName, entry.method.getVisibility()), oldName);
        entry.method.getRealMethod().adjustAliasCount(1);
        this.entry = entry;
        boolean findImplementer = true;
        if (entry.method instanceof AbstractIRMethod) {
            findImplementer = ((AbstractIRMethod)entry.method).needsToFindImplementer();
        }
        this.findImplementer = findImplementer;
        this.newName = newName;
        this.compoundName = "\u0000" + newName + "\u0000" + oldName;
    }

    private static Visibility determineVisibility(String newName, Visibility visibility) {
        return ALWAYS_PRIVATE_NAMES.contains(newName) ? Visibility.PRIVATE : visibility;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject[] args2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg1, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg1, arg2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, arg1, arg2, arg3, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String unused2, IRubyObject[] args2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), this.compoundName, args2, block);
    }

    @Override
    public DynamicMethod dup() {
        return new AliasMethod(this.implementationClass, this.entry, this.newName, this.name);
    }

    @Override
    @Deprecated
    public Arity getArity() {
        return this.entry.method.getArity();
    }

    @Override
    public Signature getSignature() {
        return this.entry.method.getSignature();
    }

    public String getOldName() {
        return this.entry.method.getName();
    }

    @Override
    public DynamicMethod getRealMethod() {
        return this.entry.method.getRealMethod();
    }

    @Override
    public long getSerialNumber() {
        return this.entry.method.getSerialNumber();
    }

    private RubyModule calculateSourceModule(IRubyObject self2, RubyModule incomingSourceModule) {
        if (this.findImplementer) {
            return Helpers.findImplementerIfNecessary(self2.getMetaClass(), this.entry.method.getImplementationClass());
        }
        return incomingSourceModule;
    }

    @Override
    public boolean isNative() {
        return this.entry.method.isNative();
    }

    @Override
    public void setRuby2Keywords() {
        this.entry.method.setRuby2Keywords();
    }
}

