// generated by diplomat-tool
import { Calendar } from "./Calendar.mjs"
import { Date } from "./Date.mjs"
import { IanaParser } from "./IanaParser.mjs"
import { Rfc9557ParseError } from "./Rfc9557ParseError.mjs"
import { Time } from "./Time.mjs"
import { TimeZoneInfo } from "./TimeZoneInfo.mjs"
import { VariantOffsetsCalculator } from "./VariantOffsetsCalculator.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X DateTime object capable of containing a date, time, and zone for any calendar.
 *
 * See the [Rust documentation for `ZonedDateTime`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html) for more information.
 */


export class ZonedDateTime {
    #date;
    get date() {
        return this.#date;
    }
    #time;
    get time() {
        return this.#time;
    }
    #zone;
    get zone() {
        return this.#zone;
    }
    #internalConstructor(structObj, internalConstructor) {
        if (typeof structObj !== "object") {
            throw new Error("ZonedDateTime's constructor takes an object of ZonedDateTime's fields.");
        }

        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("ZonedDateTime is an out struct and can only be created internally.");
        }
        if ("date" in structObj) {
            this.#date = structObj.date;
        } else {
            throw new Error("Missing required field date.");
        }

        if ("time" in structObj) {
            this.#time = structObj.time;
        } else {
            throw new Error("Missing required field time.");
        }

        if ("zone" in structObj) {
            this.#zone = structObj.zone;
        } else {
            throw new Error("Missing required field zone.");
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [this.#date.ffiValue, this.#time.ffiValue, this.#zone.ffiValue]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof ZonedDateTime) {
            return obj;
        }

        return ZonedDateTime.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, this.#date.ffiValue, Uint32Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 4, this.#time.ffiValue, Uint32Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 8, this.#zone.ffiValue, Uint32Array);
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("ZonedDateTime._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const dateDeref = diplomatRuntime.ptrRead(wasm, ptr);
        structObj.date = new Date(diplomatRuntime.internalConstructor, dateDeref, []);
        const timeDeref = diplomatRuntime.ptrRead(wasm, ptr + 4);
        structObj.time = new Time(diplomatRuntime.internalConstructor, timeDeref, []);
        const zoneDeref = diplomatRuntime.ptrRead(wasm, ptr + 8);
        structObj.zone = new TimeZoneInfo(diplomatRuntime.internalConstructor, zoneDeref, []);

        return new ZonedDateTime(structObj, internalConstructor);
    }


    /**
     * Creates a new [`ZonedDateTime`] from an IXDTF string.
     *
     * See the [Rust documentation for `try_full_from_str`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.try_full_from_str) for more information.
     */
    static fullFromString(v, calendar, ianaParser, offsetCalculator) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 13, 4, true);


        const result = wasm.icu4x_ZonedDateTime_full_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat(), calendar.ffiValue, ianaParser.ffiValue, offsetCalculator.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return ZonedDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`ZonedDateTime`] from a location-only IXDTF string.
     *
     * See the [Rust documentation for `try_location_only_from_str`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.try_location_only_from_str) for more information.
     */
    static locationOnlyFromString(v, calendar, ianaParser) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 13, 4, true);


        const result = wasm.icu4x_ZonedDateTime_location_only_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat(), calendar.ffiValue, ianaParser.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return ZonedDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`ZonedDateTime`] from an offset-only IXDTF string.
     *
     * See the [Rust documentation for `try_offset_only_from_str`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.try_offset_only_from_str) for more information.
     */
    static offsetOnlyFromString(v, calendar) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 13, 4, true);


        const result = wasm.icu4x_ZonedDateTime_offset_only_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat(), calendar.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return ZonedDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`ZonedDateTime`] from an IXDTF string, without requiring the offset or calculating the zone variant.
     *
     * See the [Rust documentation for `try_lenient_from_str`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.try_lenient_from_str) for more information.
     */
    static lenientFromString(v, calendar, ianaParser) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 13, 4, true);


        const result = wasm.icu4x_ZonedDateTime_lenient_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat(), calendar.ffiValue, ianaParser.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return ZonedDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    constructor(structObj, internalConstructor) {
        return this.#internalConstructor(...arguments)
    }
}