// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The established temporary security credentials of the session.</p><note>
/// <p><b>Directory buckets</b> - These session credentials are only supported for the authentication and authorization of Zonal endpoint API operations on directory buckets.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct SessionCredentials {
    /// <p>A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.</p>
    pub access_key_id: ::std::string::String,
    /// <p>A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.</p>
    pub secret_access_key: ::std::string::String,
    /// <p>A part of the temporary security credentials. The session token is used to validate the temporary security credentials.</p>
    pub session_token: ::std::string::String,
    /// <p>Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.</p>
    pub expiration: ::aws_smithy_types::DateTime,
}
impl SessionCredentials {
    /// <p>A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.</p>
    pub fn access_key_id(&self) -> &str {
        use std::ops::Deref;
        self.access_key_id.deref()
    }
    /// <p>A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.</p>
    pub fn secret_access_key(&self) -> &str {
        use std::ops::Deref;
        self.secret_access_key.deref()
    }
    /// <p>A part of the temporary security credentials. The session token is used to validate the temporary security credentials.</p>
    pub fn session_token(&self) -> &str {
        use std::ops::Deref;
        self.session_token.deref()
    }
    /// <p>Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.</p>
    pub fn expiration(&self) -> &::aws_smithy_types::DateTime {
        &self.expiration
    }
}
impl ::std::fmt::Debug for SessionCredentials {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("SessionCredentials");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
impl SessionCredentials {
    /// Creates a new builder-style object to manufacture [`SessionCredentials`](crate::types::SessionCredentials).
    pub fn builder() -> crate::types::builders::SessionCredentialsBuilder {
        crate::types::builders::SessionCredentialsBuilder::default()
    }
}

/// A builder for [`SessionCredentials`](crate::types::SessionCredentials).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct SessionCredentialsBuilder {
    pub(crate) access_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) secret_access_key: ::std::option::Option<::std::string::String>,
    pub(crate) session_token: ::std::option::Option<::std::string::String>,
    pub(crate) expiration: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl SessionCredentialsBuilder {
    /// <p>A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.</p>
    /// This field is required.
    pub fn access_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.access_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.</p>
    pub fn set_access_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.access_key_id = input;
        self
    }
    /// <p>A unique identifier that's associated with a secret access key. The access key ID and the secret access key are used together to sign programmatic Amazon Web Services requests cryptographically.</p>
    pub fn get_access_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.access_key_id
    }
    /// <p>A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.</p>
    /// This field is required.
    pub fn secret_access_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.secret_access_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.</p>
    pub fn set_secret_access_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.secret_access_key = input;
        self
    }
    /// <p>A key that's used with the access key ID to cryptographically sign programmatic Amazon Web Services requests. Signing a request identifies the sender and prevents the request from being altered.</p>
    pub fn get_secret_access_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.secret_access_key
    }
    /// <p>A part of the temporary security credentials. The session token is used to validate the temporary security credentials.</p>
    /// This field is required.
    pub fn session_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A part of the temporary security credentials. The session token is used to validate the temporary security credentials.</p>
    pub fn set_session_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_token = input;
        self
    }
    /// <p>A part of the temporary security credentials. The session token is used to validate the temporary security credentials.</p>
    pub fn get_session_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_token
    }
    /// <p>Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.</p>
    /// This field is required.
    pub fn expiration(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.expiration = ::std::option::Option::Some(input);
        self
    }
    /// <p>Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.</p>
    pub fn set_expiration(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.expiration = input;
        self
    }
    /// <p>Temporary security credentials expire after a specified interval. After temporary credentials expire, any calls that you make with those credentials will fail. So you must generate a new set of temporary credentials. Temporary credentials cannot be extended or refreshed beyond the original specified interval.</p>
    pub fn get_expiration(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.expiration
    }
    /// Consumes the builder and constructs a [`SessionCredentials`](crate::types::SessionCredentials).
    /// This method will fail if any of the following fields are not set:
    /// - [`access_key_id`](crate::types::builders::SessionCredentialsBuilder::access_key_id)
    /// - [`secret_access_key`](crate::types::builders::SessionCredentialsBuilder::secret_access_key)
    /// - [`session_token`](crate::types::builders::SessionCredentialsBuilder::session_token)
    /// - [`expiration`](crate::types::builders::SessionCredentialsBuilder::expiration)
    pub fn build(self) -> ::std::result::Result<crate::types::SessionCredentials, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::SessionCredentials {
            access_key_id: self.access_key_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "access_key_id",
                    "access_key_id was not specified but it is required when building SessionCredentials",
                )
            })?,
            secret_access_key: self.secret_access_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "secret_access_key",
                    "secret_access_key was not specified but it is required when building SessionCredentials",
                )
            })?,
            session_token: self.session_token.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "session_token",
                    "session_token was not specified but it is required when building SessionCredentials",
                )
            })?,
            expiration: self.expiration.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "expiration",
                    "expiration was not specified but it is required when building SessionCredentials",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for SessionCredentialsBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("SessionCredentialsBuilder");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
