// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InventoryEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub sses3: ::std::option::Option<crate::types::Sses3>,
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub ssekms: ::std::option::Option<crate::types::Ssekms>,
}
impl InventoryEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub fn sses3(&self) -> ::std::option::Option<&crate::types::Sses3> {
        self.sses3.as_ref()
    }
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub fn ssekms(&self) -> ::std::option::Option<&crate::types::Ssekms> {
        self.ssekms.as_ref()
    }
}
impl InventoryEncryption {
    /// Creates a new builder-style object to manufacture [`InventoryEncryption`](crate::types::InventoryEncryption).
    pub fn builder() -> crate::types::builders::InventoryEncryptionBuilder {
        crate::types::builders::InventoryEncryptionBuilder::default()
    }
}

/// A builder for [`InventoryEncryption`](crate::types::InventoryEncryption).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InventoryEncryptionBuilder {
    pub(crate) sses3: ::std::option::Option<crate::types::Sses3>,
    pub(crate) ssekms: ::std::option::Option<crate::types::Ssekms>,
}
impl InventoryEncryptionBuilder {
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub fn sses3(mut self, input: crate::types::Sses3) -> Self {
        self.sses3 = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub fn set_sses3(mut self, input: ::std::option::Option<crate::types::Sses3>) -> Self {
        self.sses3 = input;
        self
    }
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub fn get_sses3(&self) -> &::std::option::Option<crate::types::Sses3> {
        &self.sses3
    }
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub fn ssekms(mut self, input: crate::types::Ssekms) -> Self {
        self.ssekms = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub fn set_ssekms(mut self, input: ::std::option::Option<crate::types::Ssekms>) -> Self {
        self.ssekms = input;
        self
    }
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub fn get_ssekms(&self) -> &::std::option::Option<crate::types::Ssekms> {
        &self.ssekms
    }
    /// Consumes the builder and constructs a [`InventoryEncryption`](crate::types::InventoryEncryption).
    pub fn build(self) -> crate::types::InventoryEncryption {
        crate::types::InventoryEncryption {
            sses3: self.sses3,
            ssekms: self.ssekms,
        }
    }
}
