// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketOwnershipControls`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::set_content_md5):<br>required: **false**<br><p>The MD5 hash of the <code>OwnershipControls</code> request body.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`ownership_controls(OwnershipControls)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::ownership_controls) / [`set_ownership_controls(Option<OwnershipControls>)`](crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::set_ownership_controls):<br>required: **true**<br><p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p><br>
    /// - On success, responds with [`PutBucketOwnershipControlsOutput`](crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsOutput)
    /// - On failure, responds with [`SdkError<PutBucketOwnershipControlsError>`](crate::operation::put_bucket_ownership_controls::PutBucketOwnershipControlsError)
    pub fn put_bucket_ownership_controls(
        &self,
    ) -> crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder {
        crate::operation::put_bucket_ownership_controls::builders::PutBucketOwnershipControlsFluentBuilder::new(self.handle.clone())
    }
}
