// Generated by make_intl_data.py. DO NOT EDIT.

/* eslint-disable complexity */
// Mappings from complete tags to preferred values.
// Derived from IANA Language Subtag Registry, file date 2018-03-30.
// https://www.iana.org/assignments/language-subtag-registry
function updateLangTagMappings(tag) {
    assert(IsObject(tag), "tag is an object");
    assert(!hasOwn("grandfathered", tag), "tag is not a grandfathered tag");

    switch (tag.language) {
      case "hy":
        // hy-arevela -> hy
        if (tag.variants.length >= 1 &&
            callFunction(ArrayIndexOf, tag.variants, "arevela") > -1)
        {
            var newVariants = [];
            for (var i = 0; i < tag.variants.length; i++) {
                var variant = tag.variants[i];
                if (variant === "arevela")
                    continue;
                _DefineDataProperty(newVariants, newVariants.length, variant);
            }
            tag.variants = newVariants;
        }
        // hy-arevmda -> hyw
        else if (tag.variants.length >= 1 &&
                 callFunction(ArrayIndexOf, tag.variants, "arevmda") > -1)
        {
            tag.language = "hyw";
            var newVariants = [];
            for (var i = 0; i < tag.variants.length; i++) {
                var variant = tag.variants[i];
                if (variant === "arevmda")
                    continue;
                _DefineDataProperty(newVariants, newVariants.length, variant);
            }
            tag.variants = newVariants;
        }
        break;
      case "ja":
        // ja-Latn-hepburn-heploc -> ja-Latn-alalc97
        if (tag.script === "Latn" &&
            tag.variants.length >= 2 &&
            callFunction(ArrayIndexOf, tag.variants, "hepburn") > -1 &&
            callFunction(ArrayIndexOf, tag.variants, "heploc", callFunction(ArrayIndexOf, tag.variants, "hepburn") + 1) > -1)
        {
            var newVariants = [];
            for (var i = 0; i < tag.variants.length; i++) {
                var variant = tag.variants[i];
                if (variant === "hepburn")
                    continue;
                if (variant === "heploc")
                    continue;
                _DefineDataProperty(newVariants, newVariants.length, variant);
            }
            if (callFunction(ArrayIndexOf, newVariants, "alalc97") < 0)
                _DefineDataProperty(newVariants, newVariants.length, "alalc97");
            tag.variants = newVariants;
        }
        break;
      case "sgn":
        // sgn-BR -> bzs
        if (tag.region === "BR" &&
            tag.extlang1 === undefined &&
            tag.extlang2 === undefined &&
            tag.extlang3 === undefined &&
            tag.script === undefined &&
            tag.variants.length === 0 &&
            tag.extensions.length === 0 &&
            tag.privateuse === undefined)
        {
            tag.language = "bzs";
            tag.region = undefined;
        }
        // sgn-CO -> csn
        else if (tag.region === "CO" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "csn";
            tag.region = undefined;
        }
        // sgn-DE -> gsg
        else if (tag.region === "DE" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "gsg";
            tag.region = undefined;
        }
        // sgn-DK -> dsl
        else if (tag.region === "DK" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "dsl";
            tag.region = undefined;
        }
        // sgn-ES -> ssp
        else if (tag.region === "ES" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "ssp";
            tag.region = undefined;
        }
        // sgn-FR -> fsl
        else if (tag.region === "FR" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "fsl";
            tag.region = undefined;
        }
        // sgn-GB -> bfi
        else if (tag.region === "GB" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "bfi";
            tag.region = undefined;
        }
        // sgn-GR -> gss
        else if (tag.region === "GR" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "gss";
            tag.region = undefined;
        }
        // sgn-IE -> isg
        else if (tag.region === "IE" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "isg";
            tag.region = undefined;
        }
        // sgn-IT -> ise
        else if (tag.region === "IT" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "ise";
            tag.region = undefined;
        }
        // sgn-JP -> jsl
        else if (tag.region === "JP" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "jsl";
            tag.region = undefined;
        }
        // sgn-MX -> mfs
        else if (tag.region === "MX" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "mfs";
            tag.region = undefined;
        }
        // sgn-NI -> ncs
        else if (tag.region === "NI" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "ncs";
            tag.region = undefined;
        }
        // sgn-NL -> dse
        else if (tag.region === "NL" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "dse";
            tag.region = undefined;
        }
        // sgn-NO -> nsl
        else if (tag.region === "NO" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "nsl";
            tag.region = undefined;
        }
        // sgn-PT -> psr
        else if (tag.region === "PT" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "psr";
            tag.region = undefined;
        }
        // sgn-SE -> swl
        else if (tag.region === "SE" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "swl";
            tag.region = undefined;
        }
        // sgn-US -> ase
        else if (tag.region === "US" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "ase";
            tag.region = undefined;
        }
        // sgn-ZA -> sfs
        else if (tag.region === "ZA" &&
                 tag.extlang1 === undefined &&
                 tag.extlang2 === undefined &&
                 tag.extlang3 === undefined &&
                 tag.script === undefined &&
                 tag.variants.length === 0 &&
                 tag.extensions.length === 0 &&
                 tag.privateuse === undefined)
        {
            tag.language = "sfs";
            tag.region = undefined;
        }
        break;
    }
}
/* eslint-enable complexity */

// Mappings from grandfathered tags to preferred values.
// Derived from IANA Language Subtag Registry, file date 2018-03-30.
// https://www.iana.org/assignments/language-subtag-registry
var grandfatheredMappings = {
    "art-lojban": "jbo",
    "cel-gaulish": "cel-gaulish",
    "en-gb-oed": "en-GB-oxendict",
    "i-ami": "ami",
    "i-bnn": "bnn",
    "i-default": "i-default",
    "i-enochian": "i-enochian",
    "i-hak": "hak",
    "i-klingon": "tlh",
    "i-lux": "lb",
    "i-mingo": "i-mingo",
    "i-navajo": "nv",
    "i-pwn": "pwn",
    "i-tao": "tao",
    "i-tay": "tay",
    "i-tsu": "tsu",
    "no-bok": "nb",
    "no-nyn": "nn",
    "sgn-be-fr": "sfb",
    "sgn-be-nl": "vgt",
    "sgn-ch-de": "sgg",
    "zh-guoyu": "cmn",
    "zh-hakka": "hak",
    "zh-min": "zh-min",
    "zh-min-nan": "nan",
    "zh-xiang": "hsn",
};

// Mappings from language subtags to preferred values.
// Derived from IANA Language Subtag Registry, file date 2018-03-30.
// https://www.iana.org/assignments/language-subtag-registry
var languageMappings = {
    "aam": "aas",
    "adp": "dz",
    "aue": "ktz",
    "ayx": "nun",
    "bgm": "bcg",
    "bjd": "drl",
    "ccq": "rki",
    "cjr": "mom",
    "cka": "cmr",
    "cmk": "xch",
    "coy": "pij",
    "cqu": "quh",
    "drh": "khk",
    "drw": "prs",
    "gav": "dev",
    "gfx": "vaj",
    "ggn": "gvr",
    "gti": "nyc",
    "guv": "duz",
    "hrr": "jal",
    "ibi": "opa",
    "ilw": "gal",
    "in": "id",
    "iw": "he",
    "jeg": "oyb",
    "ji": "yi",
    "jw": "jv",
    "kgc": "tdf",
    "kgh": "kml",
    "koj": "kwv",
    "krm": "bmf",
    "ktr": "dtp",
    "kvs": "gdj",
    "kwq": "yam",
    "kxe": "tvd",
    "kzj": "dtp",
    "kzt": "dtp",
    "lii": "raq",
    "lmm": "rmx",
    "meg": "cir",
    "mo": "ro",
    "mst": "mry",
    "mwj": "vaj",
    "myt": "mry",
    "nad": "xny",
    "ncp": "kdz",
    "nnx": "ngv",
    "nts": "pij",
    "oun": "vaj",
    "pcr": "adx",
    "pmc": "huw",
    "pmu": "phr",
    "ppa": "bfy",
    "ppr": "lcq",
    "pry": "prt",
    "puz": "pub",
    "sca": "hle",
    "skk": "oyb",
    "tdu": "dtp",
    "thc": "tpo",
    "thx": "oyb",
    "tie": "ras",
    "tkk": "twm",
    "tlw": "weo",
    "tmp": "tyj",
    "tne": "kak",
    "tnf": "prs",
    "tsf": "taj",
    "uok": "ema",
    "xba": "cax",
    "xia": "acn",
    "xkh": "waw",
    "xsj": "suj",
    "ybd": "rki",
    "yma": "lrr",
    "ymt": "mtm",
    "yos": "zom",
    "yuu": "yug",
};

// Mappings from region subtags to preferred values.
// Derived from IANA Language Subtag Registry, file date 2018-03-30.
// https://www.iana.org/assignments/language-subtag-registry
var regionMappings = {
    "BU": "MM",
    "DD": "DE",
    "FX": "FR",
    "TP": "TL",
    "YD": "YE",
    "ZR": "CD",
};

// Mappings from extlang subtags to preferred values.
// All current deprecated extlang subtags have the form `<prefix>-<extlang>`
// and their preferred value is exactly equal to `<extlang>`. So each key in
// extlangMappings acts both as the extlang subtag and its preferred value.
// Derived from IANA Language Subtag Registry, file date 2018-03-30.
// https://www.iana.org/assignments/language-subtag-registry
var extlangMappings = {
    "aao": "ar",
    "abh": "ar",
    "abv": "ar",
    "acm": "ar",
    "acq": "ar",
    "acw": "ar",
    "acx": "ar",
    "acy": "ar",
    "adf": "ar",
    "ads": "sgn",
    "aeb": "ar",
    "aec": "ar",
    "aed": "sgn",
    "aen": "sgn",
    "afb": "ar",
    "afg": "sgn",
    "ajp": "ar",
    "apc": "ar",
    "apd": "ar",
    "arb": "ar",
    "arq": "ar",
    "ars": "ar",
    "ary": "ar",
    "arz": "ar",
    "ase": "sgn",
    "asf": "sgn",
    "asp": "sgn",
    "asq": "sgn",
    "asw": "sgn",
    "auz": "ar",
    "avl": "ar",
    "ayh": "ar",
    "ayl": "ar",
    "ayn": "ar",
    "ayp": "ar",
    "bbz": "ar",
    "bfi": "sgn",
    "bfk": "sgn",
    "bjn": "ms",
    "bog": "sgn",
    "bqn": "sgn",
    "bqy": "sgn",
    "btj": "ms",
    "bve": "ms",
    "bvl": "sgn",
    "bvu": "ms",
    "bzs": "sgn",
    "cdo": "zh",
    "cds": "sgn",
    "cjy": "zh",
    "cmn": "zh",
    "coa": "ms",
    "cpx": "zh",
    "csc": "sgn",
    "csd": "sgn",
    "cse": "sgn",
    "csf": "sgn",
    "csg": "sgn",
    "csl": "sgn",
    "csn": "sgn",
    "csq": "sgn",
    "csr": "sgn",
    "czh": "zh",
    "czo": "zh",
    "doq": "sgn",
    "dse": "sgn",
    "dsl": "sgn",
    "dup": "ms",
    "ecs": "sgn",
    "esl": "sgn",
    "esn": "sgn",
    "eso": "sgn",
    "eth": "sgn",
    "fcs": "sgn",
    "fse": "sgn",
    "fsl": "sgn",
    "fss": "sgn",
    "gan": "zh",
    "gds": "sgn",
    "gom": "kok",
    "gse": "sgn",
    "gsg": "sgn",
    "gsm": "sgn",
    "gss": "sgn",
    "gus": "sgn",
    "hab": "sgn",
    "haf": "sgn",
    "hak": "zh",
    "hds": "sgn",
    "hji": "ms",
    "hks": "sgn",
    "hos": "sgn",
    "hps": "sgn",
    "hsh": "sgn",
    "hsl": "sgn",
    "hsn": "zh",
    "icl": "sgn",
    "iks": "sgn",
    "ils": "sgn",
    "inl": "sgn",
    "ins": "sgn",
    "ise": "sgn",
    "isg": "sgn",
    "isr": "sgn",
    "jak": "ms",
    "jax": "ms",
    "jcs": "sgn",
    "jhs": "sgn",
    "jls": "sgn",
    "jos": "sgn",
    "jsl": "sgn",
    "jus": "sgn",
    "kgi": "sgn",
    "knn": "kok",
    "kvb": "ms",
    "kvk": "sgn",
    "kvr": "ms",
    "kxd": "ms",
    "lbs": "sgn",
    "lce": "ms",
    "lcf": "ms",
    "liw": "ms",
    "lls": "sgn",
    "lsl": "sgn",
    "lso": "sgn",
    "lsp": "sgn",
    "lst": "sgn",
    "lsy": "sgn",
    "ltg": "lv",
    "lvs": "lv",
    "lws": "sgn",
    "lzh": "zh",
    "max": "ms",
    "mdl": "sgn",
    "meo": "ms",
    "mfa": "ms",
    "mfb": "ms",
    "mfs": "sgn",
    "min": "ms",
    "mnp": "zh",
    "mqg": "ms",
    "mre": "sgn",
    "msd": "sgn",
    "msi": "ms",
    "msr": "sgn",
    "mui": "ms",
    "mzc": "sgn",
    "mzg": "sgn",
    "mzy": "sgn",
    "nan": "zh",
    "nbs": "sgn",
    "ncs": "sgn",
    "nsi": "sgn",
    "nsl": "sgn",
    "nsp": "sgn",
    "nsr": "sgn",
    "nzs": "sgn",
    "okl": "sgn",
    "orn": "ms",
    "ors": "ms",
    "pel": "ms",
    "pga": "ar",
    "pgz": "sgn",
    "pks": "sgn",
    "prl": "sgn",
    "prz": "sgn",
    "psc": "sgn",
    "psd": "sgn",
    "pse": "ms",
    "psg": "sgn",
    "psl": "sgn",
    "pso": "sgn",
    "psp": "sgn",
    "psr": "sgn",
    "pys": "sgn",
    "rms": "sgn",
    "rsl": "sgn",
    "rsm": "sgn",
    "sdl": "sgn",
    "sfb": "sgn",
    "sfs": "sgn",
    "sgg": "sgn",
    "sgx": "sgn",
    "shu": "ar",
    "slf": "sgn",
    "sls": "sgn",
    "sqk": "sgn",
    "sqs": "sgn",
    "ssh": "ar",
    "ssp": "sgn",
    "ssr": "sgn",
    "svk": "sgn",
    "swc": "sw",
    "swh": "sw",
    "swl": "sgn",
    "syy": "sgn",
    "szs": "sgn",
    "tmw": "ms",
    "tse": "sgn",
    "tsm": "sgn",
    "tsq": "sgn",
    "tss": "sgn",
    "tsy": "sgn",
    "tza": "sgn",
    "ugn": "sgn",
    "ugy": "sgn",
    "ukl": "sgn",
    "uks": "sgn",
    "urk": "ms",
    "uzn": "uz",
    "uzs": "uz",
    "vgt": "sgn",
    "vkk": "ms",
    "vkt": "ms",
    "vsi": "sgn",
    "vsl": "sgn",
    "vsv": "sgn",
    "wbs": "sgn",
    "wuu": "zh",
    "xki": "sgn",
    "xml": "sgn",
    "xmm": "ms",
    "xms": "sgn",
    "ygs": "sgn",
    "yhs": "sgn",
    "ysl": "sgn",
    "yue": "zh",
    "zib": "sgn",
    "zlm": "ms",
    "zmi": "ms",
    "zsl": "sgn",
    "zsm": "ms",
};
