/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         gpib_yyparse
#define yylex           gpib_yylex
#define yyerror         gpib_yyerror
#define yydebug         gpib_yydebug
#define yynerrs         gpib_yynerrs

/* First part of user prologue.  */
#line 1 "ibConfYacc.y"

#include <stdio.h>
#include "ib_internal.h"
#undef EXTERN
#include "ibP.h"
#include <string.h>
#include <stdlib.h>
#include "ibConfYacc.h"
#include "ibConfLex.h"

#define YYERROR_VERBOSE
void yyerror(const YYLTYPE *a, void *b, void *c, const char *s)
{
	fprintf(stderr, "%s\n", s);
}

YY_DECL;

typedef struct
{
	yyscan_t yyscanner;
	ibConf_t *configs;
	unsigned int configs_length;
	unsigned int config_index;
	ibBoard_t *boards;
	unsigned int boards_length;
	int board_index;
	int *device_line_numbers;
	const char *config_file;
}gpib_yyparse_private_t;

static inline gpib_yyparse_private_t* priv(gpib_yyparse_private_t *parse_arg)
{
	return parse_arg;
}

static inline ibConf_t* current_config(gpib_yyparse_private_t *parse_arg)
{
	return &parse_arg->configs[ parse_arg->config_index ];
}

static inline ibBoard_t* current_board(gpib_yyparse_private_t *parse_arg)
{
	if (parse_arg->board_index < 0) return NULL;
	return &parse_arg->boards[ parse_arg->board_index ];
}

void init_gpib_yyparse_private(gpib_yyparse_private_t *priv)
{
	priv->yyscanner = 0;
	priv->configs = NULL;
	priv->configs_length = 0;
	priv->config_index = 0;
	priv->boards = NULL;
	priv->boards_length = 0;
	priv->board_index = -1;
	priv->device_line_numbers = NULL;
	priv->config_file = NULL;
}

static int find_board_config(gpib_yyparse_private_t *priv, int board_index) {
	int i;
	for(i = 0; i < priv->configs_length && priv->configs[ i ].defaults.board >= 0; i++) {
		if (priv->configs[ i ].defaults.board == board_index &&  priv->configs[ i ].is_interface)
			return i;
	}
	return -1;
}

int parse_gpib_conf(const char *filename, ibConf_t *configs, unsigned int configs_length,
		    ibBoard_t *boards, unsigned int boards_length, int minor)
{
	FILE *infile;
	int retval = 0;
	int i,j;
	gpib_yyparse_private_t priv;
	int device_line_nos[configs_length];

	if ((infile = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "failed to open configuration file %s\n", filename);
		setIberr(EDVR);
		setIbcnt(errno);
		return -1;
	}

	init_gpib_yyparse_private(&priv);
	priv.configs = configs;
	priv.configs_length = configs_length;
	priv.boards = boards;
	priv.boards_length = boards_length;
	priv.device_line_numbers = device_line_nos;
	priv.config_file = filename;
	for (i=0;i < priv.configs_length;i++)	{
		init_ibconf(&priv.configs[i]);
		priv.device_line_numbers[i] = 0;
	}
	for (i=0;i < priv.boards_length;i++)
		init_ibboard(&priv.boards[i]);
	gpib_yylex_init(&priv.yyscanner);
	gpib_yyrestart(infile, priv.yyscanner);
	if (gpib_yyparse(&priv, priv.yyscanner))
		goto gpib_parse_fail;
	gpib_yylex_destroy(priv.yyscanner);
	fclose(infile);

	if (retval == 0) {
		for (i=0;i<priv.config_index;i++) {
			priv.configs[i].settings = priv.configs[i].defaults;
			if (!priv.configs[i].is_interface) {
				if (!strlen(priv.configs[i].name)) {
					fprintf(stderr, "No name for device at line %d\n", device_line_nos[i]);
					goto gpib_parse_fail;
				}
				if (priv.configs[i].defaults.board < 0) {
					fprintf(stderr, "No minor for device \"%s\" at line %d\n", priv.configs[i].name, device_line_nos[i]);
					goto gpib_parse_fail;
				}
				j = find_board_config(&priv, priv.configs[i].defaults.board);
				if (j < 0) {
					fprintf(stderr, "Inconsistent config for device \"%s\": no board with minor %d\n",
						priv.configs[i].name, priv.configs[i].defaults.board);
					goto gpib_parse_fail;
				}
				if (priv.configs[j].defaults.pad < 0) {
					fprintf(stderr, "No pad configured for minor %d\n", priv.configs[j].defaults.board);
					goto gpib_parse_fail;
				}
				if (priv.configs[i].defaults.pad < 0) {
					fprintf(stderr, "No pad configured for device \"%s\" at line %i\n",
						priv.configs[i].name, device_line_nos[i]);
					goto gpib_parse_fail;
				}
				if (priv.configs[i].defaults.pad == priv.configs[j].defaults.pad) {
					fprintf(stderr, "Address conflict in device  \"%s\" at line %i: has same pad (%d) as board minor %d\n",
						 priv.configs[i].name, device_line_nos[i], priv.configs[i].defaults.pad, priv.configs[i].defaults.board);
					goto gpib_parse_fail;
				}
			}
		}

		if (minor >= 0 && find_board_config(&priv,minor) < 0) { // No entry for minor in config file
			// make one so that udev scripts need not depend on config file
			i = priv.config_index;
			priv.configs[i].defaults.board = minor;
			priv.configs[i].is_interface = 1;
			snprintf(priv.boards[minor].device, sizeof(priv.boards[minor].device), "/dev/gpib%i", minor);
			priv.configs[i].settings = priv.configs[i].defaults;
		}
	}
	return retval;

gpib_parse_fail:
	fprintf(stderr, "libgpib: failed to parse configuration file %s\n", filename);
	return -1;
}

static void gpib_conf_warn_missing_equals()
{
	fprintf(stderr, "WARNING: omitting \"=\" before a boolean value in gpib config file is deprecated.\n");
}


#line 239 "./ibConfYacc.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "ibConfYacc.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_INTERFACE = 3,                /* T_INTERFACE  */
  YYSYMBOL_T_DEVICE = 4,                   /* T_DEVICE  */
  YYSYMBOL_T_NAME = 5,                     /* T_NAME  */
  YYSYMBOL_T_MINOR = 6,                    /* T_MINOR  */
  YYSYMBOL_T_BASE = 7,                     /* T_BASE  */
  YYSYMBOL_T_IRQ = 8,                      /* T_IRQ  */
  YYSYMBOL_T_DMA = 9,                      /* T_DMA  */
  YYSYMBOL_T_PAD = 10,                     /* T_PAD  */
  YYSYMBOL_T_SAD = 11,                     /* T_SAD  */
  YYSYMBOL_T_TIMO = 12,                    /* T_TIMO  */
  YYSYMBOL_T_EOSBYTE = 13,                 /* T_EOSBYTE  */
  YYSYMBOL_T_BOARD_TYPE = 14,              /* T_BOARD_TYPE  */
  YYSYMBOL_T_PCI_BUS = 15,                 /* T_PCI_BUS  */
  YYSYMBOL_T_PCI_SLOT = 16,                /* T_PCI_SLOT  */
  YYSYMBOL_T_REOS = 17,                    /* T_REOS  */
  YYSYMBOL_T_BIN = 18,                     /* T_BIN  */
  YYSYMBOL_T_INIT_S = 19,                  /* T_INIT_S  */
  YYSYMBOL_T_DCL = 20,                     /* T_DCL  */
  YYSYMBOL_T_XEOS = 21,                    /* T_XEOS  */
  YYSYMBOL_T_EOT = 22,                     /* T_EOT  */
  YYSYMBOL_T_MASTER = 23,                  /* T_MASTER  */
  YYSYMBOL_T_LLO = 24,                     /* T_LLO  */
  YYSYMBOL_T_EXCL = 25,                    /* T_EXCL  */
  YYSYMBOL_T_INIT_F = 26,                  /* T_INIT_F  */
  YYSYMBOL_T_AUTOPOLL = 27,                /* T_AUTOPOLL  */
  YYSYMBOL_T_SYSFS_DEVICE_PATH = 28,       /* T_SYSFS_DEVICE_PATH  */
  YYSYMBOL_T_SERIAL_NUMBER = 29,           /* T_SERIAL_NUMBER  */
  YYSYMBOL_T_NUMBER = 30,                  /* T_NUMBER  */
  YYSYMBOL_T_STRING = 31,                  /* T_STRING  */
  YYSYMBOL_T_BOOL = 32,                    /* T_BOOL  */
  YYSYMBOL_T_TIVAL = 33,                   /* T_TIVAL  */
  YYSYMBOL_34_ = 34,                       /* '{'  */
  YYSYMBOL_35_ = 35,                       /* '}'  */
  YYSYMBOL_36_ = 36,                       /* '='  */
  YYSYMBOL_37_ = 37,                       /* ','  */
  YYSYMBOL_YYACCEPT = 38,                  /* $accept  */
  YYSYMBOL_input = 39,                     /* input  */
  YYSYMBOL_interface = 40,                 /* interface  */
  YYSYMBOL_minor = 41,                     /* minor  */
  YYSYMBOL_parameter = 42,                 /* parameter  */
  YYSYMBOL_statement = 43,                 /* statement  */
  YYSYMBOL_device = 44,                    /* device  */
  YYSYMBOL_option = 45,                    /* option  */
  YYSYMBOL_assign = 46,                    /* assign  */
  YYSYMBOL_flags = 47,                     /* flags  */
  YYSYMBOL_oneflag = 48                    /* oneflag  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   128

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  38
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  11
/* YYNRULES -- Number of rules.  */
#define YYNRULES  58
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  131

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   288


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    37,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    36,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    34,     2,    35,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   192,   192,   193,   194,   195,   202,   212,   230,   231,
     232,   239,   249,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     283,   288,   293,   300,   311,   312,   313,   322,   332,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   361,   362,   363,   366,   367,   368
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_INTERFACE",
  "T_DEVICE", "T_NAME", "T_MINOR", "T_BASE", "T_IRQ", "T_DMA", "T_PAD",
  "T_SAD", "T_TIMO", "T_EOSBYTE", "T_BOARD_TYPE", "T_PCI_BUS",
  "T_PCI_SLOT", "T_REOS", "T_BIN", "T_INIT_S", "T_DCL", "T_XEOS", "T_EOT",
  "T_MASTER", "T_LLO", "T_EXCL", "T_INIT_F", "T_AUTOPOLL",
  "T_SYSFS_DEVICE_PATH", "T_SERIAL_NUMBER", "T_NUMBER", "T_STRING",
  "T_BOOL", "T_TIVAL", "'{'", "'}'", "'='", "','", "$accept", "input",
  "interface", "minor", "parameter", "statement", "device", "option",
  "assign", "flags", "oneflag", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-60)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-35)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      55,   -60,   -16,   -10,    33,    55,    55,    26,    25,   -60,
     -60,   -60,     3,    -1,   -60,     4,    21,    28,    34,    36,
      37,   -31,   -13,    39,    40,    41,    42,   -60,    44,    25,
      50,   -60,    45,    46,    47,    48,    49,    51,    52,    53,
      54,    56,    57,    -7,     9,    58,    59,    31,    60,    61,
      63,    -1,    30,    69,    70,    71,    32,    72,   -60,    73,
     -60,    74,    43,    75,    76,    29,   -60,   -60,   -60,    78,
      80,    81,    82,    83,    84,    38,    85,    86,    88,    89,
     -60,    90,   -60,    91,    92,    93,   -60,    94,    96,    97,
     -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,
     -60,   -60,   -60,   -60,   -60,   -60,   -60,    29,   -60,    29,
     -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,
     -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,   -60,
     -60
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     5,     0,     0,     0,     0,     0,     0,     0,     1,
       4,     3,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    10,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
      44,     0,     0,     0,     0,    53,    33,    35,     7,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      14,     0,    15,     0,     0,     0,    27,     0,     0,     0,
       6,     9,    49,    50,    37,    38,    52,    51,    40,    42,
      45,    39,    43,    46,    57,    56,    58,    53,    48,    53,
      30,    22,    23,    24,    11,    12,    21,    20,    13,    29,
      25,    26,    16,    18,    17,    19,    28,    31,    32,    54,
      55
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -60,    -3,   -60,   -60,    18,   -60,   -60,    62,   -60,   -59,
     -60
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     4,     5,    13,    50,    51,     6,    28,    29,   108,
     109
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      31,    58,    10,    11,    32,    59,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,     7,    60,
      45,    46,    47,    61,     8,    80,    14,    48,    49,    81,
      15,    16,    12,     9,    -8,    17,    18,    19,    20,    30,
      52,    82,    21,    22,    23,    83,    24,    25,   129,   104,
     130,    26,    27,   105,   106,    -2,     1,    53,     2,     3,
     -34,    92,    96,    86,    54,    97,   107,    87,   116,    91,
      55,   117,    56,    57,   101,    62,    63,    64,    65,    66,
      68,    69,    70,    71,    72,    73,     0,    74,    75,    76,
      77,    67,    78,    79,    84,    85,    88,    89,    90,    93,
      94,    95,    98,     0,     0,    99,   100,   102,   103,   110,
     111,   112,   113,   114,   115,   118,     0,   119,   120,   121,
       0,     0,   122,   123,   124,   125,   126,   127,   128
};

static const yytype_int8 yycheck[] =
{
       1,    32,     5,     6,     5,    36,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    34,    32,
      21,    22,    23,    36,    34,    32,     1,    28,    29,    36,
       5,     6,     6,     0,    35,    10,    11,    12,    13,    36,
      36,    32,    17,    18,    19,    36,    21,    22,   107,    20,
     109,    26,    27,    24,    25,     0,     1,    36,     3,     4,
      35,    31,    30,    32,    36,    33,    37,    36,    30,    51,
      36,    33,    36,    36,    31,    36,    36,    36,    36,    35,
      30,    36,    36,    36,    36,    36,    -1,    36,    36,    36,
      36,    29,    36,    36,    36,    36,    36,    36,    35,    30,
      30,    30,    30,    -1,    -1,    32,    32,    32,    32,    31,
      30,    30,    30,    30,    30,    30,    -1,    31,    30,    30,
      -1,    -1,    32,    32,    32,    32,    32,    31,    31
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     1,     3,     4,    39,    40,    44,    34,    34,     0,
      39,    39,     6,    41,     1,     5,     6,    10,    11,    12,
      13,    17,    18,    19,    21,    22,    26,    27,    45,    46,
      36,     1,     5,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    21,    22,    23,    28,    29,
      42,    43,    36,    36,    36,    36,    36,    36,    32,    36,
      32,    36,    36,    36,    36,    36,    35,    45,    30,    36,
      36,    36,    36,    36,    36,    36,    36,    36,    36,    36,
      32,    36,    32,    36,    36,    36,    32,    36,    36,    36,
      35,    42,    31,    30,    30,    30,    30,    33,    30,    32,
      32,    31,    32,    32,    20,    24,    25,    37,    47,    48,
      31,    30,    30,    30,    30,    30,    30,    33,    30,    31,
      30,    30,    32,    32,    32,    32,    32,    31,    31,    47,
      47
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    38,    39,    39,    39,    39,    40,    41,    42,    42,
      42,    43,    43,    43,    43,    43,    43,    43,    43,    43,
      43,    43,    43,    43,    43,    43,    43,    43,    43,    43,
      43,    43,    43,    44,    45,    45,    45,    46,    46,    46,
      46,    46,    46,    46,    46,    46,    46,    46,    46,    46,
      46,    46,    46,    47,    47,    47,    48,    48,    48
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     1,     5,     3,     0,     2,
       1,     3,     3,     3,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     3,     3,
       3,     3,     3,     4,     0,     2,     1,     3,     3,     3,
       3,     2,     3,     3,     2,     3,     3,     1,     3,     3,
       3,     3,     3,     0,     2,     2,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, parse_arg, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, parse_arg, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, void *parse_arg, void* yyscanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (parse_arg);
  YY_USE (yyscanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, void *parse_arg, void* yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, parse_arg, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, void *parse_arg, void* yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), parse_arg, yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, parse_arg, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, void *parse_arg, void* yyscanner)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (parse_arg);
  YY_USE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *parse_arg, void* yyscanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 5: /* input: error  */
#line 196 "ibConfYacc.y"
                        {
				fprintf(stderr, "input error on line %i of %s\n", gpib_yyget_lineno(priv(parse_arg)->yyscanner), priv(parse_arg)->config_file);
				YYABORT;
			}
#line 1481 "./ibConfYacc.c"
    break;

  case 6: /* interface: T_INTERFACE '{' minor parameter '}'  */
#line 203 "ibConfYacc.y"
                        {
				current_config(parse_arg)->is_interface = 1;
				if (++(priv(parse_arg)->config_index) >= priv(parse_arg)->configs_length) {
					fprintf(stderr, "too many devices in config file\n");
					YYERROR;
				}
			}
#line 1493 "./ibConfYacc.c"
    break;

  case 7: /* minor: T_MINOR '=' T_NUMBER  */
#line 212 "ibConfYacc.y"
                                     {
		                int bi = (yyvsp[0].ival);

				if (bi >= 0 && bi < priv(parse_arg)->boards_length) {
					priv(parse_arg)->board_index = bi;
					if (strlen(current_board(parse_arg)->device) != 0) {
						fprintf(stderr, "Duplicate interface minor %d\n", bi);
						YYERROR;
					}
					current_config(parse_arg)->defaults.board = bi;
					snprintf(current_board(parse_arg)->device, sizeof(current_board(parse_arg)->device), "/dev/gpib%i", bi);
				} else {
					fprintf(stderr, "Invalid minor %d\n", bi);
					YYERROR;
				}
                            }
#line 1514 "./ibConfYacc.c"
    break;

  case 10: /* parameter: error  */
#line 233 "ibConfYacc.y"
                        {
				fprintf(stderr, "parameter error on line %i of %s\n",gpib_yyget_lineno(priv(parse_arg)->yyscanner)-1, priv(parse_arg)->config_file);
				YYABORT;
			}
#line 1523 "./ibConfYacc.c"
    break;

  case 11: /* statement: T_PAD '=' T_NUMBER  */
#line 240 "ibConfYacc.y"
                {
			int pad = (yyvsp[0].ival);

			if (pad < 0 || pad > gpib_addr_max) {
				fprintf(stderr, "Invalid pad %d on line %i in %s\n", pad, gpib_yyget_lineno(priv(parse_arg)->yyscanner),  priv(parse_arg)->config_file);
				YYABORT;
			}
			current_config(parse_arg)->defaults.pad = pad;
		}
#line 1537 "./ibConfYacc.c"
    break;

  case 12: /* statement: T_SAD '=' T_NUMBER  */
#line 250 "ibConfYacc.y"
                {
			int sad = (yyvsp[0].ival);
			if (!sad)
				sad = -1;
			else
				sad -= sad_offset;
			if (sad < -1 || sad > gpib_sad_max) {
				fprintf(stderr,"Invalid sad %d on line %i in %s\n", (yyvsp[0].ival), gpib_yyget_lineno(priv(parse_arg)->yyscanner), priv(parse_arg)->config_file);
				YYABORT;
			}
			current_config(parse_arg)->defaults.sad = sad;
		}
#line 1554 "./ibConfYacc.c"
    break;

  case 13: /* statement: T_EOSBYTE '=' T_NUMBER  */
#line 262 "ibConfYacc.y"
                                          { current_config(parse_arg)->defaults.eos = (yyvsp[0].ival);}
#line 1560 "./ibConfYacc.c"
    break;

  case 14: /* statement: T_REOS T_BOOL  */
#line 263 "ibConfYacc.y"
                                          { gpib_conf_warn_missing_equals(); current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * REOS;}
#line 1566 "./ibConfYacc.c"
    break;

  case 15: /* statement: T_BIN T_BOOL  */
#line 264 "ibConfYacc.y"
                                          { gpib_conf_warn_missing_equals(); current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * BIN;}
#line 1572 "./ibConfYacc.c"
    break;

  case 16: /* statement: T_REOS '=' T_BOOL  */
#line 265 "ibConfYacc.y"
                                              { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * REOS;}
#line 1578 "./ibConfYacc.c"
    break;

  case 17: /* statement: T_XEOS '=' T_BOOL  */
#line 266 "ibConfYacc.y"
                                              { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * XEOS;}
#line 1584 "./ibConfYacc.c"
    break;

  case 18: /* statement: T_BIN '=' T_BOOL  */
#line 267 "ibConfYacc.y"
                                             { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * BIN;}
#line 1590 "./ibConfYacc.c"
    break;

  case 19: /* statement: T_EOT '=' T_BOOL  */
#line 268 "ibConfYacc.y"
                                             { current_config(parse_arg)->defaults.send_eoi = (yyvsp[0].bval);}
#line 1596 "./ibConfYacc.c"
    break;

  case 20: /* statement: T_TIMO '=' T_TIVAL  */
#line 269 "ibConfYacc.y"
                                          { current_config(parse_arg)->defaults.usec_timeout = (yyvsp[0].ival); }
#line 1602 "./ibConfYacc.c"
    break;

  case 21: /* statement: T_TIMO '=' T_NUMBER  */
#line 270 "ibConfYacc.y"
                                           { current_config(parse_arg)->defaults.usec_timeout = timeout_to_usec((yyvsp[0].ival)); }
#line 1608 "./ibConfYacc.c"
    break;

  case 22: /* statement: T_BASE '=' T_NUMBER  */
#line 271 "ibConfYacc.y"
                                          { current_board(parse_arg)->base = (yyvsp[0].ival); }
#line 1614 "./ibConfYacc.c"
    break;

  case 23: /* statement: T_IRQ '=' T_NUMBER  */
#line 272 "ibConfYacc.y"
                                          { current_board(parse_arg)->irq = (yyvsp[0].ival); }
#line 1620 "./ibConfYacc.c"
    break;

  case 24: /* statement: T_DMA '=' T_NUMBER  */
#line 273 "ibConfYacc.y"
                                          { current_board(parse_arg)->dma = (yyvsp[0].ival); }
#line 1626 "./ibConfYacc.c"
    break;

  case 25: /* statement: T_PCI_BUS '=' T_NUMBER  */
#line 274 "ibConfYacc.y"
                                              { current_board(parse_arg)->pci_bus = (yyvsp[0].ival); }
#line 1632 "./ibConfYacc.c"
    break;

  case 26: /* statement: T_PCI_SLOT '=' T_NUMBER  */
#line 275 "ibConfYacc.y"
                                               { current_board(parse_arg)->pci_slot = (yyvsp[0].ival); }
#line 1638 "./ibConfYacc.c"
    break;

  case 27: /* statement: T_MASTER T_BOOL  */
#line 276 "ibConfYacc.y"
                                        { gpib_conf_warn_missing_equals(); current_board(parse_arg)->is_system_controller = (yyvsp[0].bval); }
#line 1644 "./ibConfYacc.c"
    break;

  case 28: /* statement: T_MASTER '=' T_BOOL  */
#line 277 "ibConfYacc.y"
                                        { current_board(parse_arg)->is_system_controller = (yyvsp[0].bval); }
#line 1650 "./ibConfYacc.c"
    break;

  case 29: /* statement: T_BOARD_TYPE '=' T_STRING  */
#line 279 "ibConfYacc.y"
                        {
				strncpy(current_board(parse_arg)->board_type, (yyvsp[0].sval),
					sizeof(current_board(parse_arg)->board_type)-1);
			}
#line 1659 "./ibConfYacc.c"
    break;

  case 30: /* statement: T_NAME '=' T_STRING  */
#line 284 "ibConfYacc.y"
                        {
				strncpy(current_config(parse_arg)->name, (yyvsp[0].sval),
					sizeof(current_config(parse_arg)->name)-1);
			}
#line 1668 "./ibConfYacc.c"
    break;

  case 31: /* statement: T_SYSFS_DEVICE_PATH '=' T_STRING  */
#line 289 "ibConfYacc.y"
                        {
				strncpy(current_board(parse_arg)->sysfs_device_path, (yyvsp[0].sval),
					sizeof(current_board(parse_arg)->sysfs_device_path)-1);
			}
#line 1677 "./ibConfYacc.c"
    break;

  case 32: /* statement: T_SERIAL_NUMBER '=' T_STRING  */
#line 294 "ibConfYacc.y"
                        {
				strncpy(current_board(parse_arg)->serial_number, (yyvsp[0].sval),
					sizeof(current_board(parse_arg)->serial_number-1));
			}
#line 1686 "./ibConfYacc.c"
    break;

  case 33: /* device: T_DEVICE '{' option '}'  */
#line 301 "ibConfYacc.y"
                        {
				current_config(parse_arg)->is_interface = 0;
				priv(parse_arg)->device_line_numbers[priv(parse_arg)->config_index] = gpib_yyget_lineno(priv(parse_arg)->yyscanner);
				if (++(priv(parse_arg)->config_index) >= priv(parse_arg)->configs_length) {
					fprintf(stderr, "too many devices in config file\n");
					YYERROR;
				}
			}
#line 1699 "./ibConfYacc.c"
    break;

  case 36: /* option: error  */
#line 314 "ibConfYacc.y"
                        {
				int mline =  gpib_yyget_lineno(priv(parse_arg)->yyscanner);
				fprintf(stderr, "option error on line %i of config file\n", mline);
				YYABORT;
			}
#line 1709 "./ibConfYacc.c"
    break;

  case 37: /* assign: T_PAD '=' T_NUMBER  */
#line 323 "ibConfYacc.y"
                {
			int pad = (yyvsp[0].ival);

			if (pad < 0 || pad > gpib_addr_max) {
				fprintf(stderr, "Invalid pad  %d on line %i in %s\n", pad, gpib_yyget_lineno(priv(parse_arg)->yyscanner), priv(parse_arg)->config_file);
				YYABORT;
			}
			current_config(parse_arg)->defaults.pad = pad;
		}
#line 1723 "./ibConfYacc.c"
    break;

  case 38: /* assign: T_SAD '=' T_NUMBER  */
#line 333 "ibConfYacc.y"
                {
			int sad = (yyvsp[0].ival);
			if (!sad)
				sad = -1;
			else
				sad -= sad_offset;
			if (sad < -1 || sad > gpib_sad_max) {
				fprintf(stderr, "Invalid sad %d on line %i in %s\n", (yyvsp[0].ival), gpib_yyget_lineno(priv(parse_arg)->yyscanner), priv(parse_arg)->config_file);
				YYABORT;
			}
			current_config(parse_arg)->defaults.sad = sad;
		}
#line 1740 "./ibConfYacc.c"
    break;

  case 39: /* assign: T_INIT_S '=' T_STRING  */
#line 345 "ibConfYacc.y"
                                        { strncpy(current_config(parse_arg)->init_string,(yyvsp[0].sval),60); }
#line 1746 "./ibConfYacc.c"
    break;

  case 40: /* assign: T_EOSBYTE '=' T_NUMBER  */
#line 346 "ibConfYacc.y"
                                          { current_config(parse_arg)->defaults.eos = (yyvsp[0].ival); }
#line 1752 "./ibConfYacc.c"
    break;

  case 41: /* assign: T_REOS T_BOOL  */
#line 347 "ibConfYacc.y"
                                          { gpib_conf_warn_missing_equals(); current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * REOS;}
#line 1758 "./ibConfYacc.c"
    break;

  case 42: /* assign: T_REOS '=' T_BOOL  */
#line 348 "ibConfYacc.y"
                                              { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * REOS;}
#line 1764 "./ibConfYacc.c"
    break;

  case 43: /* assign: T_XEOS '=' T_BOOL  */
#line 349 "ibConfYacc.y"
                                              { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * XEOS;}
#line 1770 "./ibConfYacc.c"
    break;

  case 44: /* assign: T_BIN T_BOOL  */
#line 350 "ibConfYacc.y"
                                         { gpib_conf_warn_missing_equals(); current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * BIN; }
#line 1776 "./ibConfYacc.c"
    break;

  case 45: /* assign: T_BIN '=' T_BOOL  */
#line 351 "ibConfYacc.y"
                                             { current_config(parse_arg)->defaults.eos_flags |= (yyvsp[0].bval) * BIN; }
#line 1782 "./ibConfYacc.c"
    break;

  case 46: /* assign: T_EOT '=' T_BOOL  */
#line 352 "ibConfYacc.y"
                                             { current_config(parse_arg)->defaults.send_eoi = (yyvsp[0].bval);}
#line 1788 "./ibConfYacc.c"
    break;

  case 47: /* assign: T_AUTOPOLL  */
#line 353 "ibConfYacc.y"
                                          { current_config(parse_arg)->flags |= CN_AUTOPOLL; }
#line 1794 "./ibConfYacc.c"
    break;

  case 49: /* assign: T_NAME '=' T_STRING  */
#line 355 "ibConfYacc.y"
                                        { strncpy(current_config(parse_arg)->name,(yyvsp[0].sval), sizeof(current_config(parse_arg)->name));}
#line 1800 "./ibConfYacc.c"
    break;

  case 50: /* assign: T_MINOR '=' T_NUMBER  */
#line 356 "ibConfYacc.y"
                                        { current_config(parse_arg)->defaults.board = (yyvsp[0].ival);}
#line 1806 "./ibConfYacc.c"
    break;

  case 51: /* assign: T_TIMO '=' T_TIVAL  */
#line 357 "ibConfYacc.y"
                                          { current_config(parse_arg)->defaults.usec_timeout = (yyvsp[0].ival); }
#line 1812 "./ibConfYacc.c"
    break;

  case 52: /* assign: T_TIMO '=' T_NUMBER  */
#line 358 "ibConfYacc.y"
                                           { current_config(parse_arg)->defaults.usec_timeout = timeout_to_usec((yyvsp[0].ival)); }
#line 1818 "./ibConfYacc.c"
    break;

  case 56: /* oneflag: T_LLO  */
#line 366 "ibConfYacc.y"
                             { current_config(parse_arg)->flags |= CN_SLLO; }
#line 1824 "./ibConfYacc.c"
    break;

  case 57: /* oneflag: T_DCL  */
#line 367 "ibConfYacc.y"
                              { current_config(parse_arg)->flags |= CN_SDCL; }
#line 1830 "./ibConfYacc.c"
    break;

  case 58: /* oneflag: T_EXCL  */
#line 368 "ibConfYacc.y"
                              { current_config(parse_arg)->flags |= CN_EXCLUSIVE; }
#line 1836 "./ibConfYacc.c"
    break;


#line 1840 "./ibConfYacc.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (&yylloc, parse_arg, yyscanner, YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, parse_arg, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, parse_arg, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, parse_arg, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, parse_arg, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, parse_arg, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 371 "ibConfYacc.y"


