/*
** $Id: xttitle.c,v 1.2 1999/09/27 22:12:28 michaelj Exp $
** xttitle 1.0
**
** Copyright (c) Michael A. Jarvis <michael@jarvis.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**************************************************************************
** Sets the title and icon name of an xterm window.
**
** I use this in my 'cd' alias to set the title of the window to
** reflect the username, hostname, and current working directory.
**
** If you're using csh/tcsh under Linux:
**    setenv user=`whoami`
**    setenv hostname=`uname -n`
**    alias cd 'chdir \!*;icon $user@$hostname\:$cwd $hostname'
**
*/
#include <stdio.h>
#include <stdlib.h>

#define PRINT_STRING "\033]2;%s\007\033\\\033[1A\n\033]1;%s\007\033\\\033[1A\n\033]21;%s\033\\\033[1A\n\033]2L;%s\033\\\033[1A\n"

int main( int argc, char **argv )
{
	char		*title	= NULL;	/* Used to set the title of the window */
	char 		*icon	= NULL;	/* Used to set the icon name for Openwindows */

	switch ( argc ) {
	case 1:
		printf("Usage:  %s <window title> [ <icon title> ]\n", argv[0] );
		exit(0);
		break;		/*  Never reached */

	case 2:
		/*  If there was just one parameter, set icon to same as title.   */
		title = argv[1];
		icon  = argv[1];
		break;

	case 3:
		/*  They passed both window title AND icon name */
		title = argv[1];
		icon  = argv[2];
		break;

	default:
		printf("Usage:  %s <window title> [ <icon title> ]\n", argv[0] );
		exit(0);
		break;		/*  Never reached */
	}

	printf( PRINT_STRING, title, icon, title, icon );

	exit(0);
}
