# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Command(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Invoked command."""

    TRACEROUTE = "Traceroute"
    PING = "Ping"
    BGP_ROUTE = "BgpRoute"


class ConnectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the connection."""

    NONE = "None"
    PENDING_APPROVAL = "PendingApproval"
    APPROVED = "Approved"
    PROVISIONING_STARTED = "ProvisioningStarted"
    PROVISIONING_FAILED = "ProvisioningFailed"
    PROVISIONING_COMPLETED = "ProvisioningCompleted"
    VALIDATING = "Validating"
    ACTIVE = "Active"
    TYPE_CHANGE_REQUESTED = "TypeChangeRequested"
    TYPE_CHANGE_IN_PROGRESS = "TypeChangeInProgress"


class DirectPeeringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of direct peering."""

    EDGE = "Edge"
    TRANSIT = "Transit"
    CDN = "Cdn"
    INTERNAL = "Internal"
    IX = "Ix"
    IX_RS = "IxRs"
    VOICE = "Voice"
    EDGE_ZONE_FOR_OPERATORS = "EdgeZoneForOperators"


class Enum0(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum0."""

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"


class Family(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The family of the peering SKU."""

    DIRECT = "Direct"
    EXCHANGE = "Exchange"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the peering."""

    DIRECT = "Direct"
    EXCHANGE = "Exchange"


class LearnedType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The prefix learned type."""

    NONE = "None"
    VIA_SERVICE_PROVIDER = "ViaServiceProvider"
    VIA_SESSION = "ViaSession"


class LegacyPeeringsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LegacyPeeringsKind."""

    DIRECT = "Direct"
    EXCHANGE = "Exchange"


class LookingGlassCommand(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LookingGlassCommand."""

    TRACEROUTE = "Traceroute"
    PING = "Ping"
    BGP_ROUTE = "BgpRoute"


class LookingGlassSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LookingGlassSourceType."""

    EDGE_SITE = "EdgeSite"
    AZURE_REGION = "AzureRegion"


class PeeringLocationsDirectPeeringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PeeringLocationsDirectPeeringType."""

    EDGE = "Edge"
    TRANSIT = "Transit"
    CDN = "Cdn"
    INTERNAL = "Internal"
    IX = "Ix"
    IX_RS = "IxRs"
    VOICE = "Voice"
    EDGE_ZONE_FOR_OPERATORS = "EdgeZoneForOperators"


class PeeringLocationsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PeeringLocationsKind."""

    DIRECT = "Direct"
    EXCHANGE = "Exchange"


class PrefixValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The prefix validation state."""

    NONE = "None"
    INVALID = "Invalid"
    VERIFIED = "Verified"
    FAILED = "Failed"
    PENDING = "Pending"
    WARNING = "Warning"
    UNKNOWN = "Unknown"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    DELETING = "Deleting"
    FAILED = "Failed"


class Role(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role of the contact."""

    NOC = "Noc"
    POLICY = "Policy"
    TECHNICAL = "Technical"
    SERVICE = "Service"
    ESCALATION = "Escalation"
    OTHER = "Other"


class SessionAddressProvider(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The field indicating if Microsoft provides session ip addresses."""

    MICROSOFT = "Microsoft"
    PEER = "Peer"


class SessionStateV4(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the IPv4 session."""

    NONE = "None"
    IDLE = "Idle"
    CONNECT = "Connect"
    ACTIVE = "Active"
    OPEN_SENT = "OpenSent"
    OPEN_CONFIRM = "OpenConfirm"
    OPEN_RECEIVED = "OpenReceived"
    ESTABLISHED = "Established"
    PENDING_ADD = "PendingAdd"
    PENDING_UPDATE = "PendingUpdate"
    PENDING_REMOVE = "PendingRemove"


class SessionStateV6(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the IPv6 session."""

    NONE = "None"
    IDLE = "Idle"
    CONNECT = "Connect"
    ACTIVE = "Active"
    OPEN_SENT = "OpenSent"
    OPEN_CONFIRM = "OpenConfirm"
    OPEN_RECEIVED = "OpenReceived"
    ESTABLISHED = "Established"
    PENDING_ADD = "PendingAdd"
    PENDING_UPDATE = "PendingUpdate"
    PENDING_REMOVE = "PendingRemove"


class Size(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The size of the peering SKU."""

    FREE = "Free"
    METERED = "Metered"
    UNLIMITED = "Unlimited"


class Tier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The tier of the peering SKU."""

    BASIC = "Basic"
    PREMIUM = "Premium"


class ValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The validation state of the ASN associated with the peer."""

    NONE = "None"
    PENDING = "Pending"
    APPROVED = "Approved"
    FAILED = "Failed"
