# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from azure.core.exceptions import HttpResponseError


class AccessPolicy(Model):
    """An Access policy.

    :param start: the date-time the policy is active
    :type start: str
    :param expiry: the date-time the policy expires
    :type expiry: str
    :param permission: the permissions for the acl policy
    :type permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str', 'xml': {'name': 'Start'}},
        'expiry': {'key': 'Expiry', 'type': 'str', 'xml': {'name': 'Expiry'}},
        'permission': {'key': 'Permission', 'type': 'str', 'xml': {'name': 'Permission'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class AppendPositionAccessConditions(Model):
    """Additional parameters for a set of operations, such as:
    AppendBlob_append_block, AppendBlob_append_block_from_url, AppendBlob_seal.

    :param max_size: Optional conditional header. The max length in bytes
     permitted for the append blob. If the Append Block operation would cause
     the blob to exceed that limit or if the blob size is already greater than
     the value specified in this header, the request will fail with
     MaxBlobSizeConditionNotMet error (HTTP status code 412 - Precondition
     Failed).
    :type max_size: long
    :param append_position: Optional conditional header, used only for the
     Append Block operation. A number indicating the byte offset to compare.
     Append Block will succeed only if the append position is equal to this
     number. If it is not, the request will fail with the
     AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     Failed).
    :type append_position: long
    """

    _attribute_map = {
        'max_size': {'key': '', 'type': 'long', 'xml': {'name': 'max_size'}},
        'append_position': {'key': '', 'type': 'long', 'xml': {'name': 'append_position'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(AppendPositionAccessConditions, self).__init__(**kwargs)
        self.max_size = kwargs.get('max_size', None)
        self.append_position = kwargs.get('append_position', None)


class ArrowConfiguration(Model):
    """arrow configuration.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required.
    :type schema: list[~azure.storage.blob.models.ArrowField]
    """

    _validation = {
        'schema': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': 'Schema', 'type': '[ArrowField]', 'xml': {'name': 'Schema', 'itemsName': 'Schema', 'wrapped': True}},
    }
    _xml_map = {
        'name': 'ArrowConfiguration'
    }

    def __init__(self, **kwargs):
        super(ArrowConfiguration, self).__init__(**kwargs)
        self.schema = kwargs.get('schema', None)


class ArrowField(Model):
    """field of an arrow schema.

    All required parameters must be populated in order to send to Azure.

    :param type: Required.
    :type type: str
    :param name:
    :type name: str
    :param precision:
    :type precision: int
    :param scale:
    :type scale: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str', 'xml': {'name': 'Type'}},
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'precision': {'key': 'Precision', 'type': 'int', 'xml': {'name': 'Precision'}},
        'scale': {'key': 'Scale', 'type': 'int', 'xml': {'name': 'Scale'}},
    }
    _xml_map = {
        'name': 'Field'
    }

    def __init__(self, **kwargs):
        super(ArrowField, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.precision = kwargs.get('precision', None)
        self.scale = kwargs.get('scale', None)


class BlobFlatListSegment(Model):
    """BlobFlatListSegment.

    All required parameters must be populated in order to send to Azure.

    :param blob_items: Required.
    :type blob_items: list[~azure.storage.blob.models.BlobItemInternal]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItemInternal]', 'xml': {'name': 'BlobItems', 'itemsName': 'Blob'}},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(self, **kwargs):
        super(BlobFlatListSegment, self).__init__(**kwargs)
        self.blob_items = kwargs.get('blob_items', None)


class BlobHierarchyListSegment(Model):
    """BlobHierarchyListSegment.

    All required parameters must be populated in order to send to Azure.

    :param blob_prefixes:
    :type blob_prefixes: list[~azure.storage.blob.models.BlobPrefix]
    :param blob_items: Required.
    :type blob_items: list[~azure.storage.blob.models.BlobItemInternal]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_prefixes': {'key': 'BlobPrefixes', 'type': '[BlobPrefix]', 'xml': {'name': 'BlobPrefix', 'itemsName': 'BlobPrefix'}},
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItemInternal]', 'xml': {'name': 'Blob', 'itemsName': 'Blob'}},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(self, **kwargs):
        super(BlobHierarchyListSegment, self).__init__(**kwargs)
        self.blob_prefixes = kwargs.get('blob_prefixes', None)
        self.blob_items = kwargs.get('blob_items', None)


class BlobHTTPHeaders(Model):
    """Additional parameters for a set of operations.

    :param blob_cache_control: Optional. Sets the blob's cache control. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type blob_cache_control: str
    :param blob_content_type: Optional. Sets the blob's content type. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type blob_content_type: str
    :param blob_content_md5: Optional. An MD5 hash of the blob content. Note
     that this hash is not validated, as the hashes for the individual blocks
     were validated when each was uploaded.
    :type blob_content_md5: bytearray
    :param blob_content_encoding: Optional. Sets the blob's content encoding.
     If specified, this property is stored with the blob and returned with a
     read request.
    :type blob_content_encoding: str
    :param blob_content_language: Optional. Set the blob's content language.
     If specified, this property is stored with the blob and returned with a
     read request.
    :type blob_content_language: str
    :param blob_content_disposition: Optional. Sets the blob's
     Content-Disposition header.
    :type blob_content_disposition: str
    """

    _attribute_map = {
        'blob_cache_control': {'key': '', 'type': 'str', 'xml': {'name': 'blob_cache_control'}},
        'blob_content_type': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_type'}},
        'blob_content_md5': {'key': '', 'type': 'bytearray', 'xml': {'name': 'blob_content_md5'}},
        'blob_content_encoding': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_encoding'}},
        'blob_content_language': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_language'}},
        'blob_content_disposition': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_disposition'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(BlobHTTPHeaders, self).__init__(**kwargs)
        self.blob_cache_control = kwargs.get('blob_cache_control', None)
        self.blob_content_type = kwargs.get('blob_content_type', None)
        self.blob_content_md5 = kwargs.get('blob_content_md5', None)
        self.blob_content_encoding = kwargs.get('blob_content_encoding', None)
        self.blob_content_language = kwargs.get('blob_content_language', None)
        self.blob_content_disposition = kwargs.get('blob_content_disposition', None)


class BlobItemInternal(Model):
    """An Azure Storage blob.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param deleted: Required.
    :type deleted: bool
    :param snapshot: Required.
    :type snapshot: str
    :param version_id:
    :type version_id: str
    :param is_current_version:
    :type is_current_version: bool
    :param properties: Required.
    :type properties: ~azure.storage.blob.models.BlobPropertiesInternal
    :param metadata:
    :type metadata: ~azure.storage.blob.models.BlobMetadata
    :param blob_tags:
    :type blob_tags: ~azure.storage.blob.models.BlobTags
    :param object_replication_metadata:
    :type object_replication_metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'deleted': {'required': True},
        'snapshot': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'deleted': {'key': 'Deleted', 'type': 'bool', 'xml': {'name': 'Deleted'}},
        'snapshot': {'key': 'Snapshot', 'type': 'str', 'xml': {'name': 'Snapshot'}},
        'version_id': {'key': 'VersionId', 'type': 'str', 'xml': {'name': 'VersionId'}},
        'is_current_version': {'key': 'IsCurrentVersion', 'type': 'bool', 'xml': {'name': 'IsCurrentVersion'}},
        'properties': {'key': 'Properties', 'type': 'BlobPropertiesInternal', 'xml': {'name': 'Properties'}},
        'metadata': {'key': 'Metadata', 'type': 'BlobMetadata', 'xml': {'name': 'Metadata'}},
        'blob_tags': {'key': 'BlobTags', 'type': 'BlobTags', 'xml': {'name': 'BlobTags'}},
        'object_replication_metadata': {'key': 'OrMetadata', 'type': '{str}', 'xml': {'name': 'OrMetadata'}},
    }
    _xml_map = {
        'name': 'Blob'
    }

    def __init__(self, **kwargs):
        super(BlobItemInternal, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.deleted = kwargs.get('deleted', None)
        self.snapshot = kwargs.get('snapshot', None)
        self.version_id = kwargs.get('version_id', None)
        self.is_current_version = kwargs.get('is_current_version', None)
        self.properties = kwargs.get('properties', None)
        self.metadata = kwargs.get('metadata', None)
        self.blob_tags = kwargs.get('blob_tags', None)
        self.object_replication_metadata = kwargs.get('object_replication_metadata', None)


class BlobMetadata(Model):
    """BlobMetadata.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, str]
    :param encrypted:
    :type encrypted: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{str}', 'xml': {'name': 'additional_properties'}},
        'encrypted': {'key': 'Encrypted', 'type': 'str', 'xml': {'name': 'Encrypted', 'attr': True}},
    }
    _xml_map = {
        'name': 'Metadata'
    }

    def __init__(self, **kwargs):
        super(BlobMetadata, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.encrypted = kwargs.get('encrypted', None)


class BlobPrefix(Model):
    """BlobPrefix.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(BlobPrefix, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class BlobPropertiesInternal(Model):
    """Properties of a blob.

    All required parameters must be populated in order to send to Azure.

    :param creation_time:
    :type creation_time: datetime
    :param last_modified: Required.
    :type last_modified: datetime
    :param etag: Required.
    :type etag: str
    :param content_length: Size in bytes
    :type content_length: long
    :param content_type:
    :type content_type: str
    :param content_encoding:
    :type content_encoding: str
    :param content_language:
    :type content_language: str
    :param content_md5:
    :type content_md5: bytearray
    :param content_disposition:
    :type content_disposition: str
    :param cache_control:
    :type cache_control: str
    :param blob_sequence_number:
    :type blob_sequence_number: long
    :param blob_type: Possible values include: 'BlockBlob', 'PageBlob',
     'AppendBlob'
    :type blob_type: str or ~azure.storage.blob.models.BlobType
    :param lease_status: Possible values include: 'locked', 'unlocked'
    :type lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :param lease_state: Possible values include: 'available', 'leased',
     'expired', 'breaking', 'broken'
    :type lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :param lease_duration: Possible values include: 'infinite', 'fixed'
    :type lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :param copy_id:
    :type copy_id: str
    :param copy_status: Possible values include: 'pending', 'success',
     'aborted', 'failed'
    :type copy_status: str or ~azure.storage.blob.models.CopyStatusType
    :param copy_source:
    :type copy_source: str
    :param copy_progress:
    :type copy_progress: str
    :param copy_completion_time:
    :type copy_completion_time: datetime
    :param copy_status_description:
    :type copy_status_description: str
    :param server_encrypted:
    :type server_encrypted: bool
    :param incremental_copy:
    :type incremental_copy: bool
    :param destination_snapshot:
    :type destination_snapshot: str
    :param deleted_time:
    :type deleted_time: datetime
    :param remaining_retention_days:
    :type remaining_retention_days: int
    :param access_tier: Possible values include: 'P4', 'P6', 'P10', 'P15',
     'P20', 'P30', 'P40', 'P50', 'P60', 'P70', 'P80', 'Hot', 'Cool', 'Archive'
    :type access_tier: str or ~azure.storage.blob.models.AccessTier
    :param access_tier_inferred:
    :type access_tier_inferred: bool
    :param archive_status: Possible values include:
     'rehydrate-pending-to-hot', 'rehydrate-pending-to-cool'
    :type archive_status: str or ~azure.storage.blob.models.ArchiveStatus
    :param customer_provided_key_sha256:
    :type customer_provided_key_sha256: str
    :param encryption_scope: The name of the encryption scope under which the
     blob is encrypted.
    :type encryption_scope: str
    :param access_tier_change_time:
    :type access_tier_change_time: datetime
    :param tag_count:
    :type tag_count: int
    :param expires_on:
    :type expires_on: datetime
    :param is_sealed:
    :type is_sealed: bool
    :param rehydrate_priority: Possible values include: 'High', 'Standard'
    :type rehydrate_priority: str or
     ~azure.storage.blob.models.RehydratePriority
    :param last_accessed_on:
    :type last_accessed_on: datetime
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'Creation-Time', 'type': 'rfc-1123', 'xml': {'name': 'Creation-Time'}},
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123', 'xml': {'name': 'Last-Modified'}},
        'etag': {'key': 'Etag', 'type': 'str', 'xml': {'name': 'Etag'}},
        'content_length': {'key': 'Content-Length', 'type': 'long', 'xml': {'name': 'Content-Length'}},
        'content_type': {'key': 'Content-Type', 'type': 'str', 'xml': {'name': 'Content-Type'}},
        'content_encoding': {'key': 'Content-Encoding', 'type': 'str', 'xml': {'name': 'Content-Encoding'}},
        'content_language': {'key': 'Content-Language', 'type': 'str', 'xml': {'name': 'Content-Language'}},
        'content_md5': {'key': 'Content-MD5', 'type': 'bytearray', 'xml': {'name': 'Content-MD5'}},
        'content_disposition': {'key': 'Content-Disposition', 'type': 'str', 'xml': {'name': 'Content-Disposition'}},
        'cache_control': {'key': 'Cache-Control', 'type': 'str', 'xml': {'name': 'Cache-Control'}},
        'blob_sequence_number': {'key': 'x-ms-blob-sequence-number', 'type': 'long', 'xml': {'name': 'x-ms-blob-sequence-number'}},
        'blob_type': {'key': 'BlobType', 'type': 'BlobType', 'xml': {'name': 'BlobType'}},
        'lease_status': {'key': 'LeaseStatus', 'type': 'LeaseStatusType', 'xml': {'name': 'LeaseStatus'}},
        'lease_state': {'key': 'LeaseState', 'type': 'LeaseStateType', 'xml': {'name': 'LeaseState'}},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'LeaseDurationType', 'xml': {'name': 'LeaseDuration'}},
        'copy_id': {'key': 'CopyId', 'type': 'str', 'xml': {'name': 'CopyId'}},
        'copy_status': {'key': 'CopyStatus', 'type': 'CopyStatusType', 'xml': {'name': 'CopyStatus'}},
        'copy_source': {'key': 'CopySource', 'type': 'str', 'xml': {'name': 'CopySource'}},
        'copy_progress': {'key': 'CopyProgress', 'type': 'str', 'xml': {'name': 'CopyProgress'}},
        'copy_completion_time': {'key': 'CopyCompletionTime', 'type': 'rfc-1123', 'xml': {'name': 'CopyCompletionTime'}},
        'copy_status_description': {'key': 'CopyStatusDescription', 'type': 'str', 'xml': {'name': 'CopyStatusDescription'}},
        'server_encrypted': {'key': 'ServerEncrypted', 'type': 'bool', 'xml': {'name': 'ServerEncrypted'}},
        'incremental_copy': {'key': 'IncrementalCopy', 'type': 'bool', 'xml': {'name': 'IncrementalCopy'}},
        'destination_snapshot': {'key': 'DestinationSnapshot', 'type': 'str', 'xml': {'name': 'DestinationSnapshot'}},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123', 'xml': {'name': 'DeletedTime'}},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int', 'xml': {'name': 'RemainingRetentionDays'}},
        'access_tier': {'key': 'AccessTier', 'type': 'str', 'xml': {'name': 'AccessTier'}},
        'access_tier_inferred': {'key': 'AccessTierInferred', 'type': 'bool', 'xml': {'name': 'AccessTierInferred'}},
        'archive_status': {'key': 'ArchiveStatus', 'type': 'str', 'xml': {'name': 'ArchiveStatus'}},
        'customer_provided_key_sha256': {'key': 'CustomerProvidedKeySha256', 'type': 'str', 'xml': {'name': 'CustomerProvidedKeySha256'}},
        'encryption_scope': {'key': 'EncryptionScope', 'type': 'str', 'xml': {'name': 'EncryptionScope'}},
        'access_tier_change_time': {'key': 'AccessTierChangeTime', 'type': 'rfc-1123', 'xml': {'name': 'AccessTierChangeTime'}},
        'tag_count': {'key': 'TagCount', 'type': 'int', 'xml': {'name': 'TagCount'}},
        'expires_on': {'key': 'Expiry-Time', 'type': 'rfc-1123', 'xml': {'name': 'Expiry-Time'}},
        'is_sealed': {'key': 'Sealed', 'type': 'bool', 'xml': {'name': 'Sealed'}},
        'rehydrate_priority': {'key': 'RehydratePriority', 'type': 'str', 'xml': {'name': 'RehydratePriority'}},
        'last_accessed_on': {'key': 'LastAccessTime', 'type': 'rfc-1123', 'xml': {'name': 'LastAccessTime'}},
    }
    _xml_map = {
        'name': 'Properties'
    }

    def __init__(self, **kwargs):
        super(BlobPropertiesInternal, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.etag = kwargs.get('etag', None)
        self.content_length = kwargs.get('content_length', None)
        self.content_type = kwargs.get('content_type', None)
        self.content_encoding = kwargs.get('content_encoding', None)
        self.content_language = kwargs.get('content_language', None)
        self.content_md5 = kwargs.get('content_md5', None)
        self.content_disposition = kwargs.get('content_disposition', None)
        self.cache_control = kwargs.get('cache_control', None)
        self.blob_sequence_number = kwargs.get('blob_sequence_number', None)
        self.blob_type = kwargs.get('blob_type', None)
        self.lease_status = kwargs.get('lease_status', None)
        self.lease_state = kwargs.get('lease_state', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.copy_id = kwargs.get('copy_id', None)
        self.copy_status = kwargs.get('copy_status', None)
        self.copy_source = kwargs.get('copy_source', None)
        self.copy_progress = kwargs.get('copy_progress', None)
        self.copy_completion_time = kwargs.get('copy_completion_time', None)
        self.copy_status_description = kwargs.get('copy_status_description', None)
        self.server_encrypted = kwargs.get('server_encrypted', None)
        self.incremental_copy = kwargs.get('incremental_copy', None)
        self.destination_snapshot = kwargs.get('destination_snapshot', None)
        self.deleted_time = kwargs.get('deleted_time', None)
        self.remaining_retention_days = kwargs.get('remaining_retention_days', None)
        self.access_tier = kwargs.get('access_tier', None)
        self.access_tier_inferred = kwargs.get('access_tier_inferred', None)
        self.archive_status = kwargs.get('archive_status', None)
        self.customer_provided_key_sha256 = kwargs.get('customer_provided_key_sha256', None)
        self.encryption_scope = kwargs.get('encryption_scope', None)
        self.access_tier_change_time = kwargs.get('access_tier_change_time', None)
        self.tag_count = kwargs.get('tag_count', None)
        self.expires_on = kwargs.get('expires_on', None)
        self.is_sealed = kwargs.get('is_sealed', None)
        self.rehydrate_priority = kwargs.get('rehydrate_priority', None)
        self.last_accessed_on = kwargs.get('last_accessed_on', None)


class BlobTag(Model):
    """BlobTag.

    All required parameters must be populated in order to send to Azure.

    :param key: Required.
    :type key: str
    :param value: Required.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str', 'xml': {'name': 'Key'}},
        'value': {'key': 'Value', 'type': 'str', 'xml': {'name': 'Value'}},
    }
    _xml_map = {
        'name': 'Tag'
    }

    def __init__(self, **kwargs):
        super(BlobTag, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class BlobTags(Model):
    """Blob tags.

    All required parameters must be populated in order to send to Azure.

    :param blob_tag_set: Required.
    :type blob_tag_set: list[~azure.storage.blob.models.BlobTag]
    """

    _validation = {
        'blob_tag_set': {'required': True},
    }

    _attribute_map = {
        'blob_tag_set': {'key': 'BlobTagSet', 'type': '[BlobTag]', 'xml': {'name': 'TagSet', 'itemsName': 'TagSet', 'wrapped': True}},
    }
    _xml_map = {
        'name': 'Tags'
    }

    def __init__(self, **kwargs):
        super(BlobTags, self).__init__(**kwargs)
        self.blob_tag_set = kwargs.get('blob_tag_set', None)


class Block(Model):
    """Represents a single block in a block blob.  It describes the block's ID and
    size.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The base64 encoded block ID.
    :type name: str
    :param size: Required. The block size in bytes.
    :type size: int
    """

    _validation = {
        'name': {'required': True},
        'size': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'size': {'key': 'Size', 'type': 'int', 'xml': {'name': 'Size'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(Block, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.size = kwargs.get('size', None)


class BlockList(Model):
    """BlockList.

    :param committed_blocks:
    :type committed_blocks: list[~azure.storage.blob.models.Block]
    :param uncommitted_blocks:
    :type uncommitted_blocks: list[~azure.storage.blob.models.Block]
    """

    _attribute_map = {
        'committed_blocks': {'key': 'CommittedBlocks', 'type': '[Block]', 'xml': {'name': 'CommittedBlocks', 'itemsName': 'Block', 'wrapped': True}},
        'uncommitted_blocks': {'key': 'UncommittedBlocks', 'type': '[Block]', 'xml': {'name': 'UncommittedBlocks', 'itemsName': 'Block', 'wrapped': True}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(BlockList, self).__init__(**kwargs)
        self.committed_blocks = kwargs.get('committed_blocks', None)
        self.uncommitted_blocks = kwargs.get('uncommitted_blocks', None)


class BlockLookupList(Model):
    """BlockLookupList.

    :param committed:
    :type committed: list[str]
    :param uncommitted:
    :type uncommitted: list[str]
    :param latest:
    :type latest: list[str]
    """

    _attribute_map = {
        'committed': {'key': 'Committed', 'type': '[str]', 'xml': {'name': 'Committed', 'itemsName': 'Committed'}},
        'uncommitted': {'key': 'Uncommitted', 'type': '[str]', 'xml': {'name': 'Uncommitted', 'itemsName': 'Uncommitted'}},
        'latest': {'key': 'Latest', 'type': '[str]', 'xml': {'name': 'Latest', 'itemsName': 'Latest'}},
    }
    _xml_map = {
        'name': 'BlockList'
    }

    def __init__(self, **kwargs):
        super(BlockLookupList, self).__init__(**kwargs)
        self.committed = kwargs.get('committed', None)
        self.uncommitted = kwargs.get('uncommitted', None)
        self.latest = kwargs.get('latest', None)


class ClearRange(Model):
    """ClearRange.

    All required parameters must be populated in order to send to Azure.

    :param start: Required.
    :type start: long
    :param end: Required.
    :type end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'ClearRange'
    }

    def __init__(self, **kwargs):
        super(ClearRange, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)


class ContainerCpkScopeInfo(Model):
    """Additional parameters for create operation.

    :param default_encryption_scope: Optional.  Version 2019-07-07 and later.
     Specifies the default encryption scope to set on the container and use for
     all future writes.
    :type default_encryption_scope: str
    :param prevent_encryption_scope_override: Optional.  Version 2019-07-07
     and newer.  If true, prevents any request from specifying a different
     encryption scope than the scope set on the container.
    :type prevent_encryption_scope_override: bool
    """

    _attribute_map = {
        'default_encryption_scope': {'key': '', 'type': 'str', 'xml': {'name': 'default_encryption_scope'}},
        'prevent_encryption_scope_override': {'key': '', 'type': 'bool', 'xml': {'name': 'prevent_encryption_scope_override'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(ContainerCpkScopeInfo, self).__init__(**kwargs)
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.prevent_encryption_scope_override = kwargs.get('prevent_encryption_scope_override', None)


class ContainerItem(Model):
    """An Azure Storage container.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param deleted:
    :type deleted: bool
    :param version:
    :type version: str
    :param properties: Required.
    :type properties: ~azure.storage.blob.models.ContainerProperties
    :param metadata:
    :type metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'deleted': {'key': 'Deleted', 'type': 'bool', 'xml': {'name': 'Deleted'}},
        'version': {'key': 'Version', 'type': 'str', 'xml': {'name': 'Version'}},
        'properties': {'key': 'Properties', 'type': 'ContainerProperties', 'xml': {'name': 'Properties'}},
        'metadata': {'key': 'Metadata', 'type': '{str}', 'xml': {'name': 'Metadata'}},
    }
    _xml_map = {
        'name': 'Container'
    }

    def __init__(self, **kwargs):
        super(ContainerItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.deleted = kwargs.get('deleted', None)
        self.version = kwargs.get('version', None)
        self.properties = kwargs.get('properties', None)
        self.metadata = kwargs.get('metadata', None)


class ContainerProperties(Model):
    """Properties of a container.

    All required parameters must be populated in order to send to Azure.

    :param last_modified: Required.
    :type last_modified: datetime
    :param etag: Required.
    :type etag: str
    :param lease_status: Possible values include: 'locked', 'unlocked'
    :type lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :param lease_state: Possible values include: 'available', 'leased',
     'expired', 'breaking', 'broken'
    :type lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :param lease_duration: Possible values include: 'infinite', 'fixed'
    :type lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :param public_access: Possible values include: 'container', 'blob'
    :type public_access: str or ~azure.storage.blob.models.PublicAccessType
    :param has_immutability_policy:
    :type has_immutability_policy: bool
    :param has_legal_hold:
    :type has_legal_hold: bool
    :param default_encryption_scope:
    :type default_encryption_scope: str
    :param prevent_encryption_scope_override:
    :type prevent_encryption_scope_override: bool
    :param deleted_time:
    :type deleted_time: datetime
    :param remaining_retention_days:
    :type remaining_retention_days: int
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123', 'xml': {'name': 'Last-Modified'}},
        'etag': {'key': 'Etag', 'type': 'str', 'xml': {'name': 'Etag'}},
        'lease_status': {'key': 'LeaseStatus', 'type': 'LeaseStatusType', 'xml': {'name': 'LeaseStatus'}},
        'lease_state': {'key': 'LeaseState', 'type': 'LeaseStateType', 'xml': {'name': 'LeaseState'}},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'LeaseDurationType', 'xml': {'name': 'LeaseDuration'}},
        'public_access': {'key': 'PublicAccess', 'type': 'str', 'xml': {'name': 'PublicAccess'}},
        'has_immutability_policy': {'key': 'HasImmutabilityPolicy', 'type': 'bool', 'xml': {'name': 'HasImmutabilityPolicy'}},
        'has_legal_hold': {'key': 'HasLegalHold', 'type': 'bool', 'xml': {'name': 'HasLegalHold'}},
        'default_encryption_scope': {'key': 'DefaultEncryptionScope', 'type': 'str', 'xml': {'name': 'DefaultEncryptionScope'}},
        'prevent_encryption_scope_override': {'key': 'DenyEncryptionScopeOverride', 'type': 'bool', 'xml': {'name': 'DenyEncryptionScopeOverride'}},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123', 'xml': {'name': 'DeletedTime'}},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int', 'xml': {'name': 'RemainingRetentionDays'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(ContainerProperties, self).__init__(**kwargs)
        self.last_modified = kwargs.get('last_modified', None)
        self.etag = kwargs.get('etag', None)
        self.lease_status = kwargs.get('lease_status', None)
        self.lease_state = kwargs.get('lease_state', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.public_access = kwargs.get('public_access', None)
        self.has_immutability_policy = kwargs.get('has_immutability_policy', None)
        self.has_legal_hold = kwargs.get('has_legal_hold', None)
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.prevent_encryption_scope_override = kwargs.get('prevent_encryption_scope_override', None)
        self.deleted_time = kwargs.get('deleted_time', None)
        self.remaining_retention_days = kwargs.get('remaining_retention_days', None)


class CorsRule(Model):
    """CORS is an HTTP feature that enables a web application running under one
    domain to access resources in another domain. Web browsers implement a
    security restriction known as same-origin policy that prevents a web page
    from calling APIs in a different domain; CORS provides a secure way to
    allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. The origin domains that are permitted to
     make a request against the storage service via CORS. The origin domain is
     the domain from which the request originates. Note that the origin must be
     an exact case-sensitive match with the origin that the user age sends to
     the service. You can also use the wildcard character '*' to allow all
     origin domains to make requests via CORS.
    :type allowed_origins: str
    :param allowed_methods: Required. The methods (HTTP request verbs) that
     the origin domain may use for a CORS request. (comma separated)
    :type allowed_methods: str
    :param allowed_headers: Required. the request headers that the origin
     domain may specify on the CORS request.
    :type allowed_headers: str
    :param exposed_headers: Required. The response headers that may be sent in
     the response to the CORS request and exposed by the browser to the request
     issuer
    :type exposed_headers: str
    :param max_age_in_seconds: Required. The maximum amount time that a
     browser should cache the preflight OPTIONS request.
    :type max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str', 'xml': {'name': 'AllowedOrigins'}},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str', 'xml': {'name': 'AllowedMethods'}},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str', 'xml': {'name': 'AllowedHeaders'}},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str', 'xml': {'name': 'ExposedHeaders'}},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int', 'xml': {'name': 'MaxAgeInSeconds'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)
        self.allowed_methods = kwargs.get('allowed_methods', None)
        self.allowed_headers = kwargs.get('allowed_headers', None)
        self.exposed_headers = kwargs.get('exposed_headers', None)
        self.max_age_in_seconds = kwargs.get('max_age_in_seconds', None)


class CpkInfo(Model):
    """Additional parameters for a set of operations.

    :param encryption_key: Optional. Specifies the encryption key to use to
     encrypt the data provided in the request. If not specified, encryption is
     performed with the root account encryption key.  For more information, see
     Encryption at Rest for Azure Storage Services.
    :type encryption_key: str
    :param encryption_key_sha256: The SHA-256 hash of the provided encryption
     key. Must be provided if the x-ms-encryption-key header is provided.
    :type encryption_key_sha256: str
    :param encryption_algorithm: The algorithm used to produce the encryption
     key hash. Currently, the only accepted value is "AES256". Must be provided
     if the x-ms-encryption-key header is provided. Possible values include:
     'AES256'
    :type encryption_algorithm: str or
     ~azure.storage.blob.models.EncryptionAlgorithmType
    """

    _attribute_map = {
        'encryption_key': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_key'}},
        'encryption_key_sha256': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_key_sha256'}},
        'encryption_algorithm': {'key': '', 'type': 'EncryptionAlgorithmType', 'xml': {'name': 'encryption_algorithm'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(CpkInfo, self).__init__(**kwargs)
        self.encryption_key = kwargs.get('encryption_key', None)
        self.encryption_key_sha256 = kwargs.get('encryption_key_sha256', None)
        self.encryption_algorithm = kwargs.get('encryption_algorithm', None)


class CpkScopeInfo(Model):
    """Additional parameters for a set of operations.

    :param encryption_scope: Optional. Version 2019-07-07 and later.
     Specifies the name of the encryption scope to use to encrypt the data
     provided in the request. If not specified, encryption is performed with
     the default account encryption scope.  For more information, see
     Encryption at Rest for Azure Storage Services.
    :type encryption_scope: str
    """

    _attribute_map = {
        'encryption_scope': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_scope'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(CpkScopeInfo, self).__init__(**kwargs)
        self.encryption_scope = kwargs.get('encryption_scope', None)


class DataLakeStorageError(Model):
    """DataLakeStorageError.

    :param data_lake_storage_error_details: The service error response object.
    :type data_lake_storage_error_details:
     ~azure.storage.blob.models.DataLakeStorageErrorError
    """

    _attribute_map = {
        'data_lake_storage_error_details': {'key': 'error', 'type': 'DataLakeStorageErrorError', 'xml': {'name': 'error'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(DataLakeStorageError, self).__init__(**kwargs)
        self.data_lake_storage_error_details = kwargs.get('data_lake_storage_error_details', None)


class DataLakeStorageErrorException(HttpResponseError):
    """Server responsed with exception of type: 'DataLakeStorageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'DataLakeStorageError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(DataLakeStorageErrorException, self).__init__(response=response)


class DataLakeStorageErrorError(Model):
    """The service error response object.

    :param code: The service error code.
    :type code: str
    :param message: The service error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str', 'xml': {'name': 'Code'}},
        'message': {'key': 'Message', 'type': 'str', 'xml': {'name': 'Message'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(DataLakeStorageErrorError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class DelimitedTextConfiguration(Model):
    """delimited text configuration.

    All required parameters must be populated in order to send to Azure.

    :param column_separator: Required. column separator
    :type column_separator: str
    :param field_quote: Required. field quote
    :type field_quote: str
    :param record_separator: Required. record separator
    :type record_separator: str
    :param escape_char: Required. escape char
    :type escape_char: str
    :param headers_present: Required. has headers
    :type headers_present: bool
    """

    _validation = {
        'column_separator': {'required': True},
        'field_quote': {'required': True},
        'record_separator': {'required': True},
        'escape_char': {'required': True},
        'headers_present': {'required': True},
    }

    _attribute_map = {
        'column_separator': {'key': 'ColumnSeparator', 'type': 'str', 'xml': {'name': 'ColumnSeparator'}},
        'field_quote': {'key': 'FieldQuote', 'type': 'str', 'xml': {'name': 'FieldQuote'}},
        'record_separator': {'key': 'RecordSeparator', 'type': 'str', 'xml': {'name': 'RecordSeparator'}},
        'escape_char': {'key': 'EscapeChar', 'type': 'str', 'xml': {'name': 'EscapeChar'}},
        'headers_present': {'key': 'HeadersPresent', 'type': 'bool', 'xml': {'name': 'HasHeaders'}},
    }
    _xml_map = {
        'name': 'DelimitedTextConfiguration'
    }

    def __init__(self, **kwargs):
        super(DelimitedTextConfiguration, self).__init__(**kwargs)
        self.column_separator = kwargs.get('column_separator', None)
        self.field_quote = kwargs.get('field_quote', None)
        self.record_separator = kwargs.get('record_separator', None)
        self.escape_char = kwargs.get('escape_char', None)
        self.headers_present = kwargs.get('headers_present', None)


class DirectoryHttpHeaders(Model):
    """Additional parameters for a set of operations, such as: Directory_create,
    Directory_rename, Blob_rename.

    :param cache_control: Cache control for given resource
    :type cache_control: str
    :param content_type: Content type for given resource
    :type content_type: str
    :param content_encoding: Content encoding for given resource
    :type content_encoding: str
    :param content_language: Content language for given resource
    :type content_language: str
    :param content_disposition: Content disposition for given resource
    :type content_disposition: str
    """

    _attribute_map = {
        'cache_control': {'key': '', 'type': 'str', 'xml': {'name': 'cache_control'}},
        'content_type': {'key': '', 'type': 'str', 'xml': {'name': 'content_type'}},
        'content_encoding': {'key': '', 'type': 'str', 'xml': {'name': 'content_encoding'}},
        'content_language': {'key': '', 'type': 'str', 'xml': {'name': 'content_language'}},
        'content_disposition': {'key': '', 'type': 'str', 'xml': {'name': 'content_disposition'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(DirectoryHttpHeaders, self).__init__(**kwargs)
        self.cache_control = kwargs.get('cache_control', None)
        self.content_type = kwargs.get('content_type', None)
        self.content_encoding = kwargs.get('content_encoding', None)
        self.content_language = kwargs.get('content_language', None)
        self.content_disposition = kwargs.get('content_disposition', None)


class FilterBlobItem(Model):
    """Blob info from a Filter Blobs API call.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param container_name: Required.
    :type container_name: str
    :param tags:
    :type tags: ~azure.storage.blob.models.BlobTags
    """

    _validation = {
        'name': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'name': 'ContainerName'}},
        'tags': {'key': 'Tags', 'type': 'BlobTags', 'xml': {'name': 'Tags'}},
    }
    _xml_map = {
        'name': 'Blob'
    }

    def __init__(self, **kwargs):
        super(FilterBlobItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.container_name = kwargs.get('container_name', None)
        self.tags = kwargs.get('tags', None)


class FilterBlobSegment(Model):
    """The result of a Filter Blobs API call.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param where: Required.
    :type where: str
    :param blobs: Required.
    :type blobs: list[~azure.storage.blob.models.FilterBlobItem]
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'where': {'required': True},
        'blobs': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'where': {'key': 'Where', 'type': 'str', 'xml': {'name': 'Where'}},
        'blobs': {'key': 'Blobs', 'type': '[FilterBlobItem]', 'xml': {'name': 'Blobs', 'itemsName': 'Blobs', 'wrapped': True}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, **kwargs):
        super(FilterBlobSegment, self).__init__(**kwargs)
        self.service_endpoint = kwargs.get('service_endpoint', None)
        self.where = kwargs.get('where', None)
        self.blobs = kwargs.get('blobs', None)
        self.next_marker = kwargs.get('next_marker', None)


class GeoReplication(Model):
    """Geo-Replication information for the Secondary Storage Service.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of the secondary location. Possible
     values include: 'live', 'bootstrap', 'unavailable'
    :type status: str or ~azure.storage.blob.models.GeoReplicationStatusType
    :param last_sync_time: Required. A GMT date/time value, to the second. All
     primary writes preceding this value are guaranteed to be available for
     read operations at the secondary. Primary writes after this point in time
     may or may not be available for reads.
    :type last_sync_time: datetime
    """

    _validation = {
        'status': {'required': True},
        'last_sync_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str', 'xml': {'name': 'Status'}},
        'last_sync_time': {'key': 'LastSyncTime', 'type': 'rfc-1123', 'xml': {'name': 'LastSyncTime'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(GeoReplication, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.last_sync_time = kwargs.get('last_sync_time', None)


class JsonTextConfiguration(Model):
    """json text configuration.

    All required parameters must be populated in order to send to Azure.

    :param record_separator: Required. record separator
    :type record_separator: str
    """

    _validation = {
        'record_separator': {'required': True},
    }

    _attribute_map = {
        'record_separator': {'key': 'RecordSeparator', 'type': 'str', 'xml': {'name': 'RecordSeparator'}},
    }
    _xml_map = {
        'name': 'JsonTextConfiguration'
    }

    def __init__(self, **kwargs):
        super(JsonTextConfiguration, self).__init__(**kwargs)
        self.record_separator = kwargs.get('record_separator', None)


class KeyInfo(Model):
    """Key information.

    All required parameters must be populated in order to send to Azure.

    :param start: Required. The date-time the key is active in ISO 8601 UTC
     time
    :type start: str
    :param expiry: Required. The date-time the key expires in ISO 8601 UTC
     time
    :type expiry: str
    """

    _validation = {
        'start': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str', 'xml': {'name': 'Start'}},
        'expiry': {'key': 'Expiry', 'type': 'str', 'xml': {'name': 'Expiry'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(KeyInfo, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)


class LeaseAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param lease_id: If specified, the operation only succeeds if the
     resource's lease is active and matches this ID.
    :type lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': '', 'type': 'str', 'xml': {'name': 'lease_id'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = kwargs.get('lease_id', None)


class ListBlobsFlatSegmentResponse(Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param container_name: Required.
    :type container_name: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param segment: Required.
    :type segment: ~azure.storage.blob.models.BlobFlatListSegment
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'name': 'ContainerName', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'segment': {'key': 'Segment', 'type': 'BlobFlatListSegment', 'xml': {'name': 'Segment'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, **kwargs):
        super(ListBlobsFlatSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs.get('service_endpoint', None)
        self.container_name = kwargs.get('container_name', None)
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.segment = kwargs.get('segment', None)
        self.next_marker = kwargs.get('next_marker', None)


class ListBlobsHierarchySegmentResponse(Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param container_name: Required.
    :type container_name: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param delimiter:
    :type delimiter: str
    :param segment: Required.
    :type segment: ~azure.storage.blob.models.BlobHierarchyListSegment
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'name': 'ContainerName', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'delimiter': {'key': 'Delimiter', 'type': 'str', 'xml': {'name': 'Delimiter'}},
        'segment': {'key': 'Segment', 'type': 'BlobHierarchyListSegment', 'xml': {'name': 'Segment'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, **kwargs):
        super(ListBlobsHierarchySegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs.get('service_endpoint', None)
        self.container_name = kwargs.get('container_name', None)
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.delimiter = kwargs.get('delimiter', None)
        self.segment = kwargs.get('segment', None)
        self.next_marker = kwargs.get('next_marker', None)


class ListContainersSegmentResponse(Model):
    """An enumeration of containers.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param container_items: Required.
    :type container_items: list[~azure.storage.blob.models.ContainerItem]
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_items': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'container_items': {'key': 'ContainerItems', 'type': '[ContainerItem]', 'xml': {'name': 'Containers', 'itemsName': 'Containers', 'wrapped': True}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, **kwargs):
        super(ListContainersSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs.get('service_endpoint', None)
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.container_items = kwargs.get('container_items', None)
        self.next_marker = kwargs.get('next_marker', None)


class Logging(Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of Storage Analytics to configure.
    :type version: str
    :param delete: Required. Indicates whether all delete requests should be
     logged.
    :type delete: bool
    :param read: Required. Indicates whether all read requests should be
     logged.
    :type read: bool
    :param write: Required. Indicates whether all write requests should be
     logged.
    :type write: bool
    :param retention_policy: Required.
    :type retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'delete': {'required': True},
        'read': {'required': True},
        'write': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str', 'xml': {'name': 'Version'}},
        'delete': {'key': 'Delete', 'type': 'bool', 'xml': {'name': 'Delete'}},
        'read': {'key': 'Read', 'type': 'bool', 'xml': {'name': 'Read'}},
        'write': {'key': 'Write', 'type': 'bool', 'xml': {'name': 'Write'}},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'RetentionPolicy'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(Logging, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.delete = kwargs.get('delete', None)
        self.read = kwargs.get('read', None)
        self.write = kwargs.get('write', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class Metrics(Model):
    """a summary of request statistics grouped by API in hour or minute aggregates
    for blobs.

    All required parameters must be populated in order to send to Azure.

    :param version: The version of Storage Analytics to configure.
    :type version: str
    :param enabled: Required. Indicates whether metrics are enabled for the
     Blob service.
    :type enabled: bool
    :param include_apis: Indicates whether metrics should generate summary
     statistics for called API operations.
    :type include_apis: bool
    :param retention_policy:
    :type retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str', 'xml': {'name': 'Version'}},
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool', 'xml': {'name': 'IncludeAPIs'}},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'RetentionPolicy'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(Metrics, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.enabled = kwargs.get('enabled', None)
        self.include_apis = kwargs.get('include_apis', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class ModifiedAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param if_modified_since: Specify this header value to operate only on a
     blob if it has been modified since the specified date/time.
    :type if_modified_since: datetime
    :param if_unmodified_since: Specify this header value to operate only on a
     blob if it has not been modified since the specified date/time.
    :type if_unmodified_since: datetime
    :param if_match: Specify an ETag value to operate only on blobs with a
     matching value.
    :type if_match: str
    :param if_none_match: Specify an ETag value to operate only on blobs
     without a matching value.
    :type if_none_match: str
    :param if_tags: Specify a SQL where clause on blob tags to operate only on
     blobs with a matching value.
    :type if_tags: str
    """

    _attribute_map = {
        'if_modified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'if_modified_since'}},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'if_unmodified_since'}},
        'if_match': {'key': '', 'type': 'str', 'xml': {'name': 'if_match'}},
        'if_none_match': {'key': '', 'type': 'str', 'xml': {'name': 'if_none_match'}},
        'if_tags': {'key': '', 'type': 'str', 'xml': {'name': 'if_tags'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(ModifiedAccessConditions, self).__init__(**kwargs)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_tags = kwargs.get('if_tags', None)


class PageList(Model):
    """the list of pages.

    :param page_range:
    :type page_range: list[~azure.storage.blob.models.PageRange]
    :param clear_range:
    :type clear_range: list[~azure.storage.blob.models.ClearRange]
    """

    _attribute_map = {
        'page_range': {'key': 'PageRange', 'type': '[PageRange]', 'xml': {'name': 'PageRange', 'itemsName': 'PageRange'}},
        'clear_range': {'key': 'ClearRange', 'type': '[ClearRange]', 'xml': {'name': 'ClearRange', 'itemsName': 'ClearRange'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(PageList, self).__init__(**kwargs)
        self.page_range = kwargs.get('page_range', None)
        self.clear_range = kwargs.get('clear_range', None)


class PageRange(Model):
    """PageRange.

    All required parameters must be populated in order to send to Azure.

    :param start: Required.
    :type start: long
    :param end: Required.
    :type end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'PageRange'
    }

    def __init__(self, **kwargs):
        super(PageRange, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)


class QueryFormat(Model):
    """QueryFormat.

    :param type: Possible values include: 'delimited', 'json', 'arrow'
    :type type: str or ~azure.storage.blob.models.QueryFormatType
    :param delimited_text_configuration:
    :type delimited_text_configuration:
     ~azure.storage.blob.models.DelimitedTextConfiguration
    :param json_text_configuration:
    :type json_text_configuration:
     ~azure.storage.blob.models.JsonTextConfiguration
    :param arrow_configuration:
    :type arrow_configuration: ~azure.storage.blob.models.ArrowConfiguration
    """

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'QueryFormatType', 'xml': {'name': 'Type'}},
        'delimited_text_configuration': {'key': 'DelimitedTextConfiguration', 'type': 'DelimitedTextConfiguration', 'xml': {'name': 'DelimitedTextConfiguration'}},
        'json_text_configuration': {'key': 'JsonTextConfiguration', 'type': 'JsonTextConfiguration', 'xml': {'name': 'JsonTextConfiguration'}},
        'arrow_configuration': {'key': 'ArrowConfiguration', 'type': 'ArrowConfiguration', 'xml': {'name': 'ArrowConfiguration'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(QueryFormat, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.delimited_text_configuration = kwargs.get('delimited_text_configuration', None)
        self.json_text_configuration = kwargs.get('json_text_configuration', None)
        self.arrow_configuration = kwargs.get('arrow_configuration', None)


class QueryRequest(Model):
    """the quick query body.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar query_type: Required. the query type. Default value: "SQL" .
    :vartype query_type: str
    :param expression: Required. a query statement
    :type expression: str
    :param input_serialization:
    :type input_serialization: ~azure.storage.blob.models.QuerySerialization
    :param output_serialization:
    :type output_serialization: ~azure.storage.blob.models.QuerySerialization
    """

    _validation = {
        'query_type': {'required': True, 'constant': True},
        'expression': {'required': True},
    }

    _attribute_map = {
        'query_type': {'key': 'QueryType', 'type': 'str', 'xml': {'name': 'QueryType'}},
        'expression': {'key': 'Expression', 'type': 'str', 'xml': {'name': 'Expression'}},
        'input_serialization': {'key': 'InputSerialization', 'type': 'QuerySerialization', 'xml': {'name': 'InputSerialization'}},
        'output_serialization': {'key': 'OutputSerialization', 'type': 'QuerySerialization', 'xml': {'name': 'OutputSerialization'}},
    }
    _xml_map = {
        'name': 'QueryRequest'
    }

    query_type = "SQL"

    def __init__(self, **kwargs):
        super(QueryRequest, self).__init__(**kwargs)
        self.expression = kwargs.get('expression', None)
        self.input_serialization = kwargs.get('input_serialization', None)
        self.output_serialization = kwargs.get('output_serialization', None)


class QuerySerialization(Model):
    """QuerySerialization.

    All required parameters must be populated in order to send to Azure.

    :param format: Required.
    :type format: ~azure.storage.blob.models.QueryFormat
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'Format', 'type': 'QueryFormat', 'xml': {'name': 'Format'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(QuerySerialization, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)


class RetentionPolicy(Model):
    """the retention policy which determines how long the associated data should
    persist.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Indicates whether a retention policy is enabled
     for the storage service
    :type enabled: bool
    :param days: Indicates the number of days that metrics or logging or
     soft-deleted data should be retained. All data older than this value will
     be deleted
    :type days: int
    :param allow_permanent_delete: Indicates whether permanent delete is
     allowed on this storage account.
    :type allow_permanent_delete: bool
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'days': {'key': 'Days', 'type': 'int', 'xml': {'name': 'Days'}},
        'allow_permanent_delete': {'key': 'AllowPermanentDelete', 'type': 'bool', 'xml': {'name': 'AllowPermanentDelete'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.days = kwargs.get('days', None)
        self.allow_permanent_delete = kwargs.get('allow_permanent_delete', None)


class SequenceNumberAccessConditions(Model):
    """Additional parameters for a set of operations, such as:
    PageBlob_upload_pages, PageBlob_clear_pages,
    PageBlob_upload_pages_from_url.

    :param if_sequence_number_less_than_or_equal_to: Specify this header value
     to operate only on a blob if it has a sequence number less than or equal
     to the specified.
    :type if_sequence_number_less_than_or_equal_to: long
    :param if_sequence_number_less_than: Specify this header value to operate
     only on a blob if it has a sequence number less than the specified.
    :type if_sequence_number_less_than: long
    :param if_sequence_number_equal_to: Specify this header value to operate
     only on a blob if it has the specified sequence number.
    :type if_sequence_number_equal_to: long
    """

    _attribute_map = {
        'if_sequence_number_less_than_or_equal_to': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_less_than_or_equal_to'}},
        'if_sequence_number_less_than': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_less_than'}},
        'if_sequence_number_equal_to': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_equal_to'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(SequenceNumberAccessConditions, self).__init__(**kwargs)
        self.if_sequence_number_less_than_or_equal_to = kwargs.get('if_sequence_number_less_than_or_equal_to', None)
        self.if_sequence_number_less_than = kwargs.get('if_sequence_number_less_than', None)
        self.if_sequence_number_equal_to = kwargs.get('if_sequence_number_equal_to', None)


class SignedIdentifier(Model):
    """signed identifier.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. a unique id
    :type id: str
    :param access_policy:
    :type access_policy: ~azure.storage.blob.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str', 'xml': {'name': 'Id'}},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy', 'xml': {'name': 'AccessPolicy'}},
    }
    _xml_map = {
        'name': 'SignedIdentifier'
    }

    def __init__(self, **kwargs):
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.access_policy = kwargs.get('access_policy', None)


class SourceModifiedAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param source_if_modified_since: Specify this header value to operate only
     on a blob if it has been modified since the specified date/time.
    :type source_if_modified_since: datetime
    :param source_if_unmodified_since: Specify this header value to operate
     only on a blob if it has not been modified since the specified date/time.
    :type source_if_unmodified_since: datetime
    :param source_if_match: Specify an ETag value to operate only on blobs
     with a matching value.
    :type source_if_match: str
    :param source_if_none_match: Specify an ETag value to operate only on
     blobs without a matching value.
    :type source_if_none_match: str
    :param source_if_tags: Specify a SQL where clause on blob tags to operate
     only on blobs with a matching value.
    :type source_if_tags: str
    """

    _attribute_map = {
        'source_if_modified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'source_if_modified_since'}},
        'source_if_unmodified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'source_if_unmodified_since'}},
        'source_if_match': {'key': '', 'type': 'str', 'xml': {'name': 'source_if_match'}},
        'source_if_none_match': {'key': '', 'type': 'str', 'xml': {'name': 'source_if_none_match'}},
        'source_if_tags': {'key': '', 'type': 'str', 'xml': {'name': 'source_if_tags'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_modified_since = kwargs.get('source_if_modified_since', None)
        self.source_if_unmodified_since = kwargs.get('source_if_unmodified_since', None)
        self.source_if_match = kwargs.get('source_if_match', None)
        self.source_if_none_match = kwargs.get('source_if_none_match', None)
        self.source_if_tags = kwargs.get('source_if_tags', None)


class StaticWebsite(Model):
    """The properties that enable an account to host a static website.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Indicates whether this account is hosting a
     static website
    :type enabled: bool
    :param index_document: The default name of the index page under each
     directory
    :type index_document: str
    :param error_document404_path: The absolute path of the custom 404 page
    :type error_document404_path: str
    :param default_index_document_path: Absolute path of the default index
     page
    :type default_index_document_path: str
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'index_document': {'key': 'IndexDocument', 'type': 'str', 'xml': {'name': 'IndexDocument'}},
        'error_document404_path': {'key': 'ErrorDocument404Path', 'type': 'str', 'xml': {'name': 'ErrorDocument404Path'}},
        'default_index_document_path': {'key': 'DefaultIndexDocumentPath', 'type': 'str', 'xml': {'name': 'DefaultIndexDocumentPath'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(StaticWebsite, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.index_document = kwargs.get('index_document', None)
        self.error_document404_path = kwargs.get('error_document404_path', None)
        self.default_index_document_path = kwargs.get('default_index_document_path', None)


class StorageError(Model):
    """StorageError.

    :param message:
    :type message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str', 'xml': {'name': 'Message'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(StorageError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)


class StorageErrorException(HttpResponseError):
    """Server responsed with exception of type: 'StorageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'StorageError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(StorageErrorException, self).__init__(response=response)


class StorageServiceProperties(Model):
    """Storage Service Properties.

    :param logging:
    :type logging: ~azure.storage.blob.models.Logging
    :param hour_metrics:
    :type hour_metrics: ~azure.storage.blob.models.Metrics
    :param minute_metrics:
    :type minute_metrics: ~azure.storage.blob.models.Metrics
    :param cors: The set of CORS rules.
    :type cors: list[~azure.storage.blob.models.CorsRule]
    :param default_service_version: The default version to use for requests to
     the Blob service if an incoming request's version is not specified.
     Possible values include version 2008-10-27 and all more recent versions
    :type default_service_version: str
    :param delete_retention_policy:
    :type delete_retention_policy: ~azure.storage.blob.models.RetentionPolicy
    :param static_website:
    :type static_website: ~azure.storage.blob.models.StaticWebsite
    """

    _attribute_map = {
        'logging': {'key': 'Logging', 'type': 'Logging', 'xml': {'name': 'Logging'}},
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics', 'xml': {'name': 'HourMetrics'}},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics', 'xml': {'name': 'MinuteMetrics'}},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'name': 'Cors', 'itemsName': 'CorsRule', 'wrapped': True}},
        'default_service_version': {'key': 'DefaultServiceVersion', 'type': 'str', 'xml': {'name': 'DefaultServiceVersion'}},
        'delete_retention_policy': {'key': 'DeleteRetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'DeleteRetentionPolicy'}},
        'static_website': {'key': 'StaticWebsite', 'type': 'StaticWebsite', 'xml': {'name': 'StaticWebsite'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.logging = kwargs.get('logging', None)
        self.hour_metrics = kwargs.get('hour_metrics', None)
        self.minute_metrics = kwargs.get('minute_metrics', None)
        self.cors = kwargs.get('cors', None)
        self.default_service_version = kwargs.get('default_service_version', None)
        self.delete_retention_policy = kwargs.get('delete_retention_policy', None)
        self.static_website = kwargs.get('static_website', None)


class StorageServiceStats(Model):
    """Stats for the storage service.

    :param geo_replication:
    :type geo_replication: ~azure.storage.blob.models.GeoReplication
    """

    _attribute_map = {
        'geo_replication': {'key': 'GeoReplication', 'type': 'GeoReplication', 'xml': {'name': 'GeoReplication'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(StorageServiceStats, self).__init__(**kwargs)
        self.geo_replication = kwargs.get('geo_replication', None)


class UserDelegationKey(Model):
    """A user delegation key.

    All required parameters must be populated in order to send to Azure.

    :param signed_oid: Required. The Azure Active Directory object ID in GUID
     format.
    :type signed_oid: str
    :param signed_tid: Required. The Azure Active Directory tenant ID in GUID
     format
    :type signed_tid: str
    :param signed_start: Required. The date-time the key is active
    :type signed_start: datetime
    :param signed_expiry: Required. The date-time the key expires
    :type signed_expiry: datetime
    :param signed_service: Required. Abbreviation of the Azure Storage service
     that accepts the key
    :type signed_service: str
    :param signed_version: Required. The service version that created the key
    :type signed_version: str
    :param value: Required. The key as a base64 string
    :type value: str
    """

    _validation = {
        'signed_oid': {'required': True},
        'signed_tid': {'required': True},
        'signed_start': {'required': True},
        'signed_expiry': {'required': True},
        'signed_service': {'required': True},
        'signed_version': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'signed_oid': {'key': 'SignedOid', 'type': 'str', 'xml': {'name': 'SignedOid'}},
        'signed_tid': {'key': 'SignedTid', 'type': 'str', 'xml': {'name': 'SignedTid'}},
        'signed_start': {'key': 'SignedStart', 'type': 'iso-8601', 'xml': {'name': 'SignedStart'}},
        'signed_expiry': {'key': 'SignedExpiry', 'type': 'iso-8601', 'xml': {'name': 'SignedExpiry'}},
        'signed_service': {'key': 'SignedService', 'type': 'str', 'xml': {'name': 'SignedService'}},
        'signed_version': {'key': 'SignedVersion', 'type': 'str', 'xml': {'name': 'SignedVersion'}},
        'value': {'key': 'Value', 'type': 'str', 'xml': {'name': 'Value'}},
    }
    _xml_map = {
    }

    def __init__(self, **kwargs):
        super(UserDelegationKey, self).__init__(**kwargs)
        self.signed_oid = kwargs.get('signed_oid', None)
        self.signed_tid = kwargs.get('signed_tid', None)
        self.signed_start = kwargs.get('signed_start', None)
        self.signed_expiry = kwargs.get('signed_expiry', None)
        self.signed_service = kwargs.get('signed_service', None)
        self.signed_version = kwargs.get('signed_version', None)
        self.value = kwargs.get('value', None)
