/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.Phonemetadata;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

final class MetadataFilter {
    static final TreeSet<String> excludableParentFields = new TreeSet<String>(Arrays.asList("fixedLine", "mobile", "tollFree", "premiumRate", "sharedCost", "personalNumber", "voip", "pager", "uan", "emergency", "voicemail", "shortCode", "standardRate", "carrierSpecific", "smsServices", "noInternationalDialling"));
    static final TreeSet<String> excludableChildFields = new TreeSet<String>(Arrays.asList("nationalNumberPattern", "possibleLength", "possibleLengthLocalOnly", "exampleNumber"));
    static final TreeSet<String> excludableChildlessFields = new TreeSet<String>(Arrays.asList("preferredInternationalPrefix", "nationalPrefix", "preferredExtnPrefix", "nationalPrefixTransformRule", "sameMobileAndFixedLinePattern", "mainCountryForCode", "leadingZeroPossible", "mobileNumberPortableRegion"));
    private final TreeMap<String, TreeSet<String>> blacklist;

    static MetadataFilter forLiteBuild() {
        return new MetadataFilter(MetadataFilter.parseFieldMapFromString("exampleNumber"));
    }

    static MetadataFilter forSpecialBuild() {
        return new MetadataFilter(MetadataFilter.computeComplement(MetadataFilter.parseFieldMapFromString("mobile")));
    }

    static MetadataFilter emptyFilter() {
        return new MetadataFilter(new TreeMap<String, TreeSet<String>>());
    }

    MetadataFilter(TreeMap<String, TreeSet<String>> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean equals(Object obj) {
        return this.blacklist.equals(((MetadataFilter)obj).blacklist);
    }

    public int hashCode() {
        return this.blacklist.hashCode();
    }

    void filterMetadata(Phonemetadata.PhoneMetadata.Builder metadata) {
        if (metadata.hasFixedLine()) {
            metadata.setFixedLine(this.getFiltered("fixedLine", metadata.getFixedLine()));
        }
        if (metadata.hasMobile()) {
            metadata.setMobile(this.getFiltered("mobile", metadata.getMobile()));
        }
        if (metadata.hasTollFree()) {
            metadata.setTollFree(this.getFiltered("tollFree", metadata.getTollFree()));
        }
        if (metadata.hasPremiumRate()) {
            metadata.setPremiumRate(this.getFiltered("premiumRate", metadata.getPremiumRate()));
        }
        if (metadata.hasSharedCost()) {
            metadata.setSharedCost(this.getFiltered("sharedCost", metadata.getSharedCost()));
        }
        if (metadata.hasPersonalNumber()) {
            metadata.setPersonalNumber(this.getFiltered("personalNumber", metadata.getPersonalNumber()));
        }
        if (metadata.hasVoip()) {
            metadata.setVoip(this.getFiltered("voip", metadata.getVoip()));
        }
        if (metadata.hasPager()) {
            metadata.setPager(this.getFiltered("pager", metadata.getPager()));
        }
        if (metadata.hasUan()) {
            metadata.setUan(this.getFiltered("uan", metadata.getUan()));
        }
        if (metadata.hasEmergency()) {
            metadata.setEmergency(this.getFiltered("emergency", metadata.getEmergency()));
        }
        if (metadata.hasVoicemail()) {
            metadata.setVoicemail(this.getFiltered("voicemail", metadata.getVoicemail()));
        }
        if (metadata.hasShortCode()) {
            metadata.setShortCode(this.getFiltered("shortCode", metadata.getShortCode()));
        }
        if (metadata.hasStandardRate()) {
            metadata.setStandardRate(this.getFiltered("standardRate", metadata.getStandardRate()));
        }
        if (metadata.hasCarrierSpecific()) {
            metadata.setCarrierSpecific(this.getFiltered("carrierSpecific", metadata.getCarrierSpecific()));
        }
        if (metadata.hasSmsServices()) {
            metadata.setSmsServices(this.getFiltered("smsServices", metadata.getSmsServices()));
        }
        if (metadata.hasNoInternationalDialling()) {
            metadata.setNoInternationalDialling(this.getFiltered("noInternationalDialling", metadata.getNoInternationalDialling()));
        }
        if (this.shouldDrop("preferredInternationalPrefix")) {
            metadata.clearPreferredInternationalPrefix();
        }
        if (this.shouldDrop("nationalPrefix")) {
            metadata.clearNationalPrefix();
        }
        if (this.shouldDrop("preferredExtnPrefix")) {
            metadata.clearPreferredExtnPrefix();
        }
        if (this.shouldDrop("nationalPrefixTransformRule")) {
            metadata.clearNationalPrefixTransformRule();
        }
        if (this.shouldDrop("sameMobileAndFixedLinePattern")) {
            metadata.clearSameMobileAndFixedLinePattern();
        }
        if (this.shouldDrop("mainCountryForCode")) {
            metadata.clearMainCountryForCode();
        }
        if (this.shouldDrop("leadingZeroPossible")) {
            metadata.clearLeadingZeroPossible();
        }
        if (this.shouldDrop("mobileNumberPortableRegion")) {
            metadata.clearMobileNumberPortableRegion();
        }
    }

    static TreeMap<String, TreeSet<String>> parseFieldMapFromString(String string) {
        if (string == null) {
            throw new RuntimeException("Null string should not be passed to parseFieldMapFromString");
        }
        if ((string = string.replaceAll("\\s", "")).isEmpty()) {
            throw new RuntimeException("Empty string should not be passed to parseFieldMapFromString");
        }
        TreeMap<String, TreeSet<String>> fieldMap = new TreeMap<String, TreeSet<String>>();
        TreeSet<String> wildcardChildren = new TreeSet<String>();
        for (String group : string.split(":", -1)) {
            int leftParenIndex = group.indexOf(40);
            int rightParenIndex = group.indexOf(41);
            if (leftParenIndex < 0 && rightParenIndex < 0) {
                String string2;
                if (excludableParentFields.contains(group)) {
                    if (fieldMap.containsKey(group)) {
                        string2 = string;
                        throw new RuntimeException(new StringBuilder(25 + String.valueOf(group).length() + String.valueOf(string2).length()).append(group).append(" given more than once in ").append(string2).toString());
                    }
                    fieldMap.put(group, new TreeSet<String>((SortedSet<String>)excludableChildFields));
                    continue;
                }
                if (excludableChildlessFields.contains(group)) {
                    if (fieldMap.containsKey(group)) {
                        string2 = string;
                        throw new RuntimeException(new StringBuilder(25 + String.valueOf(group).length() + String.valueOf(string2).length()).append(group).append(" given more than once in ").append(string2).toString());
                    }
                    fieldMap.put(group, new TreeSet());
                    continue;
                }
                if (excludableChildFields.contains(group)) {
                    if (wildcardChildren.contains(group)) {
                        string2 = string;
                        throw new RuntimeException(new StringBuilder(25 + String.valueOf(group).length() + String.valueOf(string2).length()).append(group).append(" given more than once in ").append(string2).toString());
                    }
                    wildcardChildren.add(group);
                    continue;
                }
                throw new RuntimeException(String.valueOf(group).concat(" is not a valid token"));
            }
            if (leftParenIndex > 0 && rightParenIndex == group.length() - 1) {
                String parent = group.substring(0, leftParenIndex);
                if (!excludableParentFields.contains(parent)) {
                    throw new RuntimeException(String.valueOf(parent).concat(" is not a valid parent token"));
                }
                if (fieldMap.containsKey(parent)) {
                    String string3 = string;
                    throw new RuntimeException(new StringBuilder(25 + String.valueOf(parent).length() + String.valueOf(string3).length()).append(parent).append(" given more than once in ").append(string3).toString());
                }
                TreeSet<String> children = new TreeSet<String>();
                for (String child : group.substring(leftParenIndex + 1, rightParenIndex).split(",", -1)) {
                    if (!excludableChildFields.contains(child)) {
                        throw new RuntimeException(String.valueOf(child).concat(" is not a valid child token"));
                    }
                    if (children.add(child)) continue;
                    throw new RuntimeException(new StringBuilder(25 + String.valueOf(child).length() + String.valueOf(group).length()).append(child).append(" given more than once in ").append(group).toString());
                }
                fieldMap.put(parent, children);
                continue;
            }
            String string4 = String.valueOf(group);
            throw new RuntimeException(string4.length() != 0 ? "Incorrect location of parantheses in ".concat(string4) : new String("Incorrect location of parantheses in "));
        }
        for (String wildcardChild : wildcardChildren) {
            for (String parent : excludableParentFields) {
                TreeSet<String> children = fieldMap.get(parent);
                if (children == null) {
                    children = new TreeSet();
                    fieldMap.put(parent, children);
                }
                if (children.add(wildcardChild) || fieldMap.get(parent).size() == excludableChildFields.size()) continue;
                throw new RuntimeException(new StringBuilder(48 + String.valueOf(wildcardChild).length() + String.valueOf(parent).length()).append(wildcardChild).append(" is present by itself so remove it from ").append(parent).append("'s group").toString());
            }
        }
        return fieldMap;
    }

    static TreeMap<String, TreeSet<String>> computeComplement(TreeMap<String, TreeSet<String>> fieldMap) {
        TreeMap<String, TreeSet<String>> complement = new TreeMap<String, TreeSet<String>>();
        for (String parent : excludableParentFields) {
            if (!fieldMap.containsKey(parent)) {
                complement.put(parent, new TreeSet<String>((SortedSet<String>)excludableChildFields));
                continue;
            }
            TreeSet<String> otherChildren = fieldMap.get(parent);
            if (otherChildren.size() == excludableChildFields.size()) continue;
            TreeSet<String> children = new TreeSet<String>();
            for (String child : excludableChildFields) {
                if (otherChildren.contains(child)) continue;
                children.add(child);
            }
            complement.put(parent, children);
        }
        for (String childlessField : excludableChildlessFields) {
            if (fieldMap.containsKey(childlessField)) continue;
            complement.put(childlessField, new TreeSet());
        }
        return complement;
    }

    boolean shouldDrop(String parent, String child) {
        if (!excludableParentFields.contains(parent)) {
            throw new RuntimeException(String.valueOf(parent).concat(" is not an excludable parent field"));
        }
        if (!excludableChildFields.contains(child)) {
            throw new RuntimeException(String.valueOf(child).concat(" is not an excludable child field"));
        }
        return this.blacklist.containsKey(parent) && this.blacklist.get(parent).contains(child);
    }

    boolean shouldDrop(String childlessField) {
        if (!excludableChildlessFields.contains(childlessField)) {
            throw new RuntimeException(String.valueOf(childlessField).concat(" is not an excludable childless field"));
        }
        return this.blacklist.containsKey(childlessField);
    }

    private Phonemetadata.PhoneNumberDesc getFiltered(String type, Phonemetadata.PhoneNumberDesc desc) {
        Phonemetadata.PhoneNumberDesc.Builder builder = Phonemetadata.PhoneNumberDesc.newBuilder().mergeFrom(desc);
        if (this.shouldDrop(type, "nationalNumberPattern")) {
            builder.clearNationalNumberPattern();
        }
        if (this.shouldDrop(type, "possibleLength")) {
            builder.clearPossibleLength();
        }
        if (this.shouldDrop(type, "possibleLengthLocalOnly")) {
            builder.clearPossibleLengthLocalOnly();
        }
        if (this.shouldDrop(type, "exampleNumber")) {
            builder.clearExampleNumber();
        }
        return builder.build();
    }
}

