/* SPDX-License-Identifier: GPL-2.0-only OR MIT */
/*
 * This file is created based on MT8189 Functional Specification
 * Chapter number: 9.2
 */

#ifndef __SOC_MEDIATEK_MT8189_INCLUDE_SOC_GPIO_H__
#define __SOC_MEDIATEK_MT8189_INCLUDE_SOC_GPIO_H__

#include <soc/addressmap.h>
#include <soc/gpio_common.h>
#include <soc/gpio_defs.h>
#include <types.h>

#define GPIO_NUM 183

struct gpio_regs {
	struct gpio_val_regs dir[16];
	struct gpio_val_regs dout[16];
	struct gpio_val_regs din[16];
	struct gpio_val_regs mode[32];
	uint32_t dram_pinmux_trapping;
};

enum {
	PIN(0, GPIO00, 0, 0, 0x01, 0,
	    TP_GPIO0_AO, SPIM3_A_CSB, I2SOUT0_MCK, SCP_SPI0_CS,
	    RES5, CONN_BPI_BUS6, DBG_MON_A0),
	PIN(1, GPIO01, 0, 0, 0x01, 0,
	    TP_GPIO1_AO, SPIM3_A_CLK, I2SOUT0_BCK, SCP_SPI0_CK,
	    RES5, CONN_BPI_BUS7, DBG_MON_A1),
	PIN(2, GPIO02, 0, 0, 0x01, 0,
	    TP_GPIO2_AO, SPIM3_A_MO, I2SOUT0_LRCK, SCP_SPI0_MO,
	    RES5, CONN_BPI_BUS8, DBG_MON_A2),
	PIN(3, GPIO03, 0, 0, 0x01, 0,
	    TP_GPIO3_AO, SPIM3_A_MI, I2SOUT0_DO, SCP_SPI0_MI,
	    RES5, CONN_BPI_BUS9, DBG_MON_A3),
	PIN(4, GPIO04, 0, 0, 0x01, 0,
	    TP_GPIO4_AO, SPIM4_A_CSB, I2SIN0_DI, SCP_SPI1_CS,
	    RES5, CONN_BPI_BUS10, DBG_MON_A4),
	PIN(5, GPIO05, 0, 0, 0x01, 0,
	    TP_GPIO5_AO, SPIM4_A_CLK, I2SIN0_BCK, SCP_SPI1_CK,
	    RES5, CONN_BPI_BUS11_OLAT0, DBG_MON_A5),
	PIN(6, GPIO06, 0, 0, 0x01, 0,
	    TP_GPIO6_AO, SPIM4_A_MO, I2SIN0_LRCK, SCP_SPI1_MO,
	    RES5, CONN_BPI_BUS12_OLAT1, DBG_MON_A6),
	PIN(7, GPIO07, 0, 0, 0x01, 0,
	    TP_GPIO7_AO, SPIM4_A_MI, I2SIN0_MCK, SCP_SPI1_MI,
	    RES5, CONN_BPI_BUS13_OLAT2, DBG_MON_A7),
	PIN(8, GPIO08, 0, 0, 0x01, 0,
	    TP_UTXD1_VLP, SPIM5_A_CSB, I2SOUT1_MCK, VADSP_UTXD0,
	    RES5, CONN_BPI_BUS14_OLAT3, DBG_MON_A8),
	PIN(9, GPIO09, 0, 0, 0x01, 0,
	    TP_URXD1_VLP, SPIM5_A_CLK, I2SOUT1_BCK, VADSP_URXD0,
	    RES5, CONN_BPI_BUS15_OLAT4, DBG_MON_A9),
	PIN(10, GPIO10, 0, 0, 0x01, 0,
	    TP_UCTS1_VLP, SPIM5_A_MO, I2SOUT1_LRCK, SRCLKENAI0,
	    RES5, CONN_BPI_BUS16_OLAT5, DBG_MON_A10),
	PIN(11, GPIO11, 0, 0, 0x01, 0,
	    TP_URTS1_VLP, SPIM5_A_MI, I2SOUT1_DO, SRCLKENAI1,
	    PWM_vlp, RES6, DBG_MON_A11),
	PIN(12, GPIO12, 0, 0, 0x01, 0,
	    TP_UTXD1_VCORE, UTXD3, CLKM0, CMFLASH0,
	    RES5, ANT_SEL0, DBG_MON_B20),
	PIN(13, GPIO13, 0, 0, 0x01, 0,
	    TP_URXD1_VCORE, URXD3, CLKM1, CMFLASH1,
	    RES5, ANT_SEL1, DBG_MON_B21),
	PIN(14, GPIO14, 0, 0, 0x01, 0,
	    TP_UCTS1_VCORE, UCTS3, CLKM2, CMFLASH2,
	    RES5, ANT_SEL2, DBG_MON_B22),
	PIN(15, GPIO15, 0, 0, 0x01, 0,
	    TP_URTS1_VCORE, URTS3, CLKM3, CMVREF0,
	    RES5, ANT_SEL3, DBG_MON_B23),
	PIN(16, GPIO16, 0, 0, 0x01, 0,
	    PWM_0, UCTS2, DP_TX_HPD, CMVREF1,
	    MD32_0_GPIO0, ANT_SEL4, DBG_MON_B24),
	PIN(17, GPIO17, 0, 0, 0x01, 0,
	    PWM_1, URTS2, EDP_TX_HPD, CMVREF2,
	    MD32_1_GPIO0, PMSR_SMAP, DBG_MON_B25),
	PIN(18, CMMPDN0, 0, 0, 0x01, 0,
	    CMFLASH0, CMVREF3, UTXD2, DISP_PWM1,
	    I2SIN1_MCK, mbistreaden_trigger, DBG_MON_A12),
	PIN(19, CMMRST0, 0, 0, 0x01, 0,
	    CMFLASH1, CMVREF2, URXD2, USB_DRVVBUS_1P,
	    I2SIN1_BCK, mbistwriteen_trigger, DBG_MON_A13),
	PIN(20, CMMPDN1, 0, 0, 0x01, 0,
	    CMFLASH2, CMVREF1, UCTS2, PERSTN,
	    I2SIN1_LRCK, DMIC0_DAT1, DBG_MON_A14),
	PIN(21, CMMRST1, 0, 0, 0x01, 0,
	    CMFLASH3, CMVREF0, URTS2, CLKREQN,
	    I2SIN1_DI, DMIC1_DAT1, DBG_MON_A15),
	PIN(22, CMMCLK0, 0, 0, 0x01, 0,
	    CMMCLK0, TP_GPIO4_AO, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(23, CMMCLK1, 0, 0, 0x01, 0,
	    CMMCLK1, TP_GPIO5_AO, SSPM_UTXD_AO_VLP, PWM_vlp,
	    RES5, SRCLKENAI0, RES7),
	PIN(24, CMMCLK2, 0, 0, 0x01, 0,
	    CMMCLK2, TP_GPIO6_AO, SSPM_URXD_AO_VLP, WAKEN,
	    SPMI_P_TRIG_FLAG, SRCLKENAI1, RES7),
	PIN(25, DSI_LCM_RST, 0, 0, 0x01, 0,
	    LCM_RST, DP_TX_HPD, CMFLASH3, MD32_0_GPIO0,
	    USB_DRVVBUS_2P, RES6, RES7),
	PIN(26, DSI_DSI_TE, 0, 0, 0x01, 0,
	    DSI_TE, EDP_TX_HPD, CMVREF3, MD32_1_GPIO0,
	    USB_DRVVBUS_3P, RES6, RES7),
	PIN(27, DP_TX_HPD, 0, 0, 0x01, 0,
	    DP_TX_HPD, mbistreaden_trigger, MD32_0_GPIO0, TP_UCTS1_VCORE,
	    CMVREF4, EXTIF0_ACT, ANT_SEL0),
	PIN(28, EDP_TX_HPD, 0, 0, 0x01, 0,
	    EDP_TX_HPD, mbistwriteen_trigger, MD32_1_GPIO0, TP_URTS1_VCORE,
	    RES5, EXTIF0_PRI, ANT_SEL1),
	PIN(29, DISP_PWM0, 0, 0, 0x01, 0,
	    DISP_PWM0, MD32_1_TXD, SSPM_UTXD_AO_VCORE, RES4,
	    USB_DRVVBUS_4P, RES6, RES7),
	PIN(30, DISP_PWM1, 0, 0, 0x01, 0,
	    DISP_PWM1, MD32_1_RXD, SSPM_URXD_AO_VCORE, RES4,
	    PMSR_SMAP, EXTIF0_GNT_B, ANT_SEL2),
	PIN(31, UART0_TXD, 0, 0, 0x01, 0,
	    UTXD0, MD32_0_TXD, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(32, UART0_RXD, 0, 0, 0x01, 0,
	    URXD0, MD32_0_RXD, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(33, UART1_TXD, 0, 0, 0x01, 0,
	    UTXD1, VADSP_UTXD0, TP_UTXD1_VLP, MD32_1_TXD,
	    CONN_BGF_UART0_TXD, CONN_WIFI_TXD, RES7),
	PIN(34, UART1_RXD, 0, 0, 0x01, 0,
	    URXD1, VADSP_URXD0, TP_URXD1_VLP, MD32_1_RXD,
	    CONN_BGF_UART0_RXD, RES6, RES7),
	PIN(35, UART2_TXD, 0, 0, 0x01, 0,
	    UTXD2, UCTS1, TP_UCTS1_VLP, SSPM_UTXD_AO_VLP,
	    VADSP_UTXD0, CONN_BT_TXD, RES7),
	PIN(36, UART2_RXD, 0, 0, 0x01, 0,
	    URXD2, URTS1, TP_URTS1_VLP, SSPM_URXD_AO_VLP,
	    VADSP_URXD0, RES6, RES7),
	PIN(37, UART3_TXD, 0, 0, 0x01, 0,
	    UTXD3, UCTS0, TP_UTXD1_VCORE, SSPM_UTXD_AO_VCORE,
	    RES5, MD32_0_TXD, CONN_BGF_UART0_TXD),
	PIN(38, UART3_RXD, 0, 0, 0x01, 0,
	    URXD3, URTS0, TP_URXD1_VCORE, SSPM_URXD_AO_VCORE,
	    RES5, MD32_0_RXD, CONN_BGF_UART0_RXD),
	PIN(39, JTMS, 0, 0, 0x01, 0,
	    JTMS_SEL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(40, JTCK, 0, 0, 0x01, 0,
	    JTCK_SEL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(41, JTDI, 0, 0, 0x01, 0,
	    JTDI_SEL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(42, JTDO, 0, 0, 0x01, 0,
	    JTDO_SEL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(43, JTRST, 0, 0, 0x01, 0,
	    JTRSTn_SEL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(44, KPCOL0, 0, 0, 0x01, 0,
	    KPCOL0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(45, KPCOL1, 0, 0, 0x01, 0,
	    KPCOL1, TP_GPIO0_AO, SRCLKENAI1, RES4,
	    RES5, RES6, DBG_MON_A31),
	PIN(46, KPROW0, 0, 0, 0x01, 0,
	    KPROW0, TP_GPIO1_AO, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(47, KPROW1, 0, 0, 0x01, 0,
	    KPROW1, TP_GPIO2_AO, SRCLKENAI0, RES4,
	    RES5, RES6, DBG_MON_A32),
	PIN(48, PCIE_WAKE_N, 0, 0, 0x01, 0,
	    WAKEN, TP_GPIO3_AO, SPMI_P_TRIG_FLAG, RES4,
	    RES5, RES6, RES7),
	PIN(49, PCIE_PERESET_N, 0, 0, 0x01, 0,
	    PERSTN, MD32_0_GPIO0, UFS_MPHY_SCL, RES4,
	    RES5, RES6, ANT_SEL3),
	PIN(50, PCIE_CLKREQ_N, 0, 0, 0x01, 0,
	    CLKREQN, MD32_1_GPIO0, UFS_MPHY_SDA, RES4,
	    RES5, RES6, ANT_SEL4),
	PIN(51, SCP_SCL0, 0, 0, 0x01, 0,
	    SCP_SCL0, SCL0, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(52, SCP_SDA0, 0, 0, 0x01, 0,
	    SCP_SDA0, SDA0, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(53, SCP_SCL1, 0, 0, 0x01, 0,
	    SCP_SCL1, SCL1, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(54, SCP_SDA1, 0, 0, 0x01, 0,
	    SCP_SDA1, SDA1, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(55, SCL2, 0, 0, 0x01, 0,
	    SCL2, UFS_MPHY_SCL, SSUSB_U2SIF_SCL, RES4,
	    RES5, RES6, RES7),
	PIN(56, SDA2, 0, 0, 0x01, 0,
	    SDA2, UFS_MPHY_SDA, SSUSB_U2SIF_SDA, RES4,
	    RES5, RES6, RES7),
	PIN(57, SCL3, 0, 0, 0x01, 0,
	    SCL3, PCIE_PHY_I2C_SCL, SSUSB_U2SIF_SCL_1P, RES4,
	    RES5, RES6, RES7),
	PIN(58, SDA3, 0, 0, 0x01, 0,
	    SDA3, PCIE_PHY_I2C_SDA, SSUSB_U2SIF_SDA_1P, RES4,
	    RES5, RES6, RES7),
	PIN(59, SCL4, 0, 0, 0x01, 0,
	    SCL4, SSUSB_U3PHY_I2C_SCL, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(60, SDA4, 0, 0, 0x01, 0,
	    SDA4, SSUSB_U3PHY_I2C_SDA, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(61, SCL5, 0, 0, 0x01, 0,
	    SCL5, SSPXTP_U3PHY_I2C_SCL, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(62, SDA5, 0, 0, 0x01, 0,
	    SDA5, SSPXTP_U3PHY_I2C_SDA, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(63, SCL6, 0, 0, 0x01, 0,
	    SCL6, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(64, SDA6, 0, 0, 0x01, 0,
	    SDA6, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(65, SCL7, 0, 0, 0x01, 0,
	    SCL7, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(66, SDA7, 0, 0, 0x01, 0,
	    SDA7, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(67, SCL8, 0, 0, 0x01, 0,
	    SCL8, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(68, SDA8, 0, 0, 0x01, 0,
	    SDA8, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(69, SPIM0_CSB, 0, 0, 0x01, 0,
	    SPIM0_CSB, SCP_SPI0_CS, SPM_JTAG_TMS_VCORE, VADSP_JTAG0_TMS,
	    SPM_JTAG_TMS, SSPM_JTAG_TMS_VLP, SCP_JTAG0_TMS_VLP),
	PIN(70, SPIM0_CLK, 0, 0, 0x01, 0,
	    SPIM0_CLK, SCP_SPI0_CK, SPM_JTAG_TCK_VCORE, VADSP_JTAG0_TCK,
	    SPM_JTAG_TCK, SSPM_JTAG_TCK_VLP, SCP_JTAG0_TCK_VLP),
	PIN(71, SPIM0_MOSI, 0, 0, 0x01, 0,
	    SPIM0_MO, SCP_SPI0_MO, SPM_JTAG_TDI_VCORE, VADSP_JTAG0_TDI,
	    SPM_JTAG_TDI, SSPM_JTAG_TDI_VLP, SCP_JTAG0_TDI_VLP),
	PIN(72, SPIM0_MISO, 0, 0, 0x01, 0,
	    SPIM0_MI, SCP_SPI0_MI, SPM_JTAG_TDO_VCORE, VADSP_JTAG0_TDO,
	    SPM_JTAG_TDO, SSPM_JTAG_TDO_VLP, SCP_JTAG0_TDO_VLP),
	PIN(73, SPIM1_CSB, 0, 0, 0x01, 0,
	    SPIM1_CSB, SCP_SPI1_CS, SPM_JTAG_TRSTN_VCORE, VADSP_JTAG0_TRSTN,
	    SPM_JTAG_TRSTN, SSPM_JTAG_TRSTN_VLP, SCP_JTAG0_TRSTN_VLP),
	PIN(74, SPIM1_CLK, 0, 0, 0x01, 0,
	    SPIM1_CLK, SCP_SPI1_CK, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(75, SPIM1_MOSI, 0, 0, 0x01, 0,
	    SPIM1_MO, SCP_SPI1_MO, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(76, SPIM1_MISO, 0, 0, 0x01, 0,
	    SPIM1_MI, SCP_SPI1_MI, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(77, SPIM2_CSB, 0, 0, 0x01, 0,
	    SPIM2_CSB, PCM0_SYNC, SSUSB_U2SIF_SCL, RES4,
	    RES5, RES6, DBG_MON_A27),
	PIN(78, SPIM2_CLK, 0, 0, 0x01, 0,
	    SPIM2_CLK, PCM0_CLK, SSUSB_U2SIF_SDA, RES4,
	    RES5, RES6, DBG_MON_A28),
	PIN(79, SPIM2_MOSI, 0, 0, 0x01, 0,
	    SPIM2_MO, PCM0_DO, SSUSB_U2SIF_SCL_1P, RES4,
	    RES5, RES6, DBG_MON_A29),
	PIN(80, SPIM2_MISO, 0, 0, 0x01, 0,
	    SPIM2_MI, PCM0_DI, SSUSB_U2SIF_SDA_1P, RES4,
	    RES5, RES6, DBG_MON_A30),
	PIN(81, USB0_IDDIG, 0, 0, 0x01, 0,
	    IDDIG, RES2, RES3, RES4,
	    RES5, RES6, DBG_MON_B32),
	PIN(82, USB0_DRV_VBUS, 0, 0, 0x01, 0,
	    USB_DRVVBUS, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(83, USB0_VBUS_VALID, 0, 0, 0x01, 0,
	    VBUSVALID, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(84, USB1_DRV_VBUS, 0, 0, 0x01, 0,
	    USB_DRVVBUS_1P, RES2, RES3, RES4,
	    RES5, RES6, DBG_MON_A16),
	PIN(85, USB2_DRV_VBUS, 0, 0, 0x01, 0,
	    USB_DRVVBUS_2P, RES2, RES3, RES4,
	    RES5, RES6, DBG_MON_A17),
	PIN(86, USB3_DRV_VBUS, 0, 0, 0x01, 0,
	    USB_DRVVBUS_3P, RES2, RES3, RES4,
	    RES5, RES6, DBG_MON_A18),
	PIN(87, USB4_DRV_VBUS, 0, 0, 0x01, 0,
	    USB_DRVVBUS_4P, RES2, RES3, RES4,
	    RES5, CMVREF4, DBG_MON_A19),
	PIN(88, PWRAP_SPI_CSN, 0, 0, 0x01, 0,
	    PWRAP_SPI0_CSN, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(89, PWRAP_SPI_CK, 0, 0, 0x01, 0,
	    PWRAP_SPI0_CK, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(90, PWRAP_SPI_MO, 0, 0, 0x01, 0,
	    PWRAP_SPI0_MO, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(91, PWRAP_SPI_MI, 0, 0, 0x01, 0,
	    PWRAP_SPI0_MI, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(92, PMIC_SRCLKENA0, 0, 0, 0x01, 0,
	    SRCLKENA0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(93, PMIC_SRCLKENA1, 0, 0, 0x01, 0,
	    SRCLKENA1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(94, SCP_VREQ_VAO, 0, 0, 0x01, 0,
	    SCP_VREQ_VAO, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(95, PMIC_RTC32K_CK, 0, 0, 0x01, 0,
	    RTC32K_CK, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(96, PMIC_WATCHDOG, 0, 0, 0x01, 0,
	    WATCHDOG, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(97, AUD_CLK_MOSI, 0, 0, 0x01, 0,
	    AUD_CLK_MOSI, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(98, AUD_SYNC_MOSI, 0, 0, 0x01, 0,
	    AUD_SYNC_MOSI, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(99, AUD_DAT_MOSI0, 0, 0, 0x01, 0,
	    AUD_DAT_MOSI0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(100, AUD_DAT_MOSI1, 0, 0, 0x01, 0,
	    AUD_DAT_MOSI1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(101, AUD_DAT_MISO0, 0, 0, 0x01, 0,
	    AUD_DAT_MISO0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(102, AUD_DAT_MISO1, 0, 0, 0x01, 0,
	    AUD_DAT_MISO1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(103, I2SIN0_MCK, 0, 0, 0x01, 0,
	    I2SIN0_MCK, SPIM3_B_CSB, APU_JTAG_TMS, SCP_JTAG0_TMS_VCORE,
	    CONN_WF_MCU_TMS, SSPM_JTAG_TMS_VCORE, IPU_JTAG_TMS),
	PIN(104, I2SIN0_BCK, 0, 0, 0x01, 0,
	    I2SIN0_BCK, SPIM3_B_CLK, APU_JTAG_TCK, SCP_JTAG0_TCK_VCORE,
	    CONN_WF_MCU_TCK, SSPM_JTAG_TCK_VCORE, IPU_JTAG_TCK),
	PIN(105, I2SIN0_LRCK, 0, 0, 0x01, 0,
	    I2SIN0_LRCK, SPIM3_B_MO, APU_JTAG_TDI, SCP_JTAG0_TDI_VCORE,
	    CONN_WF_MCU_TDI, SSPM_JTAG_TDI_VCORE, IPU_JTAG_TDI),
	PIN(106, I2SIN0_DI, 0, 0, 0x01, 0,
	    I2SIN0_DI, SPIM3_B_MI, APU_JTAG_TDO, SCP_JTAG0_TDO_VCORE,
	    CONN_WF_MCU_TDO, SSPM_JTAG_TDO_VCORE, IPU_JTAG_TDO),
	PIN(107, I2SOUT0_MCK, 0, 0, 0x01, 0,
	    I2SOUT0_MCK, SPIM4_B_CSB, APU_JTAG_TRST, SCP_JTAG0_TRSTN_VCORE,
	    CONN_WF_MCU_TRST_B, SSPM_JTAG_TRSTN_VCORE, IPU_JTAG_TRST),
	PIN(108, I2SOUT0_BCK, 0, 0, 0x01, 0,
	    I2SOUT0_BCK, SPIM4_B_CLK, EXTIF0_ACT, SPM_JTAG_TMS_VCORE,
	    RES5, CLKM2, DBG_MON_A20),
	PIN(109, I2SOUT0_LRCK, 0, 0, 0x01, 0,
	    I2SOUT0_LRCK, SPIM4_B_MO, EXTIF0_PRI, SPM_JTAG_TCK_VCORE,
	    RES5, CLKM3, DBG_MON_A21),
	PIN(110, I2SOUT0_DO, 0, 0, 0x01, 0,
	    I2SOUT0_DO, SPIM4_B_MI, EXTIF0_GNT_B, SPM_JTAG_TDI_VCORE,
	    RES5, RES6, DBG_MON_A22),
	PIN(111, DMIC0_CLK, 0, 0, 0x01, 0,
	    DMIC0_CLK, I2SIN1_MCK, I2SOUT1_MCK, SPM_JTAG_TDO_VCORE,
	    RES5, CONN_MIPI0_SDATA, DBG_MON_A23),
	PIN(112, DMIC0_DAT0, 0, 0, 0x01, 0,
	    DMIC0_DAT0, I2SIN1_BCK, I2SOUT1_BCK, SPM_JTAG_TRSTN_VCORE,
	    RES5, CONN_MIPI0_SCLK, DBG_MON_A24),
	PIN(113, DMIC1_CLK, 0, 0, 0x01, 0,
	    DMIC1_CLK, I2SIN1_LRCK, I2SOUT1_LRCK, PMSR_SMAP,
	    RES5, CONN_MIPI1_SDATA, DBG_MON_A25),
	PIN(114, DMIC1_DAT0, 0, 0, 0x01, 0,
	    DMIC1_DAT0, I2SIN1_DI, I2SOUT1_DO, RES4,
	    RES5, CONN_MIPI1_SCLK, DBG_MON_A26),
	PIN(115, PCM_CLK, 0, 0, 0x01, 0,
	    PCM0_CLK, USB_DRVVBUS_1P, PCIE_PHY_I2C_SCL, SSUSB_U3PHY_I2C_SCL,
	    RES5, CMFLASH0, EXTIF0_ACT),
	PIN(116, PCM_SYNC, 0, 0, 0x01, 0,
	    PCM0_SYNC, USB_DRVVBUS_2P, PCIE_PHY_I2C_SDA, SSUSB_U3PHY_I2C_SDA,
	    RES5, CMFLASH1, EXTIF0_PRI),
	PIN(117, PCM_DI, 0, 0, 0x01, 0,
	    PCM0_DI, USB_DRVVBUS_3P, DP_TX_HPD, SSPXTP_U3PHY_I2C_SCL,
	    RES5, CMVREF0, EXTIF0_GNT_B),
	PIN(118, PCM_DO, 0, 0, 0x01, 0,
	    PCM0_DO, USB_DRVVBUS_4P, EDP_TX_HPD, SSPXTP_U3PHY_I2C_SDA,
	    RES5, CMVREF1, RES7),
	PIN(119, GBE_TXD3, 0, 0, 0x01, 0,
	    GBE_TXD3, DMIC0_CLK, LVTS_FOUT, CONN_BGF_MCU_TMS,
	    UDI_TMS, ANT_SEL5, DBG_MON_B0),
	PIN(120, GBE_TXD2, 0, 0, 0x01, 0,
	    GBE_TXD2, DMIC0_DAT0, LVTS_SDO, CONN_BGF_MCU_TCK,
	    UDI_TCK, ANT_SEL6, DBG_MON_B1),
	PIN(121, GBE_TXD1, 0, 0, 0x01, 0,
	    GBE_TXD1, DMIC0_DAT1, LVTS_26M, CONN_BGF_MCU_TDI,
	    UDI_TDI, ANT_SEL7, DBG_MON_B2),
	PIN(122, GBE_TXD0, 0, 0, 0x01, 0,
	    GBE_TXD0, DMIC1_CLK, LVTS_SCF, CONN_BGF_MCU_TDO,
	    UDI_TDO, ANT_SEL8, DBG_MON_B3),
	PIN(123, GBE_RXD3, 0, 0, 0x01, 0,
	    GBE_RXD3, DMIC1_DAT0, LVTS_SCK, CONN_BGF_MCU_TRST_B,
	    UDI_NTRST, ANT_SEL9, DBG_MON_B4),
	PIN(124, GBE_RXD2, 0, 0, 0x01, 0,
	    GBE_RXD2, DMIC1_DAT1, LVTS_SDI, CONN_WF_MCU_TMS,
	    SCP_JTAG0_TMS_VCORE, ANT_SEL10, DBG_MON_B5),
	PIN(125, GBE_RXD1, 0, 0, 0x01, 0,
	    GBE_RXD1, CLKM2, RES3, CONN_WF_MCU_TCK,
	    SCP_JTAG0_TCK_VCORE, ANT_SEL11, DBG_MON_B6),
	PIN(126, GBE_RXD0, 0, 0, 0x01, 0,
	    GBE_RXD0, CLKM3, RES3, CONN_WF_MCU_TDI,
	    SCP_JTAG0_TDI_VCORE, ANT_SEL12, DBG_MON_B7),
	PIN(127, GBE_TXC, 0, 0, 0x01, 0,
	    GBE_TXC, I2SIN1_MCK, RES3, CONN_WF_MCU_TDO,
	    SCP_JTAG0_TDO_VCORE, ANT_SEL13, DBG_MON_B8),
	PIN(128, GBE_RXC, 0, 0, 0x01, 0,
	    GBE_RXC, I2SIN1_BCK, RES3, CONN_WF_MCU_TRST_B,
	    SCP_JTAG0_TRSTN_VCORE, ANT_SEL14, DBG_MON_B9),
	PIN(129, GBE_RXDV, 0, 0, 0x01, 0,
	    GBE_RXDV, I2SIN1_LRCK, RES3, CONN_BGF_MCU_AICE_TMSC,
	    IPU_JTAG_TMS, ANT_SEL15, DBG_MON_B10),
	PIN(130, GBE_TXEN, 0, 0, 0x01, 0,
	    GBE_TXEN, I2SIN1_DI, RES3, CONN_BGF_MCU_AICE_TCKC,
	    IPU_JTAG_TCK, ANT_SEL16, DBG_MON_B11),
	PIN(131, GBE_MDC, 0, 0, 0x01, 0,
	    GBE_MDC, CLKM0, mbistreaden_trigger, CONN_BGF_UART0_TXD,
	    IPU_JTAG_TDI, ANT_SEL17, DBG_MON_B12),
	PIN(132, GBE_MDIO, 0, 0, 0x01, 0,
	    GBE_MDIO, CLKM1, mbistwriteen_trigger, CONN_BGF_UART0_RXD,
	    IPU_JTAG_TDO, ANT_SEL18, DBG_MON_B13),
	PIN(133, GBE_TXER, 0, 0, 0x01, 0,
	    GBE_TXER, GBE_AUX_PPS2, RES3, CONN_BT_TXD,
	    IPU_JTAG_TRST, ANT_SEL19, DBG_MON_B14),
	PIN(134, GBE_RXER, 0, 0, 0x01, 0,
	    GBE_RXER, GBE_AUX_PPS3, MCUPM_JTAG_TMS, CONN_WF_MCU_AICE_TMSC,
	    APU_JTAG_TMS, ANT_SEL20, DBG_MON_B15),
	PIN(135, GBE_COL, 0, 0, 0x01, 0,
	    GBE_COL, I2SOUT1_MCK, MCUPM_JTAG_TCK, CONN_WF_MCU_AICE_TCKC,
	    APU_JTAG_TCK, ANT_SEL21, DBG_MON_B16),
	PIN(136, GBE_INTR, 0, 0, 0x01, 0,
	    GBE_INTR, I2SOUT1_BCK, MCUPM_JTAG_TDI, CONN_WIFI_TXD,
	    APU_JTAG_TDI, PWM_0, DBG_MON_B17),
	PIN(137, GBE_AUX_PPS0, 0, 0, 0x01, 0,
	    GBE_AUX_PPS0, I2SOUT1_LRCK, MCUPM_JTAG_TDO, DP_TX_HPD,
	    APU_JTAG_TDO, PWM_1, DBG_MON_B18),
	PIN(138, GBE_AUX_PPS1, 0, 0, 0x01, 0,
	    GBE_AUX_PPS1, I2SOUT1_DO, MCUPM_JTAG_TRSTN, EDP_TX_HPD,
	    APU_JTAG_TRST, PWM_2, DBG_MON_B19),
	PIN(139, CONN_TOP_CLK, 0, 0, 0x01, 0,
	    CONN_TOP_CLK, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(140, CONN_TOP_DATA, 0, 0, 0x01, 0,
	    CONN_TOP_DATA, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(141, CONN_BT_CLK, 0, 0, 0x01, 0,
	    CONN_BT_CLK, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(142, CONN_BT_DATA, 0, 0, 0x01, 0,
	    CONN_BT_DATA, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(143, CONN_HRST_B, 0, 0, 0x01, 0,
	    CONN_HRST_B, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(144, CONN_WB_PTA, 0, 0, 0x01, 0,
	    CONN_WB_PTA, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(145, CONN_WF_CTRL0, 0, 0, 0x01, 0,
	    CONN_WF_CTRL0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(146, CONN_WF_CTRL1, 0, 0, 0x01, 0,
	    CONN_WF_CTRL1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(147, CONN_WF_CTRL2, 0, 0, 0x01, 0,
	    CONN_WF_CTRL2, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(148, CONN_WF_CTRL3, 0, 0, 0x01, 0,
	    CONN_WF_CTRL3, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(149, CONN_WF_CTRL4, 0, 0, 0x01, 0,
	    CONN_WF_CTRL4, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(150, SPINOR_CK, 0, 0, 0x01, 0,
	    SPINOR_CK, DMIC0_CLK, DP_TX_HPD, PWM_0,
	    CONN_BPI_BUS17_ANT0, LVTS_FOUT, DBG_MON_B26),
	PIN(151, SPINOR_CS, 0, 0, 0x01, 0,
	    SPINOR_CS, DMIC0_DAT0, EDP_TX_HPD, PWM_1,
	    CONN_BPI_BUS18_ANT1, LVTS_SDO, DBG_MON_B27),
	PIN(152, SPINOR_IO0, 0, 0, 0x01, 0,
	    SPINOR_IO0, DMIC0_DAT1, UTXD2, USB_DRVVBUS_1P,
	    CONN_BPI_BUS19_ANT2, LVTS_26M, DBG_MON_B28),
	PIN(153, SPINOR_IO1, 0, 0, 0x01, 0,
	    SPINOR_IO1, DMIC1_CLK, UCTS2, USB_DRVVBUS_2P,
	    CONN_BPI_BUS20_ANT3, LVTS_SCF, DBG_MON_B29),
	PIN(154, SPINOR_IO2, 0, 0, 0x01, 0,
	    SPINOR_IO2, DMIC1_DAT0, URTS2, USB_DRVVBUS_3P,
	    CONN_BPI_BUS21_ANT4, LVTS_SCK, DBG_MON_B30),
	PIN(155, SPINOR_IO3, 0, 0, 0x01, 0,
	    SPINOR_IO3, DMIC1_DAT1, URXD2, USB_DRVVBUS_4P,
	    DISP_PWM1, LVTS_SDI, DBG_MON_B31),
	PIN(156, EMMC_DAT7, 0, 0, 0x01, 0,
	    MSDC0_DAT7, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(157, EMMC_DAT6, 0, 0, 0x01, 0,
	    MSDC0_DAT6, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(158, EMMC_DAT5, 0, 0, 0x01, 0,
	    MSDC0_DAT5, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(159, EMMC_DAT4, 0, 0, 0x01, 0,
	    MSDC0_DAT4, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(160, EMMC_RSTB, 0, 0, 0x01, 0,
	    MSDC0_RSTB, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(161, EMMC_CMD, 0, 0, 0x01, 0,
	    MSDC0_CMD, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(162, EMMC_CLK, 0, 0, 0x01, 0,
	    MSDC0_CLK, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(163, EMMC_DAT3, 0, 0, 0x01, 0,
	    MSDC0_DAT3, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(164, EMMC_DAT2, 0, 0, 0x01, 0,
	    MSDC0_DAT2, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(165, EMMC_DAT1, 0, 0, 0x01, 0,
	    MSDC0_DAT1, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(166, EMMC_DAT0, 0, 0, 0x01, 0,
	    MSDC0_DAT0, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(167, EMMC_DSL, 0, 0, 0x01, 0,
	    MSDC0_DSL, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(168, MSDC1_CMD, 0, 0, 0x01, 0,
	    MSDC1_CMD, CONN_WF_MCU_AICE_TMSC, UCTS1, UDI_TMS,
	    SSPM_JTAG_TMS_VCORE, MCUPM_JTAG_TMS, CONN_BGF_MCU_TMS),
	PIN(169, MSDC1_CLK, 0, 0, 0x01, 0,
	    MSDC1_CLK, CONN_WF_MCU_AICE_TCKC, URTS1, UDI_TCK,
	    SSPM_JTAG_TCK_VCORE, MCUPM_JTAG_TCK, CONN_BGF_MCU_TCK),
	PIN(170, MSDC1_DAT0, 0, 0, 0x01, 0,
	    MSDC1_DAT0, SPIM5_B_CSB, UCTS2, UDI_TDI,
	    SSPM_JTAG_TDI_VCORE, MCUPM_JTAG_TDI, CONN_BGF_MCU_TDI),
	PIN(171, MSDC1_DAT1, 0, 0, 0x01, 0,
	    MSDC1_DAT1, SPIM5_B_CLK, URTS2, UDI_TDO,
	    SSPM_JTAG_TDO_VCORE, MCUPM_JTAG_TDO, CONN_BGF_MCU_TDO),
	PIN(172, MSDC1_DAT2, 0, 0, 0x01, 0,
	    MSDC1_DAT2, SPIM5_B_MO, UCTS3, UDI_NTRST,
	    SSPM_JTAG_TRSTN_VCORE, MCUPM_JTAG_TRSTN, CONN_BGF_MCU_TRST_B),
	PIN(173, MSDC1_DAT3, 0, 0, 0x01, 0,
	    MSDC1_DAT3, SPIM5_B_MI, URTS3, CLKM0,
	    PWM_2, RES6, RES7),
	PIN(174, MSDC2_CMD, 0, 0, 0x01, 0,
	    MSDC2_CMD, CONN_BGF_MCU_AICE_TMSC, UTXD1, VADSP_JTAG0_TMS,
	    SSPM_JTAG_TMS_VLP, SPM_JTAG_TMS, SCP_JTAG0_TMS_VLP),
	PIN(175, MSDC2_CLK, 0, 0, 0x01, 0,
	    MSDC2_CLK, CONN_BGF_MCU_AICE_TCKC, URXD1, VADSP_JTAG0_TCK,
	    SSPM_JTAG_TCK_VLP, SPM_JTAG_TCK, SCP_JTAG0_TCK_VLP),
	PIN(176, MSDC2_DAT0, 0, 0, 0x01, 0,
	    MSDC2_DAT0, SRCLKENAI0, UTXD2, VADSP_JTAG0_TDI,
	    SSPM_JTAG_TDI_VLP, SPM_JTAG_TDI, SCP_JTAG0_TDI_VLP),
	PIN(177, MSDC2_DAT1, 0, 0, 0x01, 0,
	    MSDC2_DAT1, SRCLKENAI1, URXD2, VADSP_JTAG0_TDO,
	    SSPM_JTAG_TDO_VLP, SPM_JTAG_TDO, SCP_JTAG0_TDO_VLP),
	PIN(178, MSDC2_DAT2, 0, 0, 0x01, 0,
	    MSDC2_DAT2, RES2, UTXD3, VADSP_JTAG0_TRSTN,
	    SSPM_JTAG_TRSTN_VLP, SPM_JTAG_TRSTN, SCP_JTAG0_TRSTN_VLP),
	PIN(179, MSDC2_DAT3, 0, 0, 0x01, 0,
	    MSDC2_DAT3, RES2, URXD3, CLKM1,
	    PWM_vlp, RES6, TP_GPIO7_AO),
	PIN(180, SPMI_P_SCL, 0, 0, 0x01, 0,
	    SPMI_P_SCL, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(181, SPMI_P_SDA, 0, 0, 0x01, 0,
	    SPMI_P_SDA, RES2, RES3, RES4,
	    RES5, RES6, RES7),
	PIN(182, EMI_RESETB, 0, 0, 0x01, 0,
	    DDR_PAD_RRESETB, RES2, RES3, RES4,
	    RES5, RES6, RES7),
};

static struct gpio_regs *const mtk_gpio = (void *)GPIO_BASE;

#endif /* __SOC_MEDIATEK_MT8189_INCLUDE_SOC_GPIO_H__ */
