; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes='move-auto-init' -verify-memoryssa | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"

; In that case, the store to %val happens before the fence and cannot go past
; it.
define void @foo(i32 %x) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[VAL:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 -1431655766, ptr [[VAL]], align 4, !annotation !0
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[X:%.*]], 0
; CHECK-NEXT:    fence acquire
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @dump(ptr [[VAL]])
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %val = alloca i32, align 4
  store i32 -1431655766, ptr %val, align 4, !annotation !0
  %tobool = icmp ne i32 %x, 0
  fence acquire
  br i1 %tobool, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void @dump(ptr %val)
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret void
}

; In that case, the store to %val happens after the fence and it is moved within
; the true branch as expected.
define void @bar(i32 %x) {
; CHECK-LABEL: @bar(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[VAL:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[X:%.*]], 0
; CHECK-NEXT:    fence acquire
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 -1431655766, ptr [[VAL]], align 4, !annotation !0
; CHECK-NEXT:    call void @dump(ptr [[VAL]])
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %val = alloca i32, align 4
  %tobool = icmp ne i32 %x, 0
  fence acquire
  store i32 -1431655766, ptr %val, align 4, !annotation !0
  br i1 %tobool, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  call void @dump(ptr %val)
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret void
}

declare void @dump(ptr)

!0 = !{!"auto-init"}
