; RUN: llc %s -stop-after=finalize-isel -o - \
; RUN: | FileCheck %s
;;
;; Backend counterpart to ../Generic/dbg-assign-loop-unroll.  This IR was
;; generated by running `opt -loop-unroll -S` on the IR in that test.
;;
;; Check that the backend can handle a mesh of dbg.assign and linked
;; instructions.
;;
;; Generated from the following source:
;; void esc(int*);
;; void d(int p) {
;;   for (int i = 0; i < 2; ++i) {
;;     p = i;
;;     esc(&p);
;;   }
;; }

; CHECK: ![[p:[0-9]+]] = !DILocalVariable(name: "p",

; CHECK: stack:
; CHECK-NEXT: - { id: 0, name: p.addr, type: default, offset: 0, size: 4, alignment: 4,
; CHECK-NEXT:     stack-id: default, callee-saved-register: '', callee-saved-restored: true,
; CHECK-NEXT:     debug-info-variable: '![[p]]', debug-info-expression: '!DIExpression()',
; CHECK-NEXT:     debug-info-location: '!{{.+}}' }

target triple = "x86_64-unknown-linux-gnu"

define dso_local void @_Z1di(i32 %p) local_unnamed_addr !dbg !7 {
entry:
  %p.addr = alloca i32, align 4
  store i32 %p, ptr %p.addr, align 4, !DIAssignID !19
  call void @llvm.dbg.assign(metadata i32 %p, metadata !12, metadata !DIExpression(), metadata !19, metadata ptr %p.addr, metadata !DIExpression()), !dbg !20
  call void @llvm.dbg.assign(metadata i32 0, metadata !13, metadata !DIExpression(), metadata !21, metadata ptr undef, metadata !DIExpression()), !dbg !22
  br label %for.body, !dbg !23

for.body:                                         ; preds = %entry
  store i32 0, ptr %p.addr, align 4, !dbg !24, !DIAssignID !27
  call void @llvm.dbg.assign(metadata i32 0, metadata !12, metadata !DIExpression(), metadata !27, metadata ptr %p.addr, metadata !DIExpression()), !dbg !24
  call void @_Z3escPi(ptr nonnull %p.addr), !dbg !28
  call void @llvm.dbg.assign(metadata i32 1, metadata !13, metadata !DIExpression(), metadata !29, metadata ptr undef, metadata !DIExpression()), !dbg !30
  store i32 1, ptr %p.addr, align 4, !dbg !24, !DIAssignID !27
  call void @llvm.dbg.assign(metadata i32 1, metadata !12, metadata !DIExpression(), metadata !27, metadata ptr %p.addr, metadata !DIExpression()), !dbg !24
  call void @_Z3escPi(ptr nonnull %p.addr), !dbg !28
  call void @llvm.dbg.assign(metadata i32 2, metadata !13, metadata !DIExpression(), metadata !29, metadata ptr undef, metadata !DIExpression()), !dbg !30
  ret void, !dbg !31
}

declare !dbg !32 dso_local void @_Z3escPi(ptr) local_unnamed_addr
declare void @llvm.dbg.assign(metadata, metadata, metadata, metadata, metadata, metadata)

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3, !4, !5, !1000}
!llvm.ident = !{!6}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus_14, file: !1, producer: "clang version 12.0.0", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, splitDebugInlining: false, nameTableKind: None)
!1 = !DIFile(filename: "test.cpp", directory: "/")
!2 = !{}
!3 = !{i32 7, !"Dwarf Version", i32 4}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = !{i32 1, !"wchar_size", i32 4}
!6 = !{!"clang version 12.0.0"}
!7 = distinct !DISubprogram(name: "d", linkageName: "_Z1di", scope: !1, file: !1, line: 2, type: !8, scopeLine: 2, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, retainedNodes: !11)
!8 = !DISubroutineType(types: !9)
!9 = !{null, !10}
!10 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!11 = !{!12, !13}
!12 = !DILocalVariable(name: "p", arg: 1, scope: !7, file: !1, line: 2, type: !10)
!13 = !DILocalVariable(name: "i", scope: !14, file: !1, line: 3, type: !10)
!14 = distinct !DILexicalBlock(scope: !7, file: !1, line: 3, column: 3)
!19 = distinct !DIAssignID()
!20 = !DILocation(line: 0, scope: !7)
!21 = distinct !DIAssignID()
!22 = !DILocation(line: 3, column: 12, scope: !14)
!23 = !DILocation(line: 3, column: 3, scope: !14)
!24 = !DILocation(line: 4, column: 7, scope: !25)
!25 = distinct !DILexicalBlock(scope: !26, file: !1, line: 3, column: 31)
!26 = distinct !DILexicalBlock(scope: !14, file: !1, line: 3, column: 3)
!27 = distinct !DIAssignID()
!28 = !DILocation(line: 5, column: 5, scope: !25)
!29 = distinct !DIAssignID()
!30 = !DILocation(line: 3, column: 26, scope: !26)
!31 = !DILocation(line: 7, column: 1, scope: !7)
!32 = !DISubprogram(name: "esc", linkageName: "_Z3escPi", scope: !1, file: !1, line: 1, type: !33, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !2)
!33 = !DISubroutineType(types: !34)
!34 = !{null, !35}
!35 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !10, size: 64)
!1000 = !{i32 7, !"debug-info-assignment-tracking", i1 true}
