; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+zve32x,+zvl128b -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK-RV32

@a = external global <4 x i32>
@b = external global <4 x i32>
@c = external global <4 x i32>

define void @foo_lmul1() nounwind #0 {
; CHECK-RV32-LABEL: foo_lmul1:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -32
; CHECK-RV32-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vs1r.v v9, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, %hi(a)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(a)
; CHECK-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-RV32-NEXT:    vle32.v v8, (a0)
; CHECK-RV32-NEXT:    lui a0, %hi(b)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(b)
; CHECK-RV32-NEXT:    vle32.v v9, (a0)
; CHECK-RV32-NEXT:    vadd.vv v8, v9, v8
; CHECK-RV32-NEXT:    lui a0, %hi(c)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(c)
; CHECK-RV32-NEXT:    vse32.v v8, (a0)
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vl1r.v v9, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 32
; CHECK-RV32-NEXT:    mret
  %1 = load <4 x i32>, ptr @a
  %2 = load <4 x i32>, ptr @b
  %add = add nsw <4 x i32> %2, %1
  store <4 x i32> %add, ptr @c
  ret void
}

@d = external global <8 x i32>
@e = external global <8 x i32>
@f = external global <8 x i32>

define void @foo_lmul2() nounwind #0 {
; CHECK-RV32-LABEL: foo_lmul2:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -32
; CHECK-RV32-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v9, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v10, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vs1r.v v11, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, %hi(d)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(d)
; CHECK-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-RV32-NEXT:    vle32.v v8, (a0)
; CHECK-RV32-NEXT:    lui a0, %hi(e)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(e)
; CHECK-RV32-NEXT:    vle32.v v10, (a0)
; CHECK-RV32-NEXT:    vadd.vv v8, v10, v8
; CHECK-RV32-NEXT:    lui a0, %hi(f)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(f)
; CHECK-RV32-NEXT:    vse32.v v8, (a0)
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v9, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v10, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vl1r.v v11, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 32
; CHECK-RV32-NEXT:    mret
  %1 = load <8 x i32>, ptr @d
  %2 = load <8 x i32>, ptr @e
  %add = add nsw <8 x i32> %2, %1
  store <8 x i32> %add, ptr @f
  ret void
}

@g = external global <16 x i32>
@h = external global <16 x i32>
@i = external global <16 x i32>

define void @foo_lmul4() nounwind #0 {
; CHECK-RV32-LABEL: foo_lmul4:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -32
; CHECK-RV32-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 3
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v9, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    slli a1, a0, 2
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v10, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v11, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v12, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v13, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v14, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vs1r.v v15, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, %hi(g)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(g)
; CHECK-RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-RV32-NEXT:    vle32.v v8, (a0)
; CHECK-RV32-NEXT:    lui a0, %hi(h)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(h)
; CHECK-RV32-NEXT:    vle32.v v12, (a0)
; CHECK-RV32-NEXT:    vadd.vv v8, v12, v8
; CHECK-RV32-NEXT:    lui a0, %hi(i)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(i)
; CHECK-RV32-NEXT:    vse32.v v8, (a0)
; CHECK-RV32-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v9, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 2
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v10, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v11, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    lw a1, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v12, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v13, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v14, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vl1r.v v15, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 3
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 32
; CHECK-RV32-NEXT:    mret
  %1 = load <16 x i32>, ptr @g
  %2 = load <16 x i32>, ptr @h
  %add = add nsw <16 x i32> %2, %1
  store <16 x i32> %add, ptr @i
  ret void
}

@j = external global <32 x i32>
@k = external global <32 x i32>
@l = external global <32 x i32>

define void @foo_lmul8() nounwind #0 {
; CHECK-RV32-LABEL: foo_lmul8:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -32
; CHECK-RV32-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a1, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 4
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 4
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v9, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v10, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v11, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v12, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v13, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v14, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 3
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v15, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v16, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v17, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 2
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v18, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v19, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v20, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v21, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vs1r.v v22, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vs1r.v v23, (a0) # vscale x 8-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, %hi(j)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(j)
; CHECK-RV32-NEXT:    li a1, 32
; CHECK-RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-RV32-NEXT:    vle32.v v8, (a0)
; CHECK-RV32-NEXT:    lui a0, %hi(k)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(k)
; CHECK-RV32-NEXT:    vle32.v v16, (a0)
; CHECK-RV32-NEXT:    vadd.vv v8, v16, v8
; CHECK-RV32-NEXT:    lui a0, %hi(l)
; CHECK-RV32-NEXT:    addi a0, a0, %lo(l)
; CHECK-RV32-NEXT:    vse32.v v8, (a0)
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 4
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v9, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v10, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v11, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a1, a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v12, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v13, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v14, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 3
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v15, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 3
; CHECK-RV32-NEXT:    sub a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v16, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    mv a1, a0
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, a0, a1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v17, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 2
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v18, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 2
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v19, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a1, a0, 1
; CHECK-RV32-NEXT:    add a0, a1, a0
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v20, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v21, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    addi a0, a0, 16
; CHECK-RV32-NEXT:    vl1r.v v22, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    addi a0, sp, 16
; CHECK-RV32-NEXT:    vl1r.v v23, (a0) # vscale x 8-byte Folded Reload
; CHECK-RV32-NEXT:    csrr a0, vlenb
; CHECK-RV32-NEXT:    slli a0, a0, 4
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a1, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 32
; CHECK-RV32-NEXT:    mret
  %1 = load <32 x i32>, ptr @j
  %2 = load <32 x i32>, ptr @k
  %add = add nsw <32 x i32> %2, %1
  store <32 x i32> %add, ptr @l
  ret void
}

attributes #0 = { "interrupt"="machine" }
