; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-- < %s | FileCheck %s

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare void @use16(i16)
declare void @use32(i32)

define i1 @rotl_eq_0(i8 %x, i8 %y) nounwind {
; CHECK-LABEL: rotl_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    testb %dil, %dil
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %rot = tail call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 %y)
  %r = icmp eq i8 %rot, 0
  ret i1 %r
}

; Extra use is ok.

define i1 @rotl_ne_0(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: rotl_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    movl %esi, %ecx
; CHECK-NEXT:    movl %edi, %ebx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    roll %cl, %edi
; CHECK-NEXT:    callq use32@PLT
; CHECK-NEXT:    testl %ebx, %ebx
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    retq
  %rot = tail call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 %y)
  call void @use32(i32 %rot)
  %r = icmp ne i32 %rot, 0
  ret i1 %r
}

define i1 @rotl_eq_n1(i8 %x, i8 %y) nounwind {
; CHECK-LABEL: rotl_eq_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpb $-1, %dil
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %rot = tail call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 %y)
  %r = icmp eq i8 %rot, -1
  ret i1 %r
}

; Vectors work too.

define <4 x i1> @rotl_ne_n1(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: rotl_ne_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retq
  %rot = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32>%x, <4 x i32> %x, <4 x i32> %y)
  %r = icmp ne <4 x i32> %rot, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i1> %r
}

; Undef is ok to propagate.

define <4 x i1> @rotl_ne_n1_undef(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: rotl_ne_n1_undef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm0
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retq
  %rot = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32>%x, <4 x i32> %x, <4 x i32> %y)
  %r = icmp ne <4 x i32> %rot, <i32 -1, i32 undef, i32 -1, i32 -1>
  ret <4 x i1> %r
}

define i1 @rotr_eq_0(i16 %x, i16 %y) nounwind {
; CHECK-LABEL: rotr_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    movl %esi, %ecx
; CHECK-NEXT:    movl %edi, %ebx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, %di
; CHECK-NEXT:    callq use16@PLT
; CHECK-NEXT:    testw %bx, %bx
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    retq
  %rot = tail call i16 @llvm.fshr.i16(i16 %x, i16 %x, i16 %y)
  call void @use16(i16 %rot)
  %r = icmp eq i16 %rot, 0
  ret i1 %r
}

define i1 @rotr_ne_0(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: rotr_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    testq %rdi, %rdi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %rot = tail call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %y)
  %r = icmp ne i64 %rot, 0
  ret i1 %r
}

define i1 @rotr_eq_n1(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: rotr_eq_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpq $-1, %rdi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %rot = tail call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %y)
  %r = icmp eq i64 %rot, -1
  ret i1 %r
}

define i1 @rotr_ne_n1(i16 %x, i16 %y) nounwind {
; CHECK-LABEL: rotr_ne_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw $-1, %di
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %rot = tail call i16 @llvm.fshr.i16(i16 %x, i16 %x, i16 %y)
  %r = icmp ne i16 %rot, -1
  ret i1 %r
}

; negative test - wrong constant value

define i1 @rotr_ne_1(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: rotr_ne_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rsi, %rcx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $rcx
; CHECK-NEXT:    rorq %cl, %rdi
; CHECK-NEXT:    cmpq $1, %rdi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %rot = tail call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %y)
  %r = icmp ne i64 %rot, 1
  ret i1 %r
}

; negative test - wrong predicate

define i1 @rotr_sgt_n1(i16 %x, i16 %y) nounwind {
; CHECK-LABEL: rotr_sgt_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %esi, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    rorw %cl, %di
; CHECK-NEXT:    testw %di, %di
; CHECK-NEXT:    setns %al
; CHECK-NEXT:    retq
  %rot = tail call i16 @llvm.fshr.i16(i16 %x, i16 %x, i16 %y)
  %r = icmp sgt i16 %rot, -1
  ret i1 %r
}

; negative test - must be a rotate, not general funnel shift

define i1 @fshl_eq_n1(i8 %x, i8 %y, i8 %z) nounwind {
; CHECK-LABEL: fshl_eq_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    shll $8, %edi
; CHECK-NEXT:    movzbl %sil, %eax
; CHECK-NEXT:    orl %edi, %eax
; CHECK-NEXT:    andb $7, %cl
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shll %cl, %eax
; CHECK-NEXT:    shrl $8, %eax
; CHECK-NEXT:    cmpb $-1, %al
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %fsh = tail call i8 @llvm.fshl.i8(i8 %x, i8 %y, i8 %z)
  %r = icmp eq i8 %fsh, -1
  ret i1 %r
}

define i1 @or_rotl_eq_0(i8 %x, i8 %y, i8 %z) nounwind {
; CHECK-LABEL: or_rotl_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orb %sil, %dil
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %rot = tail call i8 @llvm.fshl.i8(i8 %x, i8 %x, i8 %z)
  %or = or i8 %rot, %y
  %r = icmp eq i8 %or, 0
  ret i1 %r
}

define i1 @or_rotr_ne_0(i64 %x, i64 %y, i64 %z) nounwind {
; CHECK-LABEL: or_rotr_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orq %rsi, %rdi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %rot = tail call i64 @llvm.fshr.i64(i64 %x, i64 %x, i64 %z)
  %or = or i64 %y, %rot
  %r = icmp ne i64 %or, 0
  ret i1 %r
}

; negative test - wrong constant

define i1 @or_rotl_ne_n1(i32 %x, i32 %y, i32 %z) nounwind {
; CHECK-LABEL: or_rotl_ne_n1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    roll %cl, %edi
; CHECK-NEXT:    orl %esi, %edi
; CHECK-NEXT:    cmpl $-1, %edi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %rot = tail call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 %z)
  %or = or i32 %y, %rot
  %r = icmp ne i32 %or, -1
  ret i1 %r
}

; negative test - extra use

define i1 @or_rotl_ne_0_use(i32 %x, i32 %y, i32 %z) nounwind {
; CHECK-LABEL: or_rotl_ne_0_use:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    roll %cl, %edi
; CHECK-NEXT:    orl %esi, %edi
; CHECK-NEXT:    setne %bl
; CHECK-NEXT:    callq use32@PLT
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    retq
  %rot = tail call i32 @llvm.fshl.i32(i32 %x, i32 %x, i32 %z)
  %or = or i32 %y, %rot
  call void @use32(i32 %or)
  %r = icmp ne i32 %or, 0
  ret i1 %r
}

define <4 x i1> @or_rotl_ne_eq0(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: or_rotl_ne_eq0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm0
; CHECK-NEXT:    retq
  %rot = tail call <4 x i32> @llvm.fshl.v4i32(<4 x i32>%x, <4 x i32> %x, <4 x i32> %y)
  %or = or <4 x i32> %y, %rot
  %r = icmp eq <4 x i32> %or, <i32 0, i32 0, i32 0, i32 poison>
  ret <4 x i1> %r
}

define i1 @fshl_or_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $5, %esi
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 5)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_commute_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_commute_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $5, %esi
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i32 %y, %x
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 5)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define <4 x i1> @fshl_or2_eq_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psrld $7, %xmm1
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm0
; CHECK-NEXT:    retq
  %or = or <4 x i32> %x, %y
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 25, i32 25, i32 25, i32 25>)
  %r = icmp eq <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @fshl_or2_commute_eq_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_commute_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psrld $7, %xmm1
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm0
; CHECK-NEXT:    retq
  %or = or <4 x i32> %y, %x
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 25, i32 25, i32 25, i32 25>)
  %r = icmp eq <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define i1 @fshr_or_eq_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $8, %esi
; CHECK-NEXT:    orw %di, %si
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i16 %x, %y
  %f = call i16 @llvm.fshr.i16(i16 %or, i16 %x, i16 8)
  %r = icmp eq i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or_commute_eq_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or_commute_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $8, %esi
; CHECK-NEXT:    orw %di, %si
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i16 %y, %x
  %f = call i16 @llvm.fshr.i16(i16 %or, i16 %x, i16 8)
  %r = icmp eq i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_eq_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or2_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shrq $3, %rsi
; CHECK-NEXT:    orq %rdi, %rsi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i64 %x, %y
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %or, i64 3)
  %r = icmp eq i64 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_commute_eq_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or2_commute_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shrq $3, %rsi
; CHECK-NEXT:    orq %rdi, %rsi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = or i64 %y, %x
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %or, i64 3)
  %r = icmp eq i64 %f, 0
  ret i1 %r
}

define i1 @fshl_or_ne_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $7, %esi
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 7)
  %r = icmp ne i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_commute_ne_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_commute_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shll $7, %esi
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i32 %y, %x
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 7)
  %r = icmp ne i32 %f, 0
  ret i1 %r
}

define <4 x i1> @fshl_or2_ne_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psrld $27, %xmm1
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retq
  %or = or <4 x i32> %x, %y
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %r = icmp ne <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @fshl_or2_commute_ne_0(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_or2_commute_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor %xmm2, %xmm2
; CHECK-NEXT:    psrld $27, %xmm1
; CHECK-NEXT:    por %xmm1, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm2, %xmm0
; CHECK-NEXT:    pcmpeqd %xmm1, %xmm1
; CHECK-NEXT:    pxor %xmm1, %xmm0
; CHECK-NEXT:    retq
  %or = or <4 x i32> %y, %x
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %or, <4 x i32> <i32 5, i32 5, i32 5, i32 5>)
  %r = icmp ne <4 x i32> %f, zeroinitializer
  ret <4 x i1> %r
}

define i1 @fshr_or_ne_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shlq $63, %rsi
; CHECK-NEXT:    orq %rdi, %rsi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i64 %x, %y
  %f = call i64 @llvm.fshr.i64(i64 %or, i64 %x, i64 1)
  %r = icmp ne i64 %f, 0
  ret i1 %r
}

define i1 @fshr_or_commute_ne_0(i64 %x, i64 %y) {
; CHECK-LABEL: fshr_or_commute_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shlq $63, %rsi
; CHECK-NEXT:    orq %rdi, %rsi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i64 %y, %x
  %f = call i64 @llvm.fshr.i64(i64 %or, i64 %x, i64 1)
  %r = icmp ne i64 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_ne_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or2_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movzwl %si, %eax
; CHECK-NEXT:    shrl $2, %eax
; CHECK-NEXT:    orw %di, %ax
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i16 %x, %y
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %or, i16 2)
  %r = icmp ne i16 %f, 0
  ret i1 %r
}

define i1 @fshr_or2_commute_ne_0(i16 %x, i16 %y) {
; CHECK-LABEL: fshr_or2_commute_ne_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movzwl %si, %eax
; CHECK-NEXT:    shrl $2, %eax
; CHECK-NEXT:    orw %di, %ax
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i16 %y, %x
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %or, i16 2)
  %r = icmp ne i16 %f, 0
  ret i1 %r
}

define i1 @fshl_xor_eq_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_xor_eq_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %edi, %esi
; CHECK-NEXT:    shldl $2, %edi, %esi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %or = xor i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp eq i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_sgt_0(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_sgt_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    shldl $2, %edi, %esi
; CHECK-NEXT:    testl %esi, %esi
; CHECK-NEXT:    setg %al
; CHECK-NEXT:    retq
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp sgt i32 %f, 0
  ret i1 %r
}

define i1 @fshl_or_ne_2(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_or_ne_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    orl %edi, %esi
; CHECK-NEXT:    shldl $2, %edi, %esi
; CHECK-NEXT:    cmpl $2, %esi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %or = or i32 %x, %y
  %f = call i32 @llvm.fshl.i32(i32 %or, i32 %x, i32 2)
  %r = icmp ne i32 %f, 2
  ret i1 %r
}
