; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s

define amdgpu_ps float @atomic_min_flt_1d(<8 x i32> inreg %rsrc, float %data, i32 %s) {
; GFX12-LABEL: atomic_min_flt_1d:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    image_atomic_min_flt v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.atomic.min.flt.1d.f32.f32(float %data, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}

define amdgpu_ps float @atomic_max_flt_1d(<8 x i32> inreg %rsrc, float %data, i32 %s) {
; GFX12-LABEL: atomic_max_flt_1d:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    image_atomic_max_flt v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.atomic.max.flt.1d.f32.f32(float %data, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}

define amdgpu_ps float @atomic_add_flt_1d(<8 x i32> inreg %rsrc, float %data, i32 %s) {
; GFX12-LABEL: atomic_add_flt_1d:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    image_atomic_add_flt v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RETURN
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.atomic.add.flt.1d.f32.f32(float %data, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}

declare float @llvm.amdgcn.image.atomic.add.flt.1d.f32.f32(float, i32, <8 x i32>, i32, i32)
declare float @llvm.amdgcn.image.atomic.min.flt.1d.f32.f32(float, i32, <8 x i32>, i32, i32)
declare float @llvm.amdgcn.image.atomic.max.flt.1d.f32.f32(float, i32, <8 x i32>, i32, i32)
