; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

target datalayout = "p:16:16"

define void @geps_may_wrap(ptr %a, ptr %b, i64 %N) {
; CHECK-LABEL: 'geps_may_wrap'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:        ptr %b
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.iv = getelementptr i32, ptr %a, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %b High: (4 + %b))
; CHECK-NEXT:            Member: %b
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %a High: (16 + (12 * (trunc i128 ((zext i64 %N to i128) /u 3) to i16)) + %a))
; CHECK-NEXT:            Member: {%a,+,12}<%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-NEXT:      {0,+,3}<%loop> Added Flags: <nusw>
; CHECK-NEXT:      {%a,+,12}<%loop> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.iv = getelementptr i32, ptr %a, i64 %iv
  store i32 0, ptr %gep.iv, align 1
  store i32 0, ptr %b, align 1
  %iv.next = add i64 %iv, 3
  %.not = icmp ult i64 %N, %iv
  br i1 %.not, label %exit, label %loop

exit:
  ret void
}
