; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=mergeicmps -verify-dom-info -S | FileCheck %s

target triple = "x86_64"

; This is very much not an x86 ABI, in current use, but we're testing
; that we've fixed a bug where accumulateConstantOffset() was called incorrectly.
target datalayout = "e-p:64:64:64:32"

; Define a cunstom data layout that has index width < pointer width
; and make sure that doesn't break anything
define void @fat_ptrs(ptr dereferenceable(16) %a, ptr dereferenceable(16) %b) {
; CHECK-LABEL: @fat_ptrs(
; CHECK-NEXT:  bb0:
; CHECK-NEXT:    [[PTR_A1:%.*]] = getelementptr inbounds [2 x i64], ptr [[A:%.*]], i32 0, i32 1
; CHECK-NEXT:    [[PTR_B1:%.*]] = getelementptr inbounds [2 x i64], ptr [[B:%.*]], i32 0, i32 1
; CHECK-NEXT:    br label %"bb1+bb2"
; CHECK:       "bb1+bb2":
; CHECK-NEXT:    [[MEMCMP:%.*]] = call i32 @memcmp(ptr [[A]], ptr [[B]], i32 16)
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i32 [[MEMCMP]], 0
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
bb0:
  %ptr_a1 = getelementptr inbounds [2 x i64], ptr %a, i32 0, i32 1
  %ptr_b1 = getelementptr inbounds [2 x i64], ptr %b, i32 0, i32 1
  br label %bb1

bb1:                                              ; preds = %bb0
  %a0 = load i64, ptr %a
  %b0 = load i64, ptr %b
  %cond0 = icmp eq i64 %a0, %b0
  br i1 %cond0, label %bb2, label %bb3

bb2:                                              ; preds = %bb1
  %a1 = load i64, ptr %ptr_a1
  %b1 = load i64, ptr %ptr_b1
  %cond1 = icmp eq i64 %a1, %b1
  br label %bb3

bb3:                                              ; preds = %bb2, %bb1
  %necessary = phi i1 [ %cond1, %bb2 ], [ false, %bb1 ]
  ret void
}
