package WebService::Mattermost::V4::API::Object::Binary;

# ABSTRACT: A binary item.

use Moo;
use Types::Standard qw(Maybe Str);

extends 'WebService::Mattermost::V4::API::Object';

################################################################################

has content => (is => 'ro', isa => Maybe[Str], lazy => 1, builder => 1);

################################################################################

sub _build_content { shift->raw_content }

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Binary - A binary item.

=head1 VERSION

version 0.30

=head1 DESCRIPTION

Contains raw binary for a file returned from Mattermost.

=head2 ATTRIBUTES

=over 4

=item C<content>

Raw binary content.

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
