package WebService::Mattermost::V4::API::Object::Emoji;

# ABSTRACT: An emoji item.

use Moo;
use Types::Standard qw(Str Int);

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::APIMethods
    WebService::Mattermost::V4::API::Object::Role::Timestamps
    WebService::Mattermost::V4::API::Object::Role::BelongingToUser
    WebService::Mattermost::V4::API::Object::Role::ID
    WebService::Mattermost::V4::API::Object::Role::Name
);

################################################################################

sub BUILD {
    my $self = shift;

    $self->api_resource_name('emoji');
    $self->set_available_api_methods([ qw(
        delete
        get_image
    ) ]);

    return 1;
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Emoji - An emoji item.

=head1 VERSION

version 0.30

=head1 DESCRIPTION

Details a Mattermost Emoji object.

=head2 METHODS

See matching methods in L<WebService::Mattermost::V4::API::Resource::Emoji>
for full documentation.

ID parameters are not required:

    my $response = $mattermost->api->emoji->get('ID-HERE')->item->get_image();

Is the same as:

    my $response = $mattermost->api->emoji->get_image('ID-HERE');

=over 4

=item C<delete()>

=item C<get_image()>

=back

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Emoji>

=item L<WebService::Mattermost::V4::API::Object::Role::Timestamps>

=item L<WebService::Mattermost::V4::API::Object::Role::BelongingToUser>

=item L<WebService::Mattermost::V4::API::Object::Role::ID>

=item L<WebService::Mattermost::V4::API::Object::Role::Name>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
