package Net::SolarWinds::Helper;

use strict;
use warnings;

=head1 NAME

Net::SolarWinds::Helper - Common OO Methods

=head1 SYNOPSIS

  use base qw(Net::SolarWinds::Helper);

=head1 DESCRIPTION

This class provides common OO methods used to for Solarwinds development.  These methods are all stand alone.

=over 4

=item * my $reverse_hex=$self->ip_to_reverse_hex($ip);

Converts an IP into hex with the octets swapped to reverse order.

=cut 

sub ip_to_reverse_hex {

  my ($self,$ip)=@_;

  my $hex=unpack("H8",reverse(pack("C4",split(/\./,$ip))));

  return $hex;
}

=item * my $gui_ip=$self->ip_to_gui($ip);

Converts a quad notation ip to the gui display version cpm uses..

=cut

sub ip_to_gui {
  my ($self,$ip)=@_;

  my $hex=$self->ip_to_reverse_hex($ip);

  $hex .="-0000-0000-0000-000000000000";

  return $hex;
}

=item * my $swis=$self->nodeUri($node_id);

Returns the node rui based on the $node_id

=cut

sub nodeUri {
  my ($self,$nodeId)=@_;
  return "swis://localhost/Orion/Orion.Nodes/NodeID=$nodeId";
}

=back

=head1 Author

Michael Shipper

=cut

1;

__END__
