use v5.14;
use warnings;
use Test::More 0.98;
use utf8;
use open IO => ':utf8', ':std';
use Data::Dumper;

use lib './t';
use ac;

use Text::ParseWords qw(shellwords);
use Getopt::Long 'Configure';
Configure qw(bundling no_getopt_compat no_ignore_case);
GetOptions(\my %opt,
           'data-section',	# produce data section
           'example',		# show command execution example
           'show',		# show test
           'number|n=i',	# select test number
) or die;

use File::Spec;
$ENV{HOME} = File::Spec->rel2abs('t/home');

use Data::Section::Simple qw(get_data_section);
my $expected = get_data_section;

use File::Slurper 'read_lines';
my $sh = $0 =~ s/\.t/.sh/r;
my @command = read_lines $sh or die;

if ($opt{show}) {
    for (0 .. $#command) {
	printf "%4d: %s\n", $_, $command[$_];
    }
    exit;
}

if (defined(my $n = $opt{number})) {
    die "$n: invalid number\n" if $n > $#command;
    @command = $command[$n];
}

for (@command) {
    my @command = shellwords $_;
    shift @command if $command[0] eq 'ansicolumn';
    my $result = ac->new(@command)->exec();
    if ($opt{example}) {
	printf "\$ %s\n", $_;
	print $result;
    }
    elsif ($opt{'data-section'}) {
	printf "\@\@ %s\n", $_;
	print $result;
    }
    else {
	is($result, $expected->{$_}, $_);
    }
}

exit if %opt;

done_testing;

__DATA__

@@ ansicolumn t/yamanashi.txt -c80 -P10
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ 　小さな谷川の底を写した二枚の青い幻燈です。                                                         │
│                                                                                                      │
│                                                                                                      │
│ 一、五月                                                                                             │
│                                                                                                      │
│ 　二疋の蟹の子供らが青じろい水の底で話していました。                                                 │
│ 『クラムボンはわらったよ。』                                                                         │
│ 『クラムボンはかぷかぷわらったよ。』                                                                 │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ 『クラムボンは跳ねてわらったよ。』                                                                   │
│ 『クラムボンはかぷかぷわらったよ。』                                                                 │
│                                                                                                      │
│ 　泡と一緒に、白い樺の花びらが天井をたくさんすべって来ました。                                       │
│ 『こわいよ、お父さん。』弟の蟹も云いました。                                                         │
│                                                                                                      │
│                                                                                                      │
│ 二、十二月                                                                                           │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────────────────────────────────────────────────────────┐
│                                                                                                      │
│ 　蟹の子供らはもうよほど大きくなり、底の景色も夏から秋の間にすっかり変りました。                     │
│ 　白い柔かな円石もころがって来、小さな錐の形の水晶の粒や、金雲母のかけらもながれて来てとまりました。 │
│                                                                                                      │
│                                                                                                      │
│                                                                                                      │
│                                                                                                      │
│                                                                                                      │
└──────────────────────────────────────────────────────────────────────────────────────────────────────┘
@@ ansicolumn t/yamanashi.txt -c80 -P10 -W
┌──────────────────────────────────────────────────────────────────────────────┐
│ 　小さな谷川の底を写した二枚の青い幻燈です。                                 │
│                                                                              │
│                                                                              │
│ 一、五月                                                                     │
│                                                                              │
│ 　二疋の蟹の子供らが青じろい水の底で話していました。                         │
│ 『クラムボンはわらったよ。』                                                 │
│ 『クラムボンはかぷかぷわらったよ。』                                         │
└──────────────────────────────────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────────────────────────────────┐
│ 『クラムボンは跳ねてわらったよ。』                                           │
│ 『クラムボンはかぷかぷわらったよ。』                                         │
│                                                                              │
│ 　泡と一緒に、白い樺の花びらが天井をたくさんすべって来ました。               │
│ 『こわいよ、お父さん。』弟の蟹も云いました。                                 │
│                                                                              │
│                                                                              │
│ 二、十二月                                                                   │
└──────────────────────────────────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────────────────────────────────┐
│                                                                              │
│ 　蟹の子供らはもうよほど大きくなり、底の景色も夏から秋の間にすっかり変りまし │
│ た。                                                                         │
│ 　白い柔かな円石もころがって来、小さな錐の形の水晶の粒や、金雲母のかけらもな │
│ がれて来てとまりました。                                                     │
│                                                                              │
│                                                                              │
│                                                                              │
└──────────────────────────────────────────────────────────────────────────────┘
@@ ansicolumn t/yamanashi.txt -c80 -P10 -C3
┌────────────────────────┐┌────────────────────────┐┌────────────────────────┐
│ 　小さな谷川の底を写し ││ ました。               ││ わらったよ。』         │
│ た二枚の青い幻燈です。 ││ 『クラムボンはわらった ││                        │
│                        ││ よ。』                 ││ 　泡と一緒に、白い樺の │
│                        ││ 『クラムボンはかぷかぷ ││ 花びらが天井をたくさん │
│ 一、五月               ││ わらったよ。』         ││ すべって来ました。     │
│                        ││ 『クラムボンは跳ねてわ ││ 『こわいよ、お父さん。 │
│ 　二疋の蟹の子供らが青 ││ らったよ。』           ││ 』弟の蟹も云いました。 │
│ じろい水の底で話してい ││ 『クラムボンはかぷかぷ ││                        │
└────────────────────────┘└────────────────────────┘└────────────────────────┘
┌────────────────────────┐┌────────────────────────┐
│                        ││ がって来、小さな錐の形 │
│ 二、十二月             ││ の水晶の粒や、金雲母の │
│                        ││ かけらもながれて来てと │
│ 　蟹の子供らはもうよほ ││ まりました。           │
│ ど大きくなり、底の景色 ││                        │
│ も夏から秋の間にすっか ││                        │
│ り変りました。         ││                        │
│ 　白い柔かな円石もころ ││                        │
└────────────────────────┘└────────────────────────┘
@@ ansicolumn t/yamanashi.txt -c80 -P10 -C3 -D
┌────────────────────────┐┌────────────────────────┐┌────────────────────────┐
│ 　小さな谷川の底を写   ││ 　二疋の蟹の子供らが   ││ わらったよ。』         │
│ した二枚の青い幻燈で   ││ 青じろい水の底で話し   ││ 『クラムボンはかぷか   │
│ す。                   ││ ていました。           ││ ぷわらったよ。』       │
│                        ││ 『クラムボンはわらっ   ││                        │
│                        ││ たよ。』               ││ 　泡と一緒に、白い樺   │
│ 一、五月               ││ 『クラムボンはかぷか   ││ の花びらが天井をたく   │
│                        ││ ぷわらったよ。』       ││ さんすべって来ました。 │
│                        ││ 『クラムボンは跳ねて   ││ 『こわいよ、お父さん。 │
└────────────────────────┘└────────────────────────┘└────────────────────────┘
┌────────────────────────┐┌────────────────────────┐
│ 』弟の蟹も云いました。 ││ すっかり変りました。   │
│                        ││ 　白い柔かな円石もこ   │
│                        ││ ろがって来、小さな錐   │
│ 二、十二月             ││ の形の水晶の粒や、金   │
│                        ││ 雲母のかけらもながれ   │
│ 　蟹の子供らはもうよ   ││ て来てとまりました。   │
│ ほど大きくなり、底の   ││                        │
│ 景色も夏から秋の間に   ││                        │
└────────────────────────┘└────────────────────────┘
@@ ansicolumn t/yamanashi.txt -c80 -P10 -C3 -D --runin=4 --runout=4
┌────────────────────────┐┌────────────────────────┐┌────────────────────────┐
│ 　小さな谷川の底を     ││ 　二疋の蟹の子供ら     ││ てわらったよ。』       │
│ 写した二枚の青い幻     ││ が青じろい水の底で     ││ 『クラムボンはかぷ     │
│ 燈です。               ││ 話していました。       ││ かぷわらったよ。』     │
│                        ││ 『クラムボンはわらっ   ││                        │
│                        ││ たよ。』               ││ 　泡と一緒に、白い     │
│ 一、五月               ││ 『クラムボンはかぷ     ││ 樺の花びらが天井を     │
│                        ││ かぷわらったよ。』     ││ たくさんすべって来     │
│                        ││ 『クラムボンは跳ね     ││ ました。               │
└────────────────────────┘└────────────────────────┘└────────────────────────┘
┌────────────────────────┐┌────────────────────────┐┌────────────────────────┐
│ 『こわいよ、お父さ     ││ 　蟹の子供らはもう     ││ や、金雲母のかけら     │
│ ん。』弟の蟹も云い     ││ よほど大きくなり、     ││ もながれて来てとま     │
│ ました。               ││ 底の景色も夏から秋     ││ りました。             │
│                        ││ の間にすっかり変り     ││                        │
│                        ││ ました。               ││                        │
│ 二、十二月             ││ 　白い柔かな円石も     ││                        │
│                        ││ ころがって来、小さ     ││                        │
│                        ││ な錐の形の水晶の粒     ││                        │
└────────────────────────┘└────────────────────────┘└────────────────────────┘
@@ ansicolumn t/yamanashi.txt t/yamanashi.txt -c80
┌──────────────────────────────────────┐┌──────────────────────────────────────┐
│ 　小さな谷川の底を写した二枚の青い幻 ││ 　小さな谷川の底を写した二枚の青い幻 │
│ 燈です。                             ││ 燈です。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 一、五月                             ││ 一、五月                             │
│                                      ││                                      │
│ 　二疋の蟹の子供らが青じろい水の底で ││ 　二疋の蟹の子供らが青じろい水の底で │
│ 話していました。                     ││ 話していました。                     │
│ 『クラムボンはわらったよ。』         ││ 『クラムボンはわらったよ。』         │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│ 『クラムボンは跳ねてわらったよ。』   ││ 『クラムボンは跳ねてわらったよ。』   │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│                                      ││                                      │
│ 　泡と一緒に、白い樺の花びらが天井を ││ 　泡と一緒に、白い樺の花びらが天井を │
│ たくさんすべって来ました。           ││ たくさんすべって来ました。           │
│ 『こわいよ、お父さん。』弟の蟹も云い ││ 『こわいよ、お父さん。』弟の蟹も云い │
│ ました。                             ││ ました。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 二、十二月                           ││ 二、十二月                           │
│                                      ││                                      │
│ 　蟹の子供らはもうよほど大きくなり、 ││ 　蟹の子供らはもうよほど大きくなり、 │
│ 底の景色も夏から秋の間にすっかり変り ││ 底の景色も夏から秋の間にすっかり変り │
│ ました。                             ││ ました。                             │
│ 　白い柔かな円石もころがって来、小さ ││ 　白い柔かな円石もころがって来、小さ │
│ な錐の形の水晶の粒や、金雲母のかけら ││ な錐の形の水晶の粒や、金雲母のかけら │
│ もながれて来てとまりました。         ││ もながれて来てとまりました。         │
└──────────────────────────────────────┘└──────────────────────────────────────┘
@@ ansicolumn t/yamanashi-pages.txt -c80 --pages --parallel
┌──────────────────────────────────────┐┌──────────────────────────────────────┐
│ 　小さな谷川の底を写した二枚の青い幻 ││ 　小さな谷川の底を写した二枚の青い幻 │
│ 燈です。                             ││ 燈です。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 一、五月                             ││ 一、五月                             │
│                                      ││                                      │
│ 　二疋の蟹の子供らが青じろい水の底で ││ 　二疋の蟹の子供らが青じろい水の底で │
│ 話していました。                     ││ 話していました。                     │
│ 『クラムボンはわらったよ。』         ││ 『クラムボンはわらったよ。』         │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│ 『クラムボンは跳ねてわらったよ。』   ││ 『クラムボンは跳ねてわらったよ。』   │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│                                      ││                                      │
│ 　泡と一緒に、白い樺の花びらが天井を ││ 　泡と一緒に、白い樺の花びらが天井を │
│ たくさんすべって来ました。           ││ たくさんすべって来ました。           │
│ 『こわいよ、お父さん。』弟の蟹も云い ││ 『こわいよ、お父さん。』弟の蟹も云い │
│ ました。                             ││ ました。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 二、十二月                           ││ 二、十二月                           │
│                                      ││                                      │
│ 　蟹の子供らはもうよほど大きくなり、 ││ 　蟹の子供らはもうよほど大きくなり、 │
│ 底の景色も夏から秋の間にすっかり変り ││ 底の景色も夏から秋の間にすっかり変り │
│ ました。                             ││ ました。                             │
│ 　白い柔かな円石もころがって来、小さ ││ 　白い柔かな円石もころがって来、小さ │
│ な錐の形の水晶の粒や、金雲母のかけら ││ な錐の形の水晶の粒や、金雲母のかけら │
│ もながれて来てとまりました。         ││ もながれて来てとまりました。         │
└──────────────────────────────────────┘└──────────────────────────────────────┘
@@ ansicolumn t/yamanashi-pages.txt -c80 -P32 -C2 --fillup-str=~
┌──────────────────────────────────────┐┌──────────────────────────────────────┐
│ 　小さな谷川の底を写した二枚の青い幻 ││ 　小さな谷川の底を写した二枚の青い幻 │
│ 燈です。                             ││ 燈です。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 一、五月                             ││ 一、五月                             │
│                                      ││                                      │
│ 　二疋の蟹の子供らが青じろい水の底で ││ 　二疋の蟹の子供らが青じろい水の底で │
│ 話していました。                     ││ 話していました。                     │
│ 『クラムボンはわらったよ。』         ││ 『クラムボンはわらったよ。』         │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│ 『クラムボンは跳ねてわらったよ。』   ││ 『クラムボンは跳ねてわらったよ。』   │
│ 『クラムボンはかぷかぷわらったよ。』 ││ 『クラムボンはかぷかぷわらったよ。』 │
│                                      ││                                      │
│ 　泡と一緒に、白い樺の花びらが天井を ││ 　泡と一緒に、白い樺の花びらが天井を │
│ たくさんすべって来ました。           ││ たくさんすべって来ました。           │
│ 『こわいよ、お父さん。』弟の蟹も云い ││ 『こわいよ、お父さん。』弟の蟹も云い │
│ ました。                             ││ ました。                             │
│                                      ││                                      │
│                                      ││                                      │
│ 二、十二月                           ││ 二、十二月                           │
│                                      ││                                      │
│ 　蟹の子供らはもうよほど大きくなり、 ││ 　蟹の子供らはもうよほど大きくなり、 │
│ 底の景色も夏から秋の間にすっかり変り ││ 底の景色も夏から秋の間にすっかり変り │
│ ました。                             ││ ました。                             │
│ 　白い柔かな円石もころがって来、小さ ││ 　白い柔かな円石もころがって来、小さ │
│ な錐の形の水晶の粒や、金雲母のかけら ││ な錐の形の水晶の粒や、金雲母のかけら │
│ もながれて来てとまりました。         ││ もながれて来てとまりました。         │
│ ~                                    ││ ~                                    │
│ ~                                    ││ ~                                    │
│ ~                                    ││ ~                                    │
└──────────────────────────────────────┘└──────────────────────────────────────┘
