/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.util.Map;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.http.AuthContext;

public class Authenticator
extends BasicAuthenticator {
    private final String adminName;
    private final String adminPass;
    private String currentBucketName;
    private final Map<String, Bucket> buckets;

    public Authenticator(String username, String password, Map<String, Bucket> buckets) {
        super("Couchbase Mock");
        this.adminName = username;
        this.adminPass = password;
        this.buckets = buckets;
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        if (this.adminName.equals(username) && this.adminPass.equals(password)) {
            return true;
        }
        Bucket bucket = this.buckets.get(username);
        if (bucket == null) {
            return false;
        }
        if (username.isEmpty()) {
            return bucket.getPassword().isEmpty();
        }
        if (!this.currentBucketName.equals(username)) {
            return false;
        }
        String bucketPassword = bucket.getPassword();
        return bucketPassword.isEmpty() || bucketPassword.equals(password);
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange exchange) {
        String path = exchange.getRequestURI().normalize().getPath();
        path = path.replaceAll("^/", "");
        String[] components = path.split("/");
        exchange.setAttribute(this.realm, this);
        this.currentBucketName = null;
        if (components.length > 3 && components[2].startsWith("buckets")) {
            this.currentBucketName = components[3];
        }
        AuthContext context = null;
        String auth = exchange.getRequestHeaders().getFirst("Authorization");
        if (auth != null) {
            try {
                context = new AuthContext(auth);
            }
            catch (IOException e) {
                return new Authenticator.Failure(400);
            }
        }
        if (this.currentBucketName == null) {
            return new Authenticator.Success(new HttpPrincipal("", this.realm));
        }
        Bucket bucket = this.buckets.get(this.currentBucketName);
        if (bucket == null) {
            return new Authenticator.Failure(404);
        }
        if ((bucket.getPassword() == null || bucket.getPassword().isEmpty()) && context == null) {
            return new Authenticator.Success(new HttpPrincipal("", this.realm));
        }
        return super.authenticate(exchange);
    }

    public String getAdminName() {
        return this.adminName;
    }
}

