/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OutputContext {
    private List<ByteBuffer> buffers;
    private final ByteBuffer[] singleArray = new ByteBuffer[1];

    public ByteBuffer[] getIov() {
        if (this.buffers.size() == 1) {
            this.singleArray[0] = this.buffers.get(0);
            return this.singleArray;
        }
        return this.buffers.toArray(new ByteBuffer[this.buffers.size()]);
    }

    public boolean hasRemaining() {
        return !this.buffers.isEmpty();
    }

    public OutputContext getSlice(int limit) {
        LinkedList<ByteBuffer> newBufs = new LinkedList<ByteBuffer>();
        ByteBuffer buf = ByteBuffer.allocate(limit);
        Iterator<ByteBuffer> iter = this.buffers.iterator();
        while (iter.hasNext() && buf.position() < buf.limit()) {
            ByteBuffer cur = iter.next();
            int diff = buf.limit() - buf.position();
            if (diff > cur.limit()) {
                buf.put(cur);
                iter.remove();
                continue;
            }
            ByteBuffer slice = cur.duplicate();
            slice.limit(diff);
            buf.put(slice);
        }
        return new OutputContext(newBufs);
    }

    public void updateBytesSent(long num) {
        ByteBuffer cur;
        Iterator<ByteBuffer> iter = this.buffers.iterator();
        while (iter.hasNext() && !(cur = iter.next()).hasRemaining()) {
            iter.remove();
        }
    }

    public OutputContext(List<ByteBuffer> origBufs) {
        this.buffers = origBufs;
    }

    public List<ByteBuffer> releaseRemaining() {
        List<ByteBuffer> ret = this.buffers;
        this.buffers = null;
        return ret;
    }

    public String toString() {
        return "IOV: " + this.buffers.size();
    }
}

