#!/usr/bin/perl

package eBay::API::XML::DataType::StoreColorSchemeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreColorSchemeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreColorSchemeType

=head1 DESCRIPTION

Store color scheme.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreColorSchemeType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::StoreColorType;
use eBay::API::XML::DataType::StoreFontType;


my @gaProperties = ( [ 'Color', 'ns:StoreColorType', ''
	     ,'eBay::API::XML::DataType::StoreColorType', '1' ]
	, [ 'ColorSchemeID', 'xs:int', '', '', '' ]
	, [ 'Font', 'ns:StoreFontType', ''
	     ,'eBay::API::XML::DataType::StoreFontType', '1' ]
	, [ 'Name', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setColor()

Store color set.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreColorType'

=cut

sub setColor {
  my $self = shift;
  $self->{'Color'} = shift
}

=head2 getColor()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreColorType'

=cut

sub getColor {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Color'
		,'eBay::API::XML::DataType::StoreColorType');
}


=head2 setColorSchemeID()

Store color scheme ID. (use GetStoreOptions to get the list of
valid theme color scheme IDs).

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setColorSchemeID {
  my $self = shift;
  $self->{'ColorSchemeID'} = shift
}

=head2 getColorSchemeID()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getColorSchemeID {
  my $self = shift;
  return $self->{'ColorSchemeID'};
}


=head2 setFont()

Store font set.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreFontType'

=cut

sub setFont {
  my $self = shift;
  $self->{'Font'} = shift
}

=head2 getFont()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'ns:StoreFontType'

=cut

sub getFont {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Font'
		,'eBay::API::XML::DataType::StoreFontType');
}


=head2 setName()

Store color scheme name. Provides a user-friendly name for the
color scheme.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
