# $Id: /mirror/coderepos/lang/perl/Google-Chart/branches/moose/lib/Google/Chart/Types.pm 67427 2008-07-29T10:40:51.707813Z lopnor  $

package Google::Chart::Types;
use Moose;
use Moose::Util::TypeConstraints;
use Sub::Exporter -setup => {
    exports => [ qw(hash_coercion) ]
};

sub hash_coercion {
    my (%args) = @_;

    my $default = $args{default};
    my $prefix  = $args{prefix};

    return sub {
        my $h = $_;
        my $module = $h->{module} || $default ||
            confess "No module name provided for coercion";
        if ($module !~ s/^\+//) {
            $module = join('::', $prefix, $module);
        }
        Class::MOP::load_class( $module );
        return $module->new(%{ $h->{args} });
    }
}

{
    role_type 'Google::Chart::Type';
    coerce 'Google::Chart::Type'
        => from 'Str'
        => via {
            my $class = sprintf( 'Google::Chart::Type::%s', ucfirst $_ );
            Class::MOP::load_class($class);

            return $class->new();
        }
    ;
    coerce 'Google::Chart::Type'
        => from 'HashRef'
        => hash_coercion(prefix => "Google::Chart::Type")
    ;
}

{
    role_type 'Google::Chart::Fill';
    coerce 'Google::Chart::Fill'
        => from 'Str'
        => via {
            my $class = sprintf( 'Google::Chart::Fill::%s', ucfirst $_ );
            Class::MOP::load_class($class);

            return $class->new();
        }
    ;
    coerce 'Google::Chart::Fill'
        => from 'HashRef'
        => hash_coercion(prefix => "Google::Chart::Fill")
    ;
}

{
    role_type 'Google::Chart::Data';
    coerce 'Google::Chart::Data'
        => from 'ArrayRef'
        => via {
            my $class = 'Google::Chart::Data::Text';
            Class::MOP::load_class($class);
            $class->new(dataset => $_);
        }
    ;
    coerce 'Google::Chart::Data'
        => from 'HashRef'
        => via {
            my $class = $_->{module};
            if ($class !~ s/^\+//) {
                $class = "Google::Chart::Data::$class";
            }
            Class::MOP::load_class($class);

            $class->new(%{$_->{args}});
        }
    ;
}

no Moose;

1;

__END__

=head1 NAME

Google::Chart::Types - Google::Chart Miscellaneous Types

=head1 FUNCTIONS

=head2 hash_coercion

=cut
