# Before `make install' is performed this script should be runnable with
# make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

use Test::More tests => 167;
#use diagnostics;

# test 1
BEGIN { use_ok( 'Net::Interface',qw(
	:afs
	:pfs
	:ifs
	_NI_AF_TEST
	mask2cidr
	cidr2mask
	full_inet_ntop
)); }
my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}


# should fail
foreach (3,5,15,17) {
  eval {
	cidr2mask(5,$_);
  };
  ok($@,"forced croak on bad address length ". $_);
}

my @results = qw(
    0000:0000:0000:0000:0000:0000:0000:0000
    8000:0000:0000:0000:0000:0000:0000:0000
    C000:0000:0000:0000:0000:0000:0000:0000
    E000:0000:0000:0000:0000:0000:0000:0000
    F000:0000:0000:0000:0000:0000:0000:0000
    F800:0000:0000:0000:0000:0000:0000:0000
    FC00:0000:0000:0000:0000:0000:0000:0000
    FE00:0000:0000:0000:0000:0000:0000:0000
    FF00:0000:0000:0000:0000:0000:0000:0000
    FF80:0000:0000:0000:0000:0000:0000:0000
    FFC0:0000:0000:0000:0000:0000:0000:0000
    FFE0:0000:0000:0000:0000:0000:0000:0000
    FFF0:0000:0000:0000:0000:0000:0000:0000
    FFF8:0000:0000:0000:0000:0000:0000:0000
    FFFC:0000:0000:0000:0000:0000:0000:0000
    FFFE:0000:0000:0000:0000:0000:0000:0000
    FFFF:0000:0000:0000:0000:0000:0000:0000
    FFFF:8000:0000:0000:0000:0000:0000:0000
    FFFF:C000:0000:0000:0000:0000:0000:0000
    FFFF:E000:0000:0000:0000:0000:0000:0000
    FFFF:F000:0000:0000:0000:0000:0000:0000
    FFFF:F800:0000:0000:0000:0000:0000:0000
    FFFF:FC00:0000:0000:0000:0000:0000:0000
    FFFF:FE00:0000:0000:0000:0000:0000:0000
    FFFF:FF00:0000:0000:0000:0000:0000:0000
    FFFF:FF80:0000:0000:0000:0000:0000:0000
    FFFF:FFC0:0000:0000:0000:0000:0000:0000
    FFFF:FFE0:0000:0000:0000:0000:0000:0000
    FFFF:FFF0:0000:0000:0000:0000:0000:0000
    FFFF:FFF8:0000:0000:0000:0000:0000:0000
    FFFF:FFFC:0000:0000:0000:0000:0000:0000
    FFFF:FFFE:0000:0000:0000:0000:0000:0000
    FFFF:FFFF:0000:0000:0000:0000:0000:0000
    FFFF:FFFF:8000:0000:0000:0000:0000:0000
    FFFF:FFFF:C000:0000:0000:0000:0000:0000
    FFFF:FFFF:E000:0000:0000:0000:0000:0000
    FFFF:FFFF:F000:0000:0000:0000:0000:0000
    FFFF:FFFF:F800:0000:0000:0000:0000:0000
    FFFF:FFFF:FC00:0000:0000:0000:0000:0000
    FFFF:FFFF:FE00:0000:0000:0000:0000:0000
    FFFF:FFFF:FF00:0000:0000:0000:0000:0000
    FFFF:FFFF:FF80:0000:0000:0000:0000:0000
    FFFF:FFFF:FFC0:0000:0000:0000:0000:0000
    FFFF:FFFF:FFE0:0000:0000:0000:0000:0000
    FFFF:FFFF:FFF0:0000:0000:0000:0000:0000
    FFFF:FFFF:FFF8:0000:0000:0000:0000:0000
    FFFF:FFFF:FFFC:0000:0000:0000:0000:0000
    FFFF:FFFF:FFFE:0000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:0000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:8000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:C000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:E000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:F000:0000:0000:0000:0000
    FFFF:FFFF:FFFF:F800:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FC00:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FE00:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FF00:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FF80:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFC0:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFE0:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFF0:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFF8:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFC:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFE:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:0000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:8000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:C000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:E000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:F000:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:F800:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FC00:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FE00:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FF00:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FF80:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFC0:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFE0:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFF0:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFF8:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFC:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFE:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:0000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:8000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:C000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:E000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:F000:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:F800:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FC00:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FE00:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FF00:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FF80:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFC0:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFE0:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFF0:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFF8:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFC:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFE:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:0000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:8000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:C000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:E000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:F000:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:F800:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FC00:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FE00:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FF00:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FF80:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFC0:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFE0:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFF0:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFF8:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFC:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFE:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:0000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:8000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:C000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:E000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:F000
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:F800
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FC00
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FE00
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FF00
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FF80
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFC0
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFE0
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFF0
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFF8
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFC
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFE
    FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
);

foreach (0..$#results) {
  ok(full_inet_ntop(cidr2mask($_,16)) eq $results[$_]);
}

@results = qw(
    00000000
    80000000
    c0000000
    e0000000
    f0000000
    f8000000
    fc000000
    fe000000
    ff000000
    ff800000
    ffc00000
    ffe00000
    fff00000
    fff80000
    fffc0000
    fffe0000
    ffff0000
    ffff8000
    ffffc000
    ffffe000
    fffff000
    fffff800
    fffffc00
    fffffe00
    ffffff00
    ffffff80
    ffffffc0
    ffffffe0
    fffffff0
    fffffff8
    fffffffc
    fffffffe
    ffffffff
);

foreach (0..$#results) {
  ok(unpack('H8',cidr2mask($_,4)) eq $results[$_]);
}
