# -*- perl -*-

#
# $Id: FontInfo.pm,v 1.3 2003/01/16 14:29:10 eserte Exp $
# Author: Slaven Rezic
#
# Copyright (C) 2001 Online Office Berlin. All rights reserved.
# Copyright (C) 2002 Slaven Rezic.
# This is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License, see the file COPYING.

#
# Mail: slaven@rezic.de
# WWW:  http://we-framework.sourceforge.net
#

package WE_Frontend::FontInfo;

use strict;
use vars qw($VERSION %fontinfo @EXPORT);
$VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

use base 'Exporter';
@EXPORT = qw(%fontinfo combine_fontinfo);

# MSIE, Windows, sans-serif (Arial)

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'8px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [2,3,3,4,4,7,5,2,3,3,3,5,2,3,2,2,4,4,4,4,4,4,4,4,4,4,2,2,5,5,5,4,8,5,5,6,6,5,5,6,6,2,4,5,4,7,6,6,5,6,6,5,5,6,5,7,5,5,5,2,2,2,3,4,3,4,4,4,4,4,2,5,4,2,2,3,2,6,4,4,4,5,3,4,2,4,3,5,3,3,4,3,3,3,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,3,4,4,4,4,3,4,3,6,3,4,5,0,6,4,3,4,3,3,3,5,4,2,3,3,3,4,7,7,7,5,5,5,5,5,5,5,8,6,5,5,5,5,2,2,2,2,6,6,6,6,6,6,6,5,6,6,6,6,6,5,5,5,4,4,4,4,4,4,7,4,4,4,4,4,2,2,2,2,4,4,4,4,4,4,4,4,5,4,4,4,4,4,4,4],
 heights => [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [3,3,4,6,6,9,7,2,3,3,4,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,10,7,7,7,7,7,6,8,7,3,5,7,6,9,7,8,7,8,7,7,7,7,7,9,7,7,6,3,3,3,5,6,3,6,6,5,6,6,3,6,6,3,3,4,3,9,6,6,6,6,3,4,3,6,5,7,5,5,5,3,3,3,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,3,6,6,6,6,3,6,3,7,4,6,6,0,7,6,4,5,3,3,3,6,5,3,3,3,4,6,8,8,8,6,7,7,7,7,7,7,10,7,7,7,7,7,3,3,3,3,7,7,8,8,8,8,8,6,8,7,7,7,7,7,7,6,6,6,6,6,6,6,9,5,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,5,6,6,6,6,6,5,6,5],
 heights => [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [3,2,4,6,6,10,7,2,4,4,4,6,3,4,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,11,8,7,7,7,6,6,8,7,2,5,7,6,8,7,8,6,8,7,7,6,7,8,10,7,8,7,3,3,3,5,6,4,6,6,6,6,6,4,6,6,2,2,5,2,8,6,6,6,6,4,6,3,6,6,10,6,6,6,4,2,4,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,2,6,6,7,6,2,6,4,8,4,6,6,0,8,6,4,6,4,4,4,6,6,3,4,4,5,6,9,10,10,6,8,8,8,8,8,8,11,7,6,6,6,6,2,2,2,2,8,7,8,8,8,8,8,6,8,7,7,7,7,8,7,7,6,6,6,6,6,6,10,6,6,6,6,6,2,2,2,2,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6],
 heights => [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [3,3,4,7,7,11,8,2,4,4,5,7,3,4,3,3,7,7,7,7,7,7,7,7,7,7,3,3,7,7,7,7,12,7,8,9,9,8,7,9,9,3,6,8,7,9,9,9,8,9,9,8,7,9,7,11,7,7,7,3,3,3,5,7,4,7,7,6,7,7,3,7,7,3,3,6,3,11,7,7,7,7,4,7,3,7,5,9,5,5,5,4,3,4,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,3,3,7,7,7,7,3,7,4,9,4,7,7,0,9,7,5,7,4,4,4,7,6,3,4,4,4,7,10,10,10,7,7,7,7,7,7,7,12,9,8,8,8,8,3,3,3,3,9,9,9,9,9,9,9,7,9,9,9,9,9,7,8,8,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,7,7,7,7,7,7,7,7,7,7,7,7,7,5,7,5],
 heights => [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'15px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,5,5,8,8,13,10,3,5,5,6,9,4,5,4,4,8,8,8,8,8,8,8,8,8,8,4,4,9,9,9,8,15,9,10,11,11,10,9,11,10,3,7,10,8,11,10,12,10,12,11,10,9,10,9,15,9,9,8,4,4,4,5,8,5,8,8,8,8,8,4,8,8,3,3,7,3,13,8,8,8,8,5,8,4,8,7,11,7,7,8,5,3,5,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,4,5,8,8,8,8,3,8,5,11,5,8,9,0,11,8,6,8,5,5,5,8,8,4,5,5,5,8,13,13,13,9,9,9,9,9,9,9,15,11,10,10,10,10,3,3,3,3,11,10,12,12,12,12,12,9,12,10,10,10,10,9,10,9,8,8,8,8,8,8,13,8,8,8,8,8,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,7],
 heights => [17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'sans-serif'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [6,6,7,11,11,18,13,4,7,7,8,12,6,7,6,6,11,11,11,11,11,11,11,11,11,11,6,6,12,12,12,11,20,13,13,14,14,13,12,16,13,6,10,13,11,17,13,16,13,16,14,13,12,13,13,19,13,14,12,6,6,6,8,11,7,11,11,10,11,11,6,11,10,4,4,10,4,16,10,11,11,11,7,10,6,10,9,15,9,10,9,7,6,7,12,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,6,6,11,11,11,11,6,11,7,15,7,11,12,0,15,11,8,11,7,7,7,11,11,6,7,7,7,11,17,17,17,12,13,13,13,13,13,13,20,14,13,13,13,13,6,6,6,6,14,14,16,16,16,16,16,12,16,14,14,14,14,13,13,12,11,11,11,11,11,11,18,10,11,11,11,11,6,6,6,6,11,11,11,11,11,11,11,11,11,11,11,11,11,10,11,10],
 heights => [23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23],
};

# MSIE, Windows, Verdana

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'8px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [3,3,4,7,5,9,6,2,4,4,5,7,3,4,3,4,5,5,5,5,5,5,5,5,5,5,4,4,7,7,7,4,8,5,5,6,6,5,5,6,6,3,4,6,4,7,6,6,5,6,6,5,5,6,5,8,5,5,5,4,4,4,7,5,5,5,5,4,5,5,3,5,5,2,3,5,2,8,5,5,5,5,3,4,3,5,5,7,5,5,4,5,4,5,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,3,5,5,5,5,4,5,5,8,4,5,7,0,8,5,4,7,4,4,5,5,5,3,5,4,4,5,8,8,8,4,5,5,5,5,5,5,8,6,5,5,5,5,3,3,3,3,6,6,6,6,6,6,6,7,6,6,6,6,6,5,5,5,5,5,5,5,5,5,8,4,5,5,5,5,2,2,2,2,5,5,5,5,5,5,5,7,5,5,5,5,5,5,5,5],
 heights => [10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,8,7,11,7,3,5,5,7,8,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,8,8,8,6,10,7,7,8,8,6,6,8,8,5,5,7,6,9,7,9,7,9,8,7,7,8,7,11,7,7,7,5,5,5,8,6,6,7,7,5,7,7,4,7,7,3,3,7,3,11,7,7,7,7,4,6,4,7,6,7,7,6,6,6,5,6,8,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,4,4,7,7,7,7,5,6,6,10,5,6,8,0,10,6,5,8,5,5,6,7,7,4,6,5,5,6,10,10,10,6,7,7,7,7,7,7,10,8,6,6,6,6,5,5,5,5,8,7,9,9,9,9,9,8,9,8,8,8,8,7,7,6,7,7,7,7,7,7,10,5,7,7,7,7,3,3,3,3,6,7,7,7,7,7,7,8,7,7,7,7,7,6,7,6],
 heights => [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,9,7,12,8,3,5,5,7,9,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,9,9,9,6,10,8,8,9,9,7,6,9,8,5,5,8,6,9,8,9,7,9,8,8,7,8,8,11,8,7,8,5,5,5,9,7,7,7,7,6,7,7,4,7,7,3,4,7,3,11,7,7,7,7,5,6,4,7,7,9,7,7,6,7,5,7,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,4,4,7,7,7,7,5,7,7,11,6,7,9,0,11,7,6,9,6,6,7,7,7,4,7,6,6,7,11,11,11,6,8,8,8,8,8,8,11,9,7,7,7,7,5,5,5,5,9,8,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,7,7,7,7,7,7,7,9,7,7,7,7,7,7,7,7],
 heights => [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,5,6,10,8,13,9,3,5,5,8,9,4,5,4,5,8,8,8,8,8,8,8,8,8,8,5,5,9,9,9,7,12,8,8,9,9,8,7,9,9,5,5,8,7,10,9,10,8,10,8,8,7,9,8,13,8,7,8,5,5,5,10,8,8,8,8,6,8,8,4,8,8,3,4,7,3,11,8,8,8,8,5,7,5,8,7,11,7,7,7,8,5,8,10,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,4,5,8,8,8,8,5,8,8,12,7,8,9,0,12,8,7,9,7,7,8,8,8,4,8,7,7,8,12,12,12,7,8,8,8,8,8,8,12,9,8,8,8,8,5,5,5,5,9,9,10,10,10,10,10,10,10,9,9,9,9,7,8,7,8,8,8,8,8,8,11,6,8,8,8,8,3,3,3,3,7,8,8,8,8,8,8,9,8,8,8,8,8,7,8,7],
 heights => [14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'15px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [5,6,7,12,10,16,11,4,7,7,10,12,5,7,5,7,10,10,10,10,10,10,10,10,10,10,7,7,12,12,12,8,15,10,10,11,11,9,9,12,11,5,7,10,8,13,11,12,9,12,10,10,9,11,10,15,10,9,10,7,7,7,12,10,10,9,9,8,9,9,5,9,9,3,5,9,3,15,9,10,9,9,6,8,6,9,9,13,9,9,9,10,7,10,12,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,5,6,10,10,10,10,7,10,10,15,8,10,12,0,15,10,8,12,8,8,10,9,10,5,10,8,8,10,15,15,15,8,10,10,10,10,10,10,15,11,9,9,9,9,5,5,5,5,11,11,12,12,12,12,12,12,12,11,11,11,11,9,9,9,9,9,9,9,9,9,14,8,9,9,9,9,3,3,3,3,9,9,10,10,10,10,10,12,10,9,9,9,9,9,9,9],
 heights => [18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18],
};

$fontinfo{'Win32'}{'Microsoft Internet Explorer'}{'verdana'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [7,8,9,16,13,22,15,5,9,9,13,16,7,9,7,9,13,13,13,13,13,13,13,13,13,13,9,9,16,16,16,11,20,14,14,14,15,13,12,16,15,8,9,14,11,17,15,16,12,16,14,14,12,15,14,20,14,12,14,9,9,9,16,13,13,12,12,10,12,12,7,12,13,6,7,12,6,19,13,12,12,12,9,10,8,13,12,16,12,12,11,13,9,13,16,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,7,8,13,13,13,13,9,13,13,20,11,13,16,0,20,13,11,16,11,11,13,13,13,7,13,11,11,13,20,20,20,11,14,14,14,14,14,14,19,14,13,13,13,13,8,8,8,8,16,15,16,16,16,16,16,16,16,15,15,15,15,12,12,12,12,12,12,12,12,12,19,10,12,12,12,12,6,6,6,6,12,13,12,12,12,12,12,16,12,13,13,13,13,12,12,12],
 heights => [25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25],
};

# Netscape4 4, Windows, sans-serif (Arial)

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'8px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[2,3,3,4,4,7,5,2,3,3,3,5,2,3,2,2,4,4,4,4,4,4,4,4,4,4,2,2,5,5,5,4,8,5,5,6,6,5,5,6,6,2,4,5,4,7,6,6,5,6,6,5,5,6,5,7,5,5,5,2,2,2,3,4,3,4,4,4,4,4,2,5,4,2,2,3,2,6,4,4,4,5,3,4,2,4,3,5,3,3,4,3,3,3,5,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,3,4,4,4,4,3,4,3,6,3,4,5,3,6,4,3,4,3,3,3,5,4,2,3,3,3,4,7,7,7,5,5,5,5,5,5,5,8,6,5,5,5,5,2,2,2,2,6,6,6,6,6,6,6,5,6,6,6,6,6,5,5,5,4,4,4,4,4,4,7,4,4,4,4,4,2,2,2,2,4,4,4,4,4,4,4,4,5,4,4,4,4,4,4,4],
 heights =>
[10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],
};

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,3,5,5,8,6,2,3,3,4,5,3,3,3,3,5,5,5,5,5,5,5,5,5,5,3,3,5,5,5,5,9,6,6,7,7,6,6,7,7,3,5,6,5,7,7,7,6,7,7,6,5,7,6,9,5,7,6,3,3,3,3,5,3,5,5,5,5,5,4,5,5,2,2,5,2,8,5,5,5,5,3,5,3,5,6,6,5,6,4,3,3,3,5,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,3,5,5,5,5,3,5,3,7,3,5,5,3,7,5,4,5,3,3,3,5,5,3,3,3,3,5,8,8,8,6,6,6,6,6,6,6,9,6,6,6,6,6,3,3,3,3,6,6,7,7,7,7,7,5,7,6,6,6,6,6,6,6,5,5,5,5,5,5,8,5,5,5,5,5,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5],
 heights =>
[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,4,6,6,9,7,2,3,3,4,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,10,7,7,7,7,7,6,8,7,3,5,7,6,9,7,8,7,8,7,7,7,7,7,9,7,7,6,3,3,3,5,6,3,6,6,5,6,6,3,6,6,3,3,4,3,9,6,6,6,6,3,4,3,6,5,7,5,5,5,3,3,3,6,8,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,3,6,3,7,4,6,6,3,7,6,4,5,3,3,3,6,5,3,3,3,4,6,8,8,8,6,7,7,7,7,7,7,10,7,7,7,7,7,3,3,3,3,7,7,8,8,8,8,8,6,8,7,7,7,7,7,7,6,6,6,6,6,6,6,9,5,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,5,6,6,6,6,6,5,6,5],
 heights =>
[13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,4,7,7,11,8,2,4,4,5,7,3,4,3,3,7,7,7,7,7,7,7,7,7,7,3,3,7,7,7,7,12,7,8,9,9,8,7,9,9,3,6,8,7,9,9,9,8,9,9,8,7,9,7,11,7,7,7,3,3,3,5,7,4,7,7,6,7,7,3,7,7,3,3,6,3,11,7,7,7,7,4,7,3,7,5,9,5,5,5,4,3,4,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,3,3,7,7,7,7,3,7,4,9,4,7,7,4,9,7,5,7,4,4,4,7,6,3,4,4,4,7,10,10,10,7,7,7,7,7,7,7,12,9,8,8,8,8,3,3,3,3,9,9,9,9,9,9,9,7,9,9,9,9,9,7,8,8,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,7,7,7,7,7,7,7,7,7,7,7,7,7,5,7,5],
 heights =>
[15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],
};

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'15px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[4,5,5,8,8,12,9,3,5,5,5,8,4,5,4,4,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,14,9,9,10,10,9,9,11,9,3,6,9,8,11,9,11,9,11,10,9,9,9,9,13,8,9,8,4,4,4,5,8,5,8,8,7,8,8,4,8,8,3,3,7,3,11,8,8,8,8,5,7,4,8,7,9,6,7,6,5,3,5,8,11,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,5,8,8,8,8,3,8,5,10,4,8,8,5,10,8,6,8,5,5,5,8,8,4,5,5,5,8,12,12,12,9,9,9,9,9,9,9,14,10,9,9,9,9,4,4,4,4,10,10,11,11,11,11,11,8,11,10,10,10,10,9,9,9,8,8,8,8,8,8,12,7,8,8,8,8,4,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,7],
 heights =>
[16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16],
};

$fontinfo{'Win32'}{'Netscape4'}{'sans-serif'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[6,6,7,11,11,18,13,4,7,7,8,12,6,7,6,6,11,11,11,11,11,11,11,11,11,11,6,6,12,12,12,11,20,13,13,14,14,13,12,16,13,6,10,13,11,17,13,16,13,16,14,13,12,13,13,19,13,14,12,6,6,6,8,11,7,11,11,10,11,11,6,11,10,4,4,10,4,16,10,11,11,11,7,10,6,10,9,15,9,10,9,7,6,7,12,15,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,6,6,11,11,11,11,6,11,7,15,7,11,12,7,15,11,8,11,7,7,7,11,11,6,7,7,7,11,17,17,17,12,13,13,13,13,13,13,20,14,13,13,13,13,6,6,6,6,14,14,16,16,16,16,16,12,16,14,14,14,14,13,13,12,11,11,11,11,11,11,18,10,11,11,11,11,6,6,6,6,11,11,11,11,11,11,11,11,11,11,11,11,11,10,11,10],
 heights =>
[23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23],
};

# Netscape4 4, Windows, Verdana

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'8px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,4,7,5,9,6,2,4,4,5,7,3,4,3,4,5,5,5,5,5,5,5,5,5,5,4,4,7,7,7,4,8,5,5,6,6,5,5,6,6,3,4,6,4,7,6,6,5,6,6,5,5,6,5,8,5,5,5,4,4,4,7,5,5,5,5,4,5,5,3,5,5,2,3,5,2,8,5,5,5,5,3,4,3,5,5,7,5,5,4,5,4,5,7,8,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,5,5,5,5,4,5,5,8,4,5,7,4,8,5,4,7,4,4,5,5,5,3,5,4,4,5,8,8,8,4,5,5,5,5,5,5,8,6,5,5,5,5,3,3,3,3,6,6,6,6,6,6,6,7,6,6,6,6,6,5,5,5,5,5,5,5,5,5,8,4,5,5,5,5,2,2,2,2,5,5,5,5,5,5,5,7,5,5,5,5,5,5,5,5],
 heights =>
[10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],
};

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,5,5,7,7,11,7,3,4,4,7,7,3,5,3,4,7,7,7,7,7,7,7,7,7,7,4,4,7,7,7,6,10,8,7,8,8,7,6,8,8,5,5,7,6,9,8,9,7,9,7,7,7,8,8,9,7,7,7,4,4,4,7,6,6,6,6,6,6,6,3,6,6,3,3,6,3,9,6,6,6,6,4,6,4,6,6,7,6,6,5,6,5,6,7,9,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,5,7,7,7,7,5,6,6,9,5,6,7,5,9,6,5,7,5,5,6,6,7,3,6,5,5,6,9,9,9,6,8,8,8,8,8,8,10,8,7,7,7,7,5,5,5,5,8,8,9,9,9,9,9,7,9,8,8,8,8,7,7,6,6,6,6,6,6,6,9,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,7,6,6,6,6,6,6,6,6],
 heights =>
[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[4,4,5,8,7,11,7,3,5,5,7,8,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,8,8,8,6,10,7,7,8,8,6,6,8,8,5,5,7,6,9,7,9,7,9,8,7,7,8,7,11,7,7,7,5,5,5,8,6,6,7,7,5,7,7,4,7,7,3,3,7,3,11,7,7,7,7,4,6,4,7,6,7,7,6,6,6,5,6,8,10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,7,7,7,7,5,6,6,10,5,6,8,5,10,6,5,8,5,5,6,7,7,4,6,5,5,6,10,10,10,6,7,7,7,7,7,7,10,8,6,6,6,6,5,5,5,5,8,7,9,9,9,9,9,8,9,8,8,8,8,7,7,6,7,7,7,7,7,7,10,5,7,7,7,7,3,3,3,3,6,7,7,7,7,7,7,8,7,7,7,7,7,6,7,6],
 heights =>
[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[4,5,6,10,8,13,9,3,5,5,8,9,4,5,4,5,8,8,8,8,8,8,8,8,8,8,5,5,9,9,9,7,12,8,8,9,9,8,7,9,9,5,5,8,7,10,9,10,8,10,8,8,7,9,8,13,8,7,8,5,5,5,10,8,8,8,8,6,8,8,4,8,8,3,4,7,3,11,8,8,8,8,5,7,5,8,7,11,7,7,7,8,5,8,10,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,5,8,8,8,8,5,8,8,12,7,8,9,5,12,8,7,9,7,7,8,8,8,4,8,7,7,8,12,12,12,7,8,8,8,8,8,8,12,9,8,8,8,8,5,5,5,5,9,9,10,10,10,10,10,10,10,9,9,9,9,7,8,7,8,8,8,8,8,8,11,6,8,8,8,8,3,3,3,3,7,8,8,8,8,8,8,9,8,8,8,8,8,7,8,7],
 heights =>
[14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14],
};

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'15px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[5,6,6,11,9,15,10,4,6,6,9,11,5,7,5,6,9,9,9,9,9,9,9,9,9,9,6,6,11,11,11,8,14,10,10,10,11,9,8,11,10,5,6,10,8,11,10,11,8,11,10,10,9,10,10,15,10,9,10,6,6,6,11,9,9,8,9,7,9,8,5,9,9,3,5,8,3,13,9,9,9,9,6,8,6,9,8,11,9,8,8,9,6,9,11,14,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,6,9,9,9,9,6,9,9,14,8,9,11,7,14,9,8,11,8,8,9,9,9,5,9,8,8,9,14,14,14,8,10,10,10,10,10,10,14,10,9,9,9,9,5,5,5,5,11,10,11,11,11,11,11,11,11,10,10,10,10,9,8,9,8,8,8,8,8,8,13,7,8,8,8,8,3,3,3,3,9,9,9,9,9,9,9,11,9,9,9,9,9,8,9,8],
 heights =>
[17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17],
};

$fontinfo{'Win32'}{'Netscape4'}{'verdana'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[7,8,9,16,13,22,15,5,9,9,13,16,7,9,7,9,13,13,13,13,13,13,13,13,13,13,9,9,16,16,16,11,20,14,14,14,15,13,12,16,15,8,9,14,11,17,15,16,12,16,14,14,12,15,14,20,14,12,14,9,9,9,16,13,13,12,12,10,12,12,7,12,13,6,7,12,6,19,13,12,12,12,9,10,8,13,12,16,12,12,11,13,9,13,16,20,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,7,8,13,13,13,13,9,13,13,20,11,13,16,9,20,13,11,16,11,11,13,13,13,7,13,11,11,13,20,20,20,11,14,14,14,14,14,14,19,14,13,13,13,13,8,8,8,8,16,15,16,16,16,16,16,16,16,15,15,15,15,12,12,12,12,12,12,12,12,12,19,10,12,12,12,12,6,6,6,6,12,13,12,12,12,12,12,16,12,13,13,13,13,12,12,12],
 heights =>
[25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25],
};

# Netscape 6, Windows, Verdana

$fontinfo{'Win32'}{'Netscape6'}{'verdana'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,8,7,11,7,3,5,5,7,8,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,8,8,8,6,10,7,7,8,8,6,6,8,8,5,5,7,6,9,7,9,7,9,8,7,7,8,7,11,7,7,7,5,5,5,8,6,6,7,7,5,7,7,4,7,7,3,3,7,3,11,7,7,7,7,4,6,4,7,6,7,7,6,6,6,5,6,8,10,6,8,6,6,6,6,6,6,6,6,6,6,6,8,6,8,8,6,6,6,6,6,6,6,3,3,6,6,6,8,7,6,4,4,7,7,7,7,5,6,6,10,5,6,8,0,10,6,5,8,5,5,6,7,7,4,6,5,5,6,10,10,10,6,7,7,7,7,7,7,10,8,6,6,6,6,5,5,5,5,8,7,9,9,9,9,9,8,9,8,8,8,8,7,7,6,7,7,7,7,7,7,10,5,7,7,7,7,3,3,3,3,6,7,7,7,7,7,7,8,7,7,7,7,7,6,7,6],
 heights => [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,2,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'Win32'}{'Netscape6'}{'verdana'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,9,7,12,8,3,5,5,7,9,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,9,9,9,6,10,8,8,9,9,7,6,9,8,5,5,8,6,9,8,9,7,9,8,8,7,8,8,11,8,7,8,5,5,5,9,7,7,7,7,6,7,7,4,7,7,3,4,7,3,11,7,7,7,7,5,6,4,7,7,9,7,7,6,7,5,7,9,11,6,8,6,6,6,6,6,6,6,6,6,6,6,8,6,8,8,6,6,6,6,6,6,6,4,4,6,6,6,8,7,6,4,4,7,7,7,7,5,7,7,11,6,7,9,0,11,7,6,9,6,6,7,7,7,4,7,6,6,7,11,11,11,6,8,8,8,8,8,8,11,9,7,7,7,7,5,5,5,5,9,8,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,7,7,7,7,7,7,7,9,7,7,7,7,7,7,7,7],
 heights => [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,2,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'Win32'}{'Netscape6'}{'verdana'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [7,8,9,16,13,22,15,5,9,9,13,16,7,9,7,9,13,13,13,13,13,13,13,13,13,13,9,9,16,16,16,11,20,14,14,14,15,13,12,16,15,8,9,14,11,17,15,16,12,16,14,14,12,15,14,20,14,12,14,9,9,9,16,13,13,12,12,10,12,12,7,12,13,6,7,12,6,19,13,12,12,12,9,10,8,13,12,16,12,12,11,13,9,13,16,20,11,12,11,11,11,11,11,11,11,11,11,11,11,12,11,12,12,11,11,11,11,11,11,11,7,7,11,11,11,12,13,11,7,8,13,13,13,13,9,13,13,20,11,13,16,0,20,13,11,16,11,11,13,13,13,7,13,11,11,13,20,20,20,11,14,14,14,14,14,14,19,14,13,13,13,13,8,8,8,8,16,15,16,16,16,16,16,16,16,15,15,15,15,12,12,12,12,12,12,12,12,12,19,10,12,12,12,12,6,6,6,6,12,13,12,12,12,12,12,16,12,13,13,13,13,12,12,12],
 heights => [25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,4,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25],
};

# Netscape 6, Mac, Verdana

$fontinfo{'MacPPC'}{'Netscape6'}{'verdana'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,8,7,11,7,3,5,5,7,8,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,8,8,8,6,10,7,7,8,8,6,6,8,8,5,5,7,6,9,7,9,7,9,8,7,7,8,7,11,7,7,7,5,5,5,8,6,6,7,7,5,7,7,4,7,7,3,3,7,3,11,7,7,7,7,4,6,4,7,6,7,7,6,6,6,5,6,8,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,4,4,7,7,6,7,5,6,6,10,5,6,8,0,10,6,5,8,5,5,6,7,7,4,6,5,5,6,18,18,18,6,7,7,7,7,7,7,10,8,6,6,6,6,5,5,5,5,8,7,9,9,9,9,9,8,9,8,8,8,8,6,6,6,7,7,7,7,7,7,10,5,7,7,7,7,3,3,3,3,6,7,7,7,7,7,7,8,7,7,7,7,7,6,6,6],
 heights => [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,2,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'MacPPC'}{'Netscape6'}{'verdana'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,9,7,12,8,3,5,5,7,9,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,9,9,9,6,10,8,8,9,9,7,6,9,8,5,5,8,6,9,8,9,7,9,8,8,7,8,8,11,8,7,8,5,5,5,9,7,7,7,7,6,7,7,4,7,7,3,4,7,3,11,7,7,7,7,5,6,4,7,7,9,7,7,6,7,5,7,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,4,4,7,7,7,7,5,7,7,11,6,7,9,0,11,7,6,9,6,6,7,7,7,4,7,6,6,7,18,18,18,6,8,8,8,8,8,8,11,9,7,7,7,7,5,5,5,5,9,8,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,7,7,7,7,7,7,7,9,7,7,7,7,7,7,7,7],
 heights => [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,2,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'MacPPC'}{'Netscape6'}{'verdana'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,5,6,10,8,13,9,3,5,5,8,9,4,5,4,5,8,8,8,8,8,8,8,8,8,8,5,5,9,9,9,7,12,8,8,9,9,8,7,9,9,5,5,8,7,10,9,10,8,10,8,8,7,9,8,13,8,7,8,5,5,5,10,8,8,8,8,6,8,8,4,8,8,3,4,7,3,11,8,8,8,8,5,7,5,8,7,11,7,7,7,8,5,8,10,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,4,5,8,8,8,8,5,8,8,12,7,8,9,0,12,8,7,9,7,7,8,8,8,4,8,7,7,8,20,20,20,7,8,8,8,8,8,8,12,9,8,8,8,8,5,5,5,5,9,9,10,10,10,10,10,10,10,9,9,9,9,7,7,7,8,8,8,8,8,8,11,6,8,8,8,8,3,3,3,3,7,8,8,8,8,8,8,9,8,8,8,8,8,7,7,7],
 heights => [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,3,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],
};

$fontinfo{'MacPPC'}{'Netscape6'}{'verdana'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [7,8,9,16,13,22,15,5,9,9,13,16,7,9,7,9,13,13,13,13,13,13,13,13,13,13,9,9,16,16,16,11,20,14,14,14,15,13,12,16,15,8,9,14,11,17,15,16,12,16,14,14,12,15,14,20,14,12,14,9,9,9,16,13,13,12,12,10,12,12,7,12,13,6,7,12,6,19,13,12,12,12,9,10,8,13,12,16,12,12,11,13,9,13,16,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,7,8,13,13,13,13,9,13,13,20,11,13,16,0,20,13,11,16,11,11,13,13,13,7,13,11,11,13,33,33,33,11,14,14,14,14,14,14,19,14,13,13,13,13,8,8,8,8,16,15,16,16,16,16,16,16,16,15,15,15,15,12,12,12,12,12,12,12,12,12,19,10,12,12,12,12,6,6,6,6,12,13,12,12,12,12,12,16,12,13,13,13,13,12,12,12],
 heights => [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,4,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24],
};

# MSIE5, Mac, Verdana

$fontinfo{'MacPPC'}{'Microsoft Internet Explorer'}{'verdana'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,8,7,11,7,3,5,5,7,8,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,8,8,8,6,10,7,7,8,8,6,6,8,8,5,5,7,6,9,7,9,7,9,8,7,7,8,7,11,7,7,7,5,5,5,8,6,6,7,7,5,7,7,4,7,7,3,3,7,3,11,7,7,7,7,4,6,4,7,6,7,7,6,6,6,5,6,8,10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,7,7,6,7,5,6,6,10,5,6,8,5,10,6,5,8,7,7,6,7,7,4,6,7,5,6,18,18,18,6,7,7,7,7,7,7,10,8,6,6,6,6,5,5,5,5,37,7,9,9,9,9,9,6,9,8,8,8,8,13,55,6,7,7,7,7,7,7,10,5,7,7,7,7,3,3,3,3,34,7,7,7,7,7,7,8,7,7,7,7,7,12,45,6],
 heights => [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'MacPPC'}{'Microsoft Internet Explorer'}{'verdana'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,4,5,9,7,12,8,3,5,5,7,9,4,5,4,5,7,7,7,7,7,7,7,7,7,7,5,5,9,9,9,6,10,8,8,9,9,7,6,9,8,5,5,8,6,9,8,9,7,9,8,8,7,8,8,11,8,7,8,5,5,5,9,7,7,7,7,6,7,7,4,7,7,3,4,7,3,11,7,7,7,7,5,6,4,7,7,9,7,7,6,7,5,7,9,11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,7,7,6,7,5,7,7,11,6,7,9,5,11,7,6,9,7,7,7,7,7,4,7,7,6,7,18,18,18,6,8,8,8,8,8,8,11,9,7,7,7,7,5,5,5,5,40,8,9,9,9,9,9,6,9,8,8,8,8,14,58,7,7,7,7,7,7,7,11,6,7,7,7,7,3,3,3,3,36,7,7,7,7,7,7,9,7,7,7,7,7,14,48,7],
 heights => [13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13],
};

$fontinfo{'MacPPC'}{'Microsoft Internet Explorer'}{'verdana'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [4,5,6,10,8,13,9,3,5,5,8,9,4,5,4,5,8,8,8,8,8,8,8,8,8,8,5,5,9,9,9,7,12,8,8,9,9,8,7,9,9,5,5,8,7,10,9,10,8,10,8,8,7,9,8,13,8,7,8,5,5,5,10,8,8,8,8,6,8,8,4,8,8,3,4,7,3,11,8,8,8,8,5,7,5,8,7,11,7,7,7,8,5,8,10,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,5,8,8,7,8,5,8,8,12,7,8,9,5,12,8,7,9,8,8,8,8,8,4,8,8,7,8,20,20,20,7,8,8,8,8,8,8,12,9,8,8,8,8,5,5,5,5,42,9,10,10,10,10,10,7,10,9,9,9,9,15,61,7,8,8,8,8,8,8,11,6,8,8,8,8,3,3,3,3,39,8,8,8,8,8,8,9,8,8,8,8,8,15,52,7],
 heights => [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15],
};

$fontinfo{'MacPPC'}{'Microsoft Internet Explorer'}{'verdana'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths => [7,8,9,16,13,22,15,5,9,9,13,16,7,9,7,9,13,13,13,13,13,13,13,13,13,13,9,9,16,16,16,11,20,14,14,14,15,13,12,16,15,8,9,14,11,17,15,16,12,16,14,14,12,15,14,20,14,12,14,9,9,9,16,13,13,12,12,10,12,12,7,12,13,6,7,12,6,19,13,12,12,12,9,10,8,13,12,16,12,12,11,13,9,13,16,20,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,7,8,13,13,11,13,9,13,13,20,11,13,16,9,20,13,11,16,13,13,13,13,13,7,13,13,11,13,33,33,33,11,14,14,14,14,14,14,19,14,13,13,13,13,8,8,8,8,72,15,16,16,16,16,16,11,16,15,15,15,15,25,104,12,12,12,12,12,12,12,19,10,12,12,12,12,6,6,6,6,65,13,12,12,12,12,12,16,12,13,13,13,13,25,87,12],
 heights => [24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24],
};

# Netscape 4, Linux, sans-serif (Helvetica)

$fontinfo{'LinuxELF2.2'}{'Netscape'}{'sans-serif'}{'10px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[2,2,4,6,6,8,7,2,3,3,4,7,2,7,2,3,6,6,6,6,6,6,6,6,6,6,2,2,6,4,6,6,10,7,7,7,7,7,7,7,7,2,4,7,6,8,7,7,7,7,7,7,4,7,7,9,7,7,7,3,2,2,6,6,2,6,6,4,6,4,4,6,6,2,2,4,2,7,6,6,6,6,4,4,4,4,6,7,6,6,4,3,2,3,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,6,6,6,7,2,6,4,8,3,6,7,3,8,3,4,6,3,3,2,4,6,2,2,2,3,6,8,8,8,6,7,7,7,7,7,7,9,7,7,7,7,7,2,3,3,3,7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,4,4,4,4,4,2,3,3,3,6,6,6,6,6,6,6,6,8,4,4,4,4,6,6,6],
 heights =>
[10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10],
};

$fontinfo{'LinuxELF2.2'}{'Netscape'}{'sans-serif'}{'11px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,4,6,6,9,8,3,4,4,4,6,3,7,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,5,6,6,11,7,7,8,8,7,6,8,8,3,5,7,6,9,8,8,7,8,7,7,5,8,7,9,7,7,7,3,3,3,6,6,3,5,6,5,6,5,4,6,6,2,2,5,2,8,6,6,6,6,4,5,4,5,6,8,6,5,5,3,3,3,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,5,6,3,6,3,9,4,6,7,4,9,3,4,6,3,3,3,5,6,3,3,3,4,6,9,9,9,6,7,7,7,7,7,7,10,8,7,7,7,7,3,3,3,3,8,8,8,8,8,8,8,6,8,8,8,8,8,7,7,5,5,5,5,5,5,5,8,5,5,5,5,5,2,2,2,3,6,5,6,6,6,6,6,6,6,5,5,5,5,5,6,5],
 heights =>
[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'LinuxELF2.2'}{'Netscape'}{'sans-serif'}{'12px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[3,3,4,6,6,9,8,3,4,4,4,6,3,7,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,5,6,6,11,7,7,8,8,7,6,8,8,3,5,7,6,9,8,8,7,8,7,7,5,8,7,9,7,7,7,3,3,3,6,6,3,5,6,5,6,5,4,6,6,2,2,5,2,8,6,6,6,6,4,5,4,5,6,8,6,5,5,3,3,3,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,5,6,3,6,3,9,4,6,7,4,9,3,4,6,3,3,3,5,6,3,3,3,4,6,9,9,9,6,7,7,7,7,7,7,10,8,7,7,7,7,3,3,3,3,8,8,8,8,8,8,8,6,8,8,8,8,8,7,7,5,5,5,5,5,5,5,8,5,5,5,5,5,2,2,2,2,6,5,6,6,6,6,6,6,6,5,5,5,5,5,6,5],
 heights =>
[12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12],
};

$fontinfo{'LinuxELF2.2'}{'Netscape'}{'sans-serif'}{'20px'} =
{
 firstchar => 32,
 lastchar => 255,
 widths =>
[5,6,5,10,10,16,13,4,6,6,7,10,5,11,5,5,10,10,10,10,10,10,10,10,10,10,5,5,10,11,10,10,18,13,13,14,14,13,12,15,14,6,10,14,11,16,14,15,13,15,14,13,12,14,13,18,13,13,12,5,5,5,9,11,4,11,11,10,11,10,6,11,10,4,4,9,4,16,10,11,11,11,6,9,6,10,10,14,10,10,9,6,5,6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,6,10,10,10,10,5,10,6,15,7,9,11,6,14,5,7,10,6,6,4,10,10,4,5,6,7,9,15,15,15,10,13,13,13,13,13,13,18,14,13,13,13,13,6,6,6,6,14,14,15,15,15,15,15,10,15,14,14,14,14,13,12,9,11,11,11,11,11,11,17,10,10,10,10,10,4,4,5,5,11,10,11,11,11,11,11,10,11,10,10,10,10,10,11,10],
 heights =>
[20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20],
};

sub combine_fontinfo {
    my(@fontinfo) = @_;
    my $fontinfo = {firstchar => $fontinfo[0]->{'firstchar'},
		    lastchar  => $fontinfo[0]->{'lastchar'}, # XXX better handling...
		   };
    foreach my $inx (0 .. $#{$fontinfo[0]{'widths'}}) {
	my($largest_width, $largest_height) = (0,0);
	foreach my $fi (@fontinfo) {
	    if ($fi->{'widths'}[$inx] > $largest_width) {
		$largest_width = $fi->{'widths'}[$inx];
	    }
	    if ($fi->{'heights'}[$inx] > $largest_height) {
		$largest_height = $fi->{'heights'}[$inx];
	    }
	}
	$fontinfo->{'widths'}[$inx]  = $largest_width;
	$fontinfo->{'heights'}[$inx] = $largest_height;
    }

    $fontinfo;
}

1;

__END__

=head1 NAME

WE_Frontend::FontInfo - font information per browser/OS/font

=head1 SYNOPSIS


=head1 DESCRIPTION

=head2 FONTINFO STRUCTURE

The fontinfo structure is a hash with the following elements:

=over 4

=item firstchar

The first character in the C<widths> and C<heights> arrays (usually 32
= space).

=item lastchar

The last character (usually 255).

=item widths

An array reference of the character widths from C<firstchar> to
C<lastchar>.

=item heights

An array reference of the character heights.

=back

Use the HTML/Javascript application C<html/fontsizer.html> to create
this structure for specific fonts on specific browsers on specific
operation systems.

=head2 FUNCTIONS

=over 4

=item combine_fontinfo($fontinfo, ...)

Combine the supplied fontinfos to one fontinfo that uses the largest
character widths and heights. Note: for now, the fontinfo widths and
heights arrays must have the same length.

=back

=head1 AUTHOR

Slaven Rezic - slaven@rezic.de

=head1 SEE ALSO

=cut

