exit 0 if $ENV{AUTOMATED_TESTING};
# This Makefile.PL for Plack-App-BeanstalkConsole was generated by
# inc::DownloadShareDirContent <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

# inserted by Dist::Zilla::Plugin::CheckBin 0.007
use Devel::CheckBin;
check_bin('php-cgi');

use 5.006;
use ExtUtils::MakeMaker;

BEGIN {
my %configure_requires = (
    'Archive::Extract' => '0',
    'Devel::CheckBin' => '0',
    'File::ShareDir::Install' => '0.03',
    'File::Spec' => '0',
    'File::Temp' => '0',
    'HTTP::Tiny' => '0',
    'Module::Build::Tiny' => '0.034',
);

my @missing = grep {
    ! eval "require $_; $_->VERSION($configure_requires{$_}); 1"
} keys %configure_requires;

if (@missing)
{
    if (not $ENV{PERL_MM_FALLBACK_SILENCE_WARNING})
    {
        warn <<'EOW';
*** WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING ***

If you're seeing this warning, your toolchain is really, really old* and you'll
almost certainly have problems installing CPAN modules from this century. But
never fear, dear user, for we have the technology to fix this!

If you're using CPAN.pm to install things, then you can upgrade it using:

    cpan CPAN

If you're using CPANPLUS to install things, then you can upgrade it using:

    cpanp CPANPLUS

If you're using cpanminus, you shouldn't be seeing this message in the first
place, so please file an issue on github.

If you're installing manually, please retrain your fingers to run Build.PL
when present instead.

This public service announcement was brought to you by the Perl Toolchain
Gang, the irc.perl.org #toolchain IRC channel, and the number 42.

----

* Alternatively, you are doing something overly clever, in which case you
should consider setting the 'prefer_installer' config option in CPAN.pm, or
'prefer_makefile' in CPANPLUS, to 'mb" and '0' respectively.

You can also silence this warning for future installations by setting the
PERL_MM_FALLBACK_SILENCE_WARNING environment variable.
EOW
        sleep 10 if -t STDIN && (-t STDOUT || !(-f STDOUT || -c STDOUT));
    }
}
} # end BEGIN

use File::ShareDir::Install;
# begin inc::DownloadShareDirContent (1)
use File::Spec;
use File::Temp 'tempdir';
use HTTP::Tiny;
use Archive::Extract;

my $archive_file = File::Spec->catfile(tempdir(CLEANUP => 1), 'master.zip');
print "downloading https://github.com/ptrofimov/beanstalk_console/archive/master.zip to $archive_file...
";
my $response = HTTP::Tiny->new->mirror('https://github.com/ptrofimov/beanstalk_console/archive/master.zip', $archive_file);
$response->{success} or die "failed to download https://github.com/ptrofimov/beanstalk_console/archive/master.zip into $archive_file";

my $extract_dir = '.';
my $share_dir = 'share';
my $ae = Archive::Extract->new(archive => $archive_file);
$ae->extract(to => $extract_dir) or die "failed to extract $archive_file to $extract_dir";
rename('beanstalk_console-master', $share_dir);

# ensure local data storage file is writable
chmod(0644, File::Spec->catfile($share_dir, 'storage.json'));

# end inc::DownloadShareDirContent (1)

# begin inc::DownloadShareDirContent (2)
install_share dist => $share_dir;
# end inc::DownloadShareDirContent (2)

my %WriteMakefileArgs = (
  "ABSTRACT" => "A web application that provides access to Beanstalk statistics and tools",
  "AUTHOR" => "Karen Etheridge <ether\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Archive::Extract" => 0,
    "Devel::CheckBin" => 0,
    "File::ShareDir::Install" => "0.03",
    "File::Spec" => 0,
    "File::Temp" => 0,
    "HTTP::Tiny" => 0,
    "Module::Build::Tiny" => "0.034"
  },
  "DISTNAME" => "Plack-App-BeanstalkConsole",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Plack::App::BeanstalkConsole",
  "PL_FILES" => {},
  "PREREQ_PM" => {
    "File::ShareDir" => 0,
    "Plack::App::PHPCGIFile" => 0,
    "Scalar::Util" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "HTTP::Request::Common" => 0,
    "Module::Metadata" => 0,
    "Plack::App::PHPCGI" => "0.05",
    "Plack::Test" => 0,
    "Test::File::ShareDir" => 0,
    "Test::More" => "0.88",
    "if" => 0
  },
  "VERSION" => "0.010",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "File::ShareDir" => 0,
  "File::Spec" => 0,
  "HTTP::Request::Common" => 0,
  "Module::Metadata" => 0,
  "Plack::App::PHPCGI" => "0.05",
  "Plack::App::PHPCGIFile" => 0,
  "Plack::Test" => 0,
  "Scalar::Util" => 0,
  "Test::File::ShareDir" => 0,
  "Test::More" => "0.88",
  "if" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}
