#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'alcatel/unknown.1.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'e8:e7:32:2b:c1:e2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'e8:e7:32:2b:c1:e2',
            MODELSNMP    => 'Networking2189',
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CB-C005-127-os6400',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.1.127',
                    ],
                },
                MAC          => 'e8:e7:32:2b:c1:e2',
                UPTIME       => '(1442631100) 166 days, 23:18:31.00',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFALIAS          => 'wifi-RDC-ascenseur-203',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1009388000) 116 days, 19:51:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2695194882',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462639524',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:6f:47:52:f9',
                                    '00:25:4b:71:76:ec',
                                    '10:93:e9:0f:d7:cc',
                                    'c4:85:08:3c:04:b0',
                                    '14:10:9f:d1:9a:db',
                                    'd8:24:bd:e8:79:20',
                                    'f0:b4:79:15:a4:03',
                                    '28:94:0f:d6:bd:94',
                                    '4c:0f:6e:fe:e9:78',
                                    '54:26:96:09:33:a4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFALIAS          => 'wifi-c005-espaceOne-205',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441734300) 166 days, 20:49:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2824635082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464602515',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '98:0c:82:c9:d4:70',
                                    'd8:24:bd:b4:92:c0',
                                    '28:94:0f:c1:1c:3b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFALIAS          => 'wifi-rdc-acceuil-47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492727000) 57 days, 0:41:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1952393561',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '211370716',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0c:ee:e6:b0:86:7a',
                                    '7c:d1:c3:f7:d7:c3',
                                    '98:b8:e3:66:fd:2c',
                                    'd8:24:bd:b4:92:b0',
                                    'dc:85:de:69:44:24',
                                    '28:94:0f:c1:1d:89',
                                    '28:cf:da:48:1f:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFALIAS          => 'CB-C005-202',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(128821500) 14 days, 21:50:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826699557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3448622558',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => 'Gi1/0/19',
                                IFDESCR  => 'GigabitEthernet1/0/19',
                                SYSNAME  => 'CB-C005-202.mgmt.dauphine.fr',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                SYSMAC   => 'b4:14:89:38:2d:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.1.127',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57238810) 6 days, 14:59:48.10',
                        IFINOCTETS       => '173601851',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205881648',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '1305305095',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1305406678',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CB-C005-127-os6400',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                FIRMWARE     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.1.127',
                    ],
                },
                MAC          => 'e8:e7:32:2b:c1:e2',
                UPTIME       => '(1442631100) 166 days, 23:18:31.00',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFALIAS          => 'wifi-RDC-ascenseur-203',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1009388000) 116 days, 19:51:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2695194882',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462639524',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:6f:47:52:f9',
                                    '00:25:4b:71:76:ec',
                                    '10:93:e9:0f:d7:cc',
                                    'c4:85:08:3c:04:b0',
                                    '14:10:9f:d1:9a:db',
                                    'd8:24:bd:e8:79:20',
                                    'f0:b4:79:15:a4:03',
                                    '28:94:0f:d6:bd:94',
                                    '4c:0f:6e:fe:e9:78',
                                    '54:26:96:09:33:a4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFALIAS          => 'wifi-c005-espaceOne-205',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441734300) 166 days, 20:49:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2824635082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464602515',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '98:0c:82:c9:d4:70',
                                    'd8:24:bd:b4:92:c0',
                                    '28:94:0f:c1:1c:3b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFALIAS          => 'wifi-rdc-acceuil-47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492727000) 57 days, 0:41:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1952393561',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '211370716',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0c:ee:e6:b0:86:7a',
                                    '7c:d1:c3:f7:d7:c3',
                                    '98:b8:e3:66:fd:2c',
                                    'd8:24:bd:b4:92:b0',
                                    'dc:85:de:69:44:24',
                                    '28:94:0f:c1:1d:89',
                                    '28:cf:da:48:1f:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFALIAS          => 'CB-C005-202',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(128821500) 14 days, 21:50:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826699557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3448622558',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => 'Gi1/0/19',
                                IFDESCR  => 'GigabitEthernet1/0/19',
                                SYSNAME  => 'CB-C005-202.mgmt.dauphine.fr',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                SYSMAC   => 'b4:14:89:38:2d:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.1.127',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57238810) 6 days, 14:59:48.10',
                        IFINOCTETS       => '173601851',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205881648',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '1305305095',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1305406678',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'alcatel/unknown.2.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'e8:e7:32:2b:c1:e2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'e8:e7:32:2b:c1:e2',
            MODELSNMP    => 'Networking2189',
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CP-153-127',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                MAC          => 'e8:e7:32:2b:c1:e2',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFLASTCHANGE     => '(163281300) 18 days, 21:33:33.00',
                        IFINOCTETS       => '11031705',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135933304',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFLASTCHANGE     => '(133316300) 15 days, 10:19:23.00',
                        IFINOCTETS       => '68783504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167030715',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:09',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:09',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFLASTCHANGE     => '(34170400) 3 days, 22:55:04.00',
                        IFINOCTETS       => '197055100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '347793172',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:2e',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:2e',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFLASTCHANGE     => '(34163100) 3 days, 22:53:51.00',
                        IFINOCTETS       => '257499013',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '408235574',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b0:fe',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b0:fe',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFLASTCHANGE     => '(34193000) 3 days, 22:58:50.00',
                        IFINOCTETS       => '603370409',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754298162',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:0c',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:0c',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFLASTCHANGE     => '(103428100) 11 days, 23:18:01.00',
                        IFINOCTETS       => '28001214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126345688',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:32',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:32',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFLASTCHANGE     => '(11700) 0:01:57.00',
                        IFINOCTETS       => '2236854165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1199596145',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '2025',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => 'e8:e7:32:27:63:f4',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFLASTCHANGE     => '(11801) 0:01:58.01',
                        IFINOCTETS       => '25252490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26159026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '3686859309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686952587',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CP-153-127',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                FIRMWARE     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                MAC          => 'e8:e7:32:2b:c1:e2',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFLASTCHANGE     => '(163281300) 18 days, 21:33:33.00',
                        IFINOCTETS       => '11031705',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135933304',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFLASTCHANGE     => '(133316300) 15 days, 10:19:23.00',
                        IFINOCTETS       => '68783504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167030715',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:09',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:09',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFLASTCHANGE     => '(34170400) 3 days, 22:55:04.00',
                        IFINOCTETS       => '197055100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '347793172',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:2e',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:2e',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFLASTCHANGE     => '(34163100) 3 days, 22:53:51.00',
                        IFINOCTETS       => '257499013',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '408235574',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b0:fe',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b0:fe',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFLASTCHANGE     => '(34193000) 3 days, 22:58:50.00',
                        IFINOCTETS       => '603370409',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754298162',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:0c',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:0c',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFLASTCHANGE     => '(103428100) 11 days, 23:18:01.00',
                        IFINOCTETS       => '28001214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126345688',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '00:80:9f:af:b1:32',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => '00:80:9f:af:b1:32',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFLASTCHANGE     => '(11700) 0:01:57.00',
                        IFINOCTETS       => '2236854165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1199596145',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '2025',
                                IFDESCR  => undef,
                                SYSNAME  => undef,
                                SYSDESCR => undef,
                                SYSMAC   => 'e8:e7:32:27:63:f4',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFLASTCHANGE     => '(11801) 0:01:58.01',
                        IFINOCTETS       => '25252490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26159026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '3686859309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686952587',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
);

plan skip_all => 'SNMP walks database required'
    if !$ENV{SNMPWALK_DATABASE};
plan tests => 4 * scalar keys %tests;

my ($dictionary, $index);
if ($ENV{SNMPMODELS_DICTIONARY}) {
    $dictionary = FusionInventory::Agent::Task::NetDiscovery::Dictionary->new(
        file => $ENV{SNMPMODELS_DICTIONARY}
    );
}
if ($ENV{SNMPMODELS_INDEX}) {
    $index = XML::TreePP->new()->parsefile($ENV{SNMPMODELS_INDEX});
}

foreach my $test (sort keys %tests) {
    my $snmp  = FusionInventory::Agent::SNMP::Mock->new(
        file => "$ENV{SNMPWALK_DATABASE}/$test"
    );

    # first test: discovery without dictionary
    my %device1 = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        \%device1,
        $tests{$test}->[0],
        "$test: discovery, without dictionary"
    );

    # second test: discovery, with dictipnary
    SKIP: {
        skip "SNMP dictionary required, skipping", 1 unless $dictionary;

        my %device2 = getDeviceInfo(
            snmp       => $snmp,
            datadir    => './share',
            dictionary => $dictionary,
        );
        cmp_deeply(
            \%device2,
            $tests{$test}->[1],
            "$test: discovery, with dictionary"
        );
    };

    # third test: inventory without model
    my $device3 = getDeviceFullInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        $device3,
        $tests{$test}->[2],
        "$test: inventory, without model"
    );

    # fourth test: inventory, with model
    SKIP: {
        my $model_id = $tests{$test}->[1]->{MODELSNMP};
        skip "SNMP models index required, skipping", 1 unless $index;
        skip "No model associated, skipping", 1 unless $model_id;
        my $model = loadModel($index->{$model_id});

        my $device4 = getDeviceFullInfo(
            snmp    => $snmp,
            datadir => './share',
            model   => $model
        );
        cmp_deeply(
            $device4,
            $tests{$test}->[3],
            "$test: inventory, with model"
        );
    };
}
