/*                                                                
**  Copyright (C) 2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* iraf.h
*
**/

#ifndef _IRAF_H
#define _IRAF_H

ParamList *IRAFParOpen (const char *psetname, const char *filename, const char *mode);
ParamList *IRAFStrOpen (const char *psetname, char *str);
Parameter *ParamPositional (ParamList * plist, int position, char *value);
Parameter *ParamCreate (char *name, VType type, int *mode, char *value,
			Parameter * mmptp);
VType PLookupType (ParamList * reference, char *name);
void ESCQuote (char *str);
char *ESCUnQuote (char *str);
char *locatepfile (const char *fname);
char *locateptemplate (char *fname, char *dname);
void mkpfilename (char *buf, char *dir, char *pkname, char *ltname,
		  char *extn);


#endif /* ! _IRAF_H */
