# Generated by default/object.tt
package Paws::CostExplorer::AnomalyDateInterval;
  use Moose;
  has EndDate => (is => 'ro', isa => 'Str');
  has StartDate => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::AnomalyDateInterval

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::AnomalyDateInterval object:

  $service_obj->Method(Att1 => { EndDate => $value, ..., StartDate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::AnomalyDateInterval object:

  $result = $service_obj->Method(...);
  $result->Att1->EndDate

=head1 DESCRIPTION

The time period for an anomaly.

=head1 ATTRIBUTES


=head2 EndDate => Str

The last date an anomaly was observed.


=head2 B<REQUIRED> StartDate => Str

The first date an anomaly was observed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

