package HPCD::uni::JobGroup;

### INCLUDES ######################################################################################

# safe Perl
use warnings;
use strict;
use Carp;
use File::Path qw(make_path remove_tree);
use MooseX::Types::Path::Class qw(Dir File);

use Moose::Role;

with 'HPCI::JobGroup' => { theDriver => 'HPCD::uni' };

sub _get_submit_command {
	my $self         = shift;
	my $run          = shift;
	my $shell_script = shift;

	my $output_file  = $run->_stdout;
	my $error_file   = $run->_stderr;

	return "exec $shell_script >$output_file 2>$error_file",
	    $self->_get_submit_timeouts($run->stage);
};

1;
