/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;

public abstract class AbstractCounter<E>
implements Counter<E> {
    @Override
    public double logIncrementCount(E key, double amount) {
        double count = SloppyMath.logAdd(this.getCount(key), amount);
        this.setCount(key, count);
        return this.getCount(key);
    }

    @Override
    public double incrementCount(E key, double amount) {
        double count = this.getCount(key) + amount;
        this.setCount(key, count);
        return this.getCount(key);
    }

    @Override
    public double incrementCount(E key) {
        return this.incrementCount(key, 1.0);
    }

    @Override
    public double decrementCount(E key, double amount) {
        return this.incrementCount(key, -amount);
    }

    @Override
    public double decrementCount(E key) {
        return this.incrementCount(key, -1.0);
    }

    @Override
    public void addAll(Counter<E> counter) {
        Counters.addInPlace(this, counter);
    }
}

