use Test::More tests => 74;

BEGIN { use_ok "Math::Interpolator::Robust"; }

BEGIN { use_ok "Math::Interpolator::Knot"; }

sub pt(@) { Math::Interpolator::Knot->new(@_) }

my $ipl = Math::Interpolator::Robust->new(
		pt(0, 1), pt(3, 5), pt(4, 6), pt(6, 5),
		pt(9, 5.75), pt(10, 10), pt(12, 12));

eval { $ipl->y(2.5); };
like $@, qr/\Adata does not extend to x=2\.5 /;

eval { $ipl->y(10.5); };
like $@, qr/\Adata does not extend to x=10\.5 /;

while(<DATA>) {
	my($x, $ok_y) = split;
	is sprintf("%.4f", $ipl->y($x)), $ok_y;
}

__DATA__
3.00 5.0000
3.10 5.1064
3.20 5.2126
3.30 5.3186
3.40 5.4242
3.50 5.5294
3.60 5.6338
3.70 5.7368
3.80 5.8372
3.90 5.9310
4.00 6.0000
4.10 6.0162
4.20 6.0041
4.30 5.9710
4.40 5.9226
4.50 5.8631
4.60 5.7960
4.70 5.7241
4.80 5.6497
4.90 5.5744
5.00 5.5000
5.10 5.4276
5.20 5.3583
5.30 5.2929
5.40 5.2323
5.50 5.1772
5.60 5.1280
5.70 5.0853
5.80 5.0495
5.90 5.0209
6.00 5.0000
6.10 4.9840
6.20 4.9701
6.30 4.9584
6.40 4.9489
6.50 4.9417
6.60 4.9369
6.70 4.9345
6.80 4.9345
6.90 4.9372
7.00 4.9425
7.10 4.9505
7.20 4.9613
7.30 4.9749
7.40 4.9916
7.50 5.0113
7.60 5.0342
7.70 5.0603
7.80 5.0898
7.90 5.1227
8.00 5.1592
8.10 5.1995
8.20 5.2435
8.30 5.2915
8.40 5.3436
8.50 5.3999
8.60 5.4605
8.70 5.5257
8.80 5.5956
8.90 5.6703
9.00 5.7500
9.10 5.9349
9.20 6.2882
9.30 6.7591
9.40 7.3018
9.50 7.8750
9.60 8.4411
9.70 8.9663
9.80 9.4195
9.90 9.7727
