package Test2::Manual::Contributing;

our $VERSION = '1.302213';

1;

__END__

=head1 NAME

Test2::Manual::Contributing - How to contribute to the Test2 project.

=head1 DESCRIPTION

This is a short manual page dedicated to helping people who wish to contribute
to the Test2 project.

=head1 WAYS TO HELP

=head2 REPORT BUGS

The easiest way to help is to report bugs when you find them. Bugs are a fact
of life when writing or using software. If you use Test2 long enough you are
likely to find a bug. When you find such a bug it would help us out if you
would submit a ticket.

=head3 BUG TRACKERS

Always try to find the preferred bug tracker for the module that has the bug.
Here are the big 3 for the main Test2 project:

=over 4

=item Test2/Test-Builder/Test-More/test-more

L<https://github.com/Test-More/test-more/issues>

=item Test2-Harness

L<https://github.com/Test-More/Test2-Harness/issues>

=back

=head2 SUBMIT PATCHES

You are welcome to fix bugs you find, or from the tracker. We also often accept
patches that add new features or update documentation. The preferred method of
submitting patches is a github pull request, that said we also accept patches
via email.

=head2 ADD/UPDATE DOCUMENTATION

Documentation can be flawed just like code can be. Documentation can also
become outdated. If you see some incorrect documentation, or documentation that
is missing, we would love to get a patch to fix it!

=head2 ANSWER QUESTIONS ON IRC/SLACK

We are always hanging out on L<irc://irc.perl.org>, the #perl-qa and #toolchain
channels are a good place to find us.

There is also a Test2 slack channel: L<https://perl-test2.slack.com>.

=head2 WRITE NEW TOOLS USING TEST2

Writing a new tool using Test2 is always a good way to contribute. When you
write a tool that you think is useful, it is nice to share it by putting it on
CPAN.

=head2 PORT OLD TOOLS TO TEST2

The C<Test::*> namespace has been around for a long time, and has a LOT of
tools. The C<Test2::Tools::*> namespace is fairly young, and has less tools.
Finding a useful old tool with no modern equivalent, and writing a port is a
very good use of your time.

=head1 SEE ALSO

L<Test2::Manual> - Primary index of the manual.

=head1 SOURCE

The source code repository for Test2-Manual can be found at
F<https://github.com/Test-More/test-more/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright Chad Granum E<lt>exodist@cpan.orgE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
