# Generated by default/object.tt
package Paws::WorkMail::FolderConfiguration;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Period => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMail::FolderConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMail::FolderConfiguration object:

  $service_obj->Method(Att1 => { Action => $value, ..., Period => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMail::FolderConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

The configuration applied to an organization's folders by its retention
policy.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => Str

The action to take on the folder contents at the end of the folder
configuration period.


=head2 B<REQUIRED> Name => Str

The folder name.


=head2 Period => Int

The period of time at which the folder configuration action is applied.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

