# Generated by default/object.tt
package Paws::Translate::InputDataConfig;
  use Moose;
  has ContentType => (is => 'ro', isa => 'Str', required => 1);
  has S3Uri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Translate::InputDataConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Translate::InputDataConfig object:

  $service_obj->Method(Att1 => { ContentType => $value, ..., S3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Translate::InputDataConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ContentType

=head1 DESCRIPTION

The input configuration properties for requesting a batch translation
job.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContentType => Str

Describes the format of the data that you submit to Amazon Translate as
input. You can specify one of the following multipurpose internet mail
extension (MIME) types:

=over

=item *

C<text/html>: The input data consists of one or more HTML files. Amazon
Translate translates only the text that resides in the C<html> element
in each file.

=item *

C<text/plain>: The input data consists of one or more unformatted text
files. Amazon Translate translates every character in this type of
input.

=item *

C<application/vnd.openxmlformats-officedocument.wordprocessingml.document>:
The input data consists of one or more Word documents (.docx).

=item *

C<application/vnd.openxmlformats-officedocument.presentationml.presentation>:
The input data consists of one or more PowerPoint Presentation files
(.pptx).

=item *

C<application/vnd.openxmlformats-officedocument.spreadsheetml.sheet>:
The input data consists of one or more Excel Workbook files (.xlsx).

=back

If you structure your input data as HTML, ensure that you set this
parameter to C<text/html>. By doing so, you cut costs by limiting the
translation to the contents of the C<html> element in each file.
Otherwise, if you set this parameter to C<text/plain>, your costs will
cover the translation of every character.


=head2 B<REQUIRED> S3Uri => Str

The URI of the AWS S3 folder that contains the input file. The folder
must be in the same Region as the API endpoint you are calling.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Translate>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

