# Generated by default/object.tt
package Paws::ServiceQuotas::ErrorReason;
  use Moose;
  has ErrorCode => (is => 'ro', isa => 'Str');
  has ErrorMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ServiceQuotas::ErrorReason

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ServiceQuotas::ErrorReason object:

  $service_obj->Method(Att1 => { ErrorCode => $value, ..., ErrorMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ServiceQuotas::ErrorReason object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorCode

=head1 DESCRIPTION

An error that explains why an action did not succeed.

=head1 ATTRIBUTES


=head2 ErrorCode => Str

Service Quotas returns the following error values:

=over

=item *

C<DEPENDENCY_ACCESS_DENIED_ERROR> - The caller does not have the
required permissions to complete the action. To resolve the error, you
must have permission to access the service or quota.

=item *

C<DEPENDENCY_THROTTLING_ERROR> - The service is throttling Service
Quotas.

=item *

C<DEPENDENCY_SERVICE_ERROR> - The service is not available.

=item *

C<SERVICE_QUOTA_NOT_AVAILABLE_ERROR> - There was an error in Service
Quotas.

=back



=head2 ErrorMessage => Str

The error message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ServiceQuotas>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

