# Generated by default/object.tt
package Paws::SecurityHub::NetworkHeader;
  use Moose;
  has Destination => (is => 'ro', isa => 'Paws::SecurityHub::NetworkPathComponentDetails');
  has Protocol => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Paws::SecurityHub::NetworkPathComponentDetails');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::NetworkHeader

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::NetworkHeader object:

  $service_obj->Method(Att1 => { Destination => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::NetworkHeader object:

  $result = $service_obj->Method(...);
  $result->Att1->Destination

=head1 DESCRIPTION

Details about a network path component that occurs before or after the
current component.

=head1 ATTRIBUTES


=head2 Destination => L<Paws::SecurityHub::NetworkPathComponentDetails>

Information about the destination of the component.


=head2 Protocol => Str

The protocol used for the component.


=head2 Source => L<Paws::SecurityHub::NetworkPathComponentDetails>

Information about the origin of the component.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

