# Generated by default/object.tt
package Paws::SageMaker::RetryStrategy;
  use Moose;
  has MaximumRetryAttempts => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::RetryStrategy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::RetryStrategy object:

  $service_obj->Method(Att1 => { MaximumRetryAttempts => $value, ..., MaximumRetryAttempts => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::RetryStrategy object:

  $result = $service_obj->Method(...);
  $result->Att1->MaximumRetryAttempts

=head1 DESCRIPTION

The retry strategy to use when a training job fails due to an
C<InternalServerError>. C<RetryStrategy> is specified as part of the
C<CreateTrainingJob> and C<CreateHyperParameterTuningJob> requests. You
can add the C<StoppingCondition> parameter to the request to limit the
training time for the complete job.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MaximumRetryAttempts => Int

The number of times to retry the job. When the job is retried, it's
C<SecondaryStatus> is changed to C<STARTING>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

