# Generated by default/object.tt
package Paws::Quicksight::ColumnLevelPermissionRule;
  use Moose;
  has ColumnNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Principals => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::ColumnLevelPermissionRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::ColumnLevelPermissionRule object:

  $service_obj->Method(Att1 => { ColumnNames => $value, ..., Principals => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::ColumnLevelPermissionRule object:

  $result = $service_obj->Method(...);
  $result->Att1->ColumnNames

=head1 DESCRIPTION

A rule defined to grant access on one or more restricted columns. Each
dataset can have multiple rules. To create a restricted column, you add
it to one or more rules. Each rule must contain at least one column and
at least one user or group. To be able to see a restricted column, a
user or group needs to be added to a rule for that column.

=head1 ATTRIBUTES


=head2 ColumnNames => ArrayRef[Str|Undef]

An array of column names.


=head2 Principals => ArrayRef[Str|Undef]

An array of Amazon Resource Names (ARNs) for QuickSight users or
groups.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

